/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.env.IRecordComponent;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;

public class HierarchyBinaryType
implements IBinaryType {
    private int modifiers;
    private char[] sourceName;
    private char[] name;
    private char[] enclosingTypeName;
    private char[] superclass;
    private char[][] superInterfaces = NoInterface;
    private char[][] typeParameterSignatures;
    private char[] genericSignature;

    public HierarchyBinaryType(int modifiers, char[] qualification, char[] sourceName, char[] enclosingTypeName, char[][] typeParameterSignatures, char typeSuffix) {
        this.modifiers = modifiers;
        this.sourceName = sourceName;
        if (enclosingTypeName == null) {
            this.name = CharOperation.concat((char[])qualification, (char[])sourceName, (char)'/');
        } else {
            this.name = CharOperation.concat((char[])qualification, (char)'/', (char[])enclosingTypeName, (char)'$', (char[])sourceName);
            this.enclosingTypeName = CharOperation.concat((char[])qualification, (char[])enclosingTypeName, (char)'/');
            CharOperation.replace((char[])this.enclosingTypeName, (char)'.', (char)'/');
        }
        this.typeParameterSignatures = typeParameterSignatures;
        CharOperation.replace((char[])this.name, (char)'.', (char)'/');
    }

    public HierarchyBinaryType(int modifiers, char[] binaryName, char[] sourceName, char[] enclosingTypeBinaryName, char[][] typeParameterSignatures) {
        this.modifiers = modifiers;
        this.sourceName = sourceName;
        this.name = binaryName;
        this.enclosingTypeName = enclosingTypeBinaryName;
        this.typeParameterSignatures = typeParameterSignatures;
        if (typeParameterSignatures != null) {
            char[][] cArray = typeParameterSignatures;
            int n = typeParameterSignatures.length;
            int n2 = 0;
            while (n2 < n) {
                char[] next = cArray[n2];
                if (next == null) {
                    throw new IllegalArgumentException("Parameter's type signature must not be null");
                }
                ++n2;
            }
        }
    }

    public IBinaryAnnotation[] getAnnotations() {
        return null;
    }

    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return null;
    }

    public char[] getEnclosingMethod() {
        return null;
    }

    public char[] getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    public IBinaryField[] getFields() {
        return null;
    }

    public char[] getFileName() {
        return null;
    }

    public char[] getGenericSignature() {
        if (this.typeParameterSignatures != null && this.genericSignature == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append('<');
            int i = 0;
            int length = this.typeParameterSignatures.length;
            while (i < length) {
                buffer.append(this.typeParameterSignatures[i]);
                ++i;
            }
            buffer.append('>');
            if (this.superclass == null) {
                buffer.append(Signature.createTypeSignature("java.lang.Object", true));
            } else {
                buffer.append(Signature.createTypeSignature(this.superclass, true));
            }
            if (this.superInterfaces != null) {
                i = 0;
                length = this.superInterfaces.length;
                while (i < length) {
                    buffer.append(Signature.createTypeSignature(this.superInterfaces[i], true));
                    ++i;
                }
            }
            this.genericSignature = buffer.toString().toCharArray();
            CharOperation.replace((char[])this.genericSignature, (char)'.', (char)'/');
        }
        return this.genericSignature;
    }

    public char[][] getInterfaceNames() {
        return this.superInterfaces;
    }

    public IBinaryNestedType[] getMemberTypes() {
        return null;
    }

    public IBinaryMethod[] getMethods() {
        return null;
    }

    public char[][][] getMissingTypeNames() {
        return null;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public char[] getName() {
        return this.name;
    }

    public char[] getSourceName() {
        return this.sourceName;
    }

    public char[] getSuperclassName() {
        return this.superclass;
    }

    public long getTagBits() {
        return 0L;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isBinaryType() {
        return true;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isRecord() {
        return false;
    }

    public boolean isMember() {
        return false;
    }

    public void recordSuperType(char[] superTypeName, char[] superQualification, char superClassOrInterface) {
        int length;
        if (superQualification != null && superQualification[(length = superQualification.length) - 1] == '$') {
            char[] enclosingSuperName = CharOperation.lastSegment((char[])superQualification, (char)'.');
            superTypeName = CharOperation.concat((char[])enclosingSuperName, (char[])superTypeName);
            superQualification = CharOperation.subarray((char[])superQualification, (int)0, (int)(length - enclosingSuperName.length - 1));
        }
        if (superClassOrInterface == 'C') {
            if (TypeDeclaration.kind((int)this.modifiers) == 2) {
                return;
            }
            char[] encodedName = CharOperation.concat((char[])superQualification, (char[])superTypeName, (char)'/');
            CharOperation.replace((char[])encodedName, (char)'.', (char)'/');
            this.recordSuperclass(encodedName);
        } else {
            char[] encodedName = CharOperation.concat((char[])superQualification, (char[])superTypeName, (char)'/');
            CharOperation.replace((char[])encodedName, (char)'.', (char)'/');
            this.recordInterface(encodedName);
        }
    }

    public void recordSuperclass(char[] binaryName) {
        this.superclass = binaryName;
    }

    public void recordInterface(char[] binaryName) {
        if (this.superInterfaces == NoInterface) {
            this.superInterfaces = new char[][]{binaryName};
        } else {
            int length = this.superInterfaces.length;
            char[][] cArrayArray = new char[length + 1][];
            this.superInterfaces = cArrayArray;
            System.arraycopy(this.superInterfaces, 0, cArrayArray, 0, length);
            this.superInterfaces[length] = binaryName;
        }
    }

    public char[] sourceFileName() {
        return null;
    }

    public String toString() {
        int length;
        StringBuilder buffer = new StringBuilder();
        if (this.modifiers == 1) {
            buffer.append("public ");
        }
        switch (TypeDeclaration.kind((int)this.modifiers)) {
            case 1: {
                buffer.append("class ");
                break;
            }
            case 2: {
                buffer.append("interface ");
                break;
            }
            case 3: {
                buffer.append("enum ");
                break;
            }
            case 5: {
                buffer.append("record ");
            }
        }
        if (this.name != null) {
            buffer.append(this.name);
        }
        if (this.superclass != null) {
            buffer.append("\n  extends ");
            buffer.append(this.superclass);
        }
        if (this.superInterfaces != null && (length = this.superInterfaces.length) != 0) {
            buffer.append("\n implements ");
            int i = 0;
            while (i < length) {
                buffer.append(this.superInterfaces[i]);
                if (i != length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    public ITypeAnnotationWalker enrichWithExternalAnnotationsFor(ITypeAnnotationWalker walker, Object member, LookupEnvironment environment) {
        return walker;
    }

    public char[] getModule() {
        return null;
    }

    public BinaryTypeBinding.ExternalAnnotationStatus getExternalAnnotationStatus() {
        return BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED;
    }

    public IRecordComponent[] getRecordComponents() {
        return null;
    }
}

