/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.editors;

import de.vonloesch.pdf4eclipse.Activator;
import de.vonloesch.pdf4eclipse.Messages;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class StatusLinePageSelector
extends ContributionItem {
    private static final int DEFAULT_CHAR_WIDTH = 40;
    private int charWidth;
    private Text pageField;
    private Label pageNrField;
    private Image imageFirst;
    private Image imagePrev;
    private Image imageNext;
    private Image imageLast;
    private ToolItem firstPage;
    private ToolItem prevPage;
    private ToolItem nextPage;
    private ToolItem lastPage;
    private int page;
    private int lastPageNr;
    private List<IPageChangeListener> listeners;
    private Composite statusLine = null;

    public StatusLinePageSelector(String id) {
        this(id, 40);
    }

    public StatusLinePageSelector(String id, int charWidth) {
        super(id);
        this.charWidth = charWidth;
        this.setVisible(false);
    }

    public void addPageChangeListener(IPageChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<IPageChangeListener>();
        }
        this.listeners.add(l);
    }

    public void setPageChangeListener(IPageChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<IPageChangeListener>();
        }
        this.listeners.clear();
        this.listeners.add(l);
    }

    public void removePageChangeListener(IPageChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<IPageChangeListener>();
        }
        this.listeners.remove(l);
    }

    protected void firePageNrChangeListener() {
        if (this.listeners == null) {
            return;
        }
        for (IPageChangeListener l : this.listeners) {
            l.pageChange(Integer.parseInt(this.pageField.getText()));
        }
    }

    private boolean checkPage() {
        String st = this.pageField.getText();
        try {
            int i = Integer.parseInt(st);
            return i >= 1 && i <= this.lastPageNr;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public void fill(Composite parent) {
        this.statusLine = parent;
        Label sep = new Label(parent, 2);
        Composite c = new Composite(parent, 524288);
        c.setLayout((Layout)new GridLayout(4, false));
        ToolBar bar1 = new ToolBar(c, 0x800000);
        this.firstPage = new ToolItem(bar1, 0x800000);
        this.imageFirst = Activator.getImageDescriptor("icons/arrow-stop-180.png").createImage();
        this.firstPage.setImage(this.imageFirst);
        this.firstPage.setToolTipText(Messages.StatusLinePageSelector_ButtonFirst);
        this.firstPage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatusLinePageSelector.this.pageField.setText("1");
                StatusLinePageSelector.this.firePageNrChangeListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.prevPage = new ToolItem(bar1, 0x800000);
        this.imagePrev = Activator.getImageDescriptor("icons/arrow-180.png").createImage();
        this.prevPage.setImage(this.imagePrev);
        this.prevPage.setToolTipText(Messages.StatusLinePageSelector_ButtonPrevious);
        this.prevPage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatusLinePageSelector.this.pageField.setText("" + (StatusLinePageSelector.this.page - 1));
                StatusLinePageSelector.this.firePageNrChangeListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.page == 1) {
            this.prevPage.setEnabled(false);
            this.firstPage.setEnabled(false);
        }
        this.pageField = new Text(c, 133124);
        this.pageField.setToolTipText(Messages.StatusLinePageSelector_tooltip);
        this.pageField.setTextLimit(("" + this.lastPageNr).length());
        this.pageNrField = new Label(c, 32);
        this.pageNrField.setText(" / " + this.lastPageNr);
        ToolBar bar2 = new ToolBar(c, 0x800000);
        this.imageNext = Activator.getImageDescriptor("icons/arrow.png").createImage();
        this.nextPage = new ToolItem(bar2, 0x800000);
        this.nextPage.setImage(this.imageNext);
        this.nextPage.setToolTipText(Messages.StatusLinePageSelector_ButtonNext);
        this.nextPage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatusLinePageSelector.this.pageField.setText("" + (StatusLinePageSelector.this.page + 1));
                StatusLinePageSelector.this.firePageNrChangeListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.imageLast = Activator.getImageDescriptor("icons/arrow-stop.png").createImage();
        this.lastPage = new ToolItem(bar2, 0x800000);
        this.lastPage.setImage(this.imageLast);
        this.lastPage.setToolTipText(Messages.StatusLinePageSelector_ButtonLast);
        this.lastPage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatusLinePageSelector.this.pageField.setText("" + StatusLinePageSelector.this.lastPageNr);
                StatusLinePageSelector.this.firePageNrChangeListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.page == this.lastPageNr) {
            this.lastPage.setEnabled(false);
            this.nextPage.setEnabled(false);
        }
        this.pageField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 8 || e.keyCode == 127 || e.character >= '0' && e.character <= '9') {
                    return;
                }
                if (e.keyCode == 0x1000005 && StatusLinePageSelector.this.page > 1) {
                    StatusLinePageSelector.this.pageField.setText("" + (StatusLinePageSelector.this.page - 1));
                    StatusLinePageSelector.this.firePageNrChangeListener();
                } else if (e.keyCode == 0x1000006 && StatusLinePageSelector.this.page < StatusLinePageSelector.this.lastPageNr) {
                    StatusLinePageSelector.this.pageField.setText("" + (StatusLinePageSelector.this.page + 1));
                    StatusLinePageSelector.this.firePageNrChangeListener();
                }
                if (e.character == '\u0000') {
                    return;
                }
                e.doit = false;
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    if (!StatusLinePageSelector.this.checkPage()) {
                        MessageDialog.openError((Shell)StatusLinePageSelector.this.statusLine.getShell(), (String)Messages.StatusLinePageSelector_errorMsg1, (String)(String.valueOf(Messages.StatusLinePageSelector_errorMsg2) + StatusLinePageSelector.this.lastPageNr));
                        e.doit = false;
                        return;
                    }
                    StatusLinePageSelector.this.firePageNrChangeListener();
                }
            }
        });
        GC gc = new GC((Drawable)this.statusLine);
        gc.setFont(this.statusLine.getFont());
        FontMetrics fm = gc.getFontMetrics();
        int widthHint = fm.getAverageCharWidth() * this.charWidth;
        int heightHint = fm.getHeight();
        GridData d = new GridData(fm.getAverageCharWidth() * 4 + this.pageField.getBorderWidth(), fm.getHeight() + this.pageField.getBorderWidth());
        this.pageField.setLayoutData((Object)d);
        this.pageField.setText("" + this.page);
        gc.dispose();
        StatusLineLayoutData data = new StatusLineLayoutData();
        data.widthHint = widthHint + (this.imageFirst.getBounds().width + 9) * 4;
        data.heightHint = 0;
        c.setLayoutData((Object)data);
        data = new StatusLineLayoutData();
        data.heightHint = heightHint;
        sep.setLayoutData((Object)data);
    }

    public Point getDisplayLocation() {
        if (this.pageField != null && this.statusLine != null) {
            return this.statusLine.toDisplay(this.pageField.getLocation());
        }
        return null;
    }

    public void setPageInfo(int page, int pageNumbers) {
        this.page = page;
        this.lastPageNr = pageNumbers;
        if (this.pageField != null && !this.pageField.isDisposed()) {
            this.pageField.setTextLimit(("" + this.lastPageNr).length());
            this.pageField.setText("" + this.page);
        }
        if (this.pageNrField != null && !this.pageNrField.isDisposed()) {
            this.pageNrField.setText(" / " + this.lastPageNr);
            if (page == 1) {
                this.prevPage.setEnabled(false);
                this.firstPage.setEnabled(false);
            } else {
                this.prevPage.setEnabled(true);
                this.firstPage.setEnabled(true);
            }
            if (page == this.lastPageNr) {
                this.nextPage.setEnabled(false);
                this.lastPage.setEnabled(false);
            } else {
                this.nextPage.setEnabled(true);
                this.lastPage.setEnabled(true);
            }
        }
        if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager contributionManager = this.getParent();
            if (contributionManager != null) {
                contributionManager.update(true);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.imageFirst != null) {
            this.imageFirst.dispose();
        }
        if (this.imageLast != null) {
            this.imageLast.dispose();
        }
        if (this.imageNext != null) {
            this.imageNext.dispose();
        }
        if (this.imagePrev != null) {
            this.imagePrev.dispose();
        }
    }

    public static interface IPageChangeListener {
        public void pageChange(int var1);
    }
}

