/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.modanalyzer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import pcal.Validator;
import tla2sany.drivers.SemanticException;
import tla2sany.modanalyzer.ModuleContext;
import tla2sany.modanalyzer.ModulePointer;
import tla2sany.modanalyzer.ModuleRelationships;
import tla2sany.modanalyzer.ModuleRelatives;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.output.SanyOutput;
import tla2sany.parser.ParseException;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Vector;
import tlc2.tool.Action;
import tlc2.tool.Defns;
import tlc2.tool.impl.SpecProcessor;
import util.FileUtil;
import util.FilenameToStream;
import util.NamedInputStream;
import util.ToolIO;

public class SpecObj {
    String primaryFileName;
    final ExternalModuleTable externalModuleTable = new ExternalModuleTable();
    public final Vector<String> semanticAnalysisVector = new Vector();
    public Hashtable<String, ParseUnit> parseUnitContext = new Hashtable();
    private ModuleRelationships moduleRelationshipsSpec = new ModuleRelationships();
    private FilenameToStream resolver = null;
    ParseUnit rootParseUnit = null;
    ModulePointer rootModule = null;
    String rootModuleName;
    public Errors parseErrors = new Errors();
    public Errors semanticErrors = new Errors();
    public int errorLevel = 0;
    String nextParseUnitName = "";
    ModulePointer nextExtenderOrInstancerModule = null;
    boolean extentionFound;
    boolean instantiationFound;

    @Deprecated
    public SpecObj(String pfn) {
        this(pfn, null);
    }

    public SpecObj(String pfn, FilenameToStream ntfis) {
        if (ntfis == null) {
            ntfis = ToolIO.getDefaultResolver();
        }
        this.primaryFileName = pfn;
        this.resolver = ntfis;
    }

    public final int getErrorLevel() {
        return this.errorLevel;
    }

    public final String getName() {
        return this.rootModuleName;
    }

    public final void setName(String name) {
        this.rootModuleName = name;
    }

    public final String getFileName() {
        return this.primaryFileName;
    }

    public final ModuleNode getRootModule() {
        return this.getExternalModuleTable().getRootModule();
    }

    public final ExternalModuleTable getExternalModuleTable() {
        return this.externalModuleTable;
    }

    public final Errors getParseErrors() {
        return this.parseErrors;
    }

    public final Errors getSemanticErrors() {
        return this.semanticErrors;
    }

    public Set<String> getModuleNames() {
        HashSet<String> s = new HashSet<String>();
        Enumeration<ModulePointer> modules = this.getModules();
        while (modules.hasMoreElements()) {
            s.add(modules.nextElement().getName());
        }
        return s;
    }

    public final Enumeration<ModulePointer> getModules() {
        return this.moduleRelationshipsSpec.getKeys();
    }

    final ModuleRelationships getModuleRelationships() {
        return this.moduleRelationshipsSpec;
    }

    protected ParseUnit findOrCreateParsedUnit(String name, Errors errors, boolean firstCall, SanyOutput out) throws AbortException {
        ParseUnit parseUnit = this.parseUnitContext.get(name);
        if (parseUnit == null) {
            NamedInputStream nis = this.rootParseUnit != null ? FileUtil.createNamedInputStream(name, this.resolver, this.rootParseUnit.getNis()) : FileUtil.createNamedInputStream(name, this.resolver);
            if (nis != null) {
                parseUnit = new ParseUnit(this, nis);
                this.parseUnitContext.put(parseUnit.getName(), parseUnit);
            } else {
                if (this.nextExtenderOrInstancerModule == null) {
                    throw errors.addError(ErrorCode.MODULE_FILE_CANNOT_BE_FOUND, Location.nullLoc, "Cannot find source file for module " + name);
                }
                throw errors.addError(ErrorCode.MODULE_FILE_CANNOT_BE_FOUND, Location.moduleLocation(this.nextExtenderOrInstancerModule.getName()), "Cannot find source file for module " + name + " imported in module " + this.nextExtenderOrInstancerModule.getName() + ".");
            }
        }
        parseUnit.parseFile(errors, firstCall, name, this.rootParseUnit, out);
        return parseUnit;
    }

    private void calculateDependencies(ParseUnit currentParseUnit) {
        int i;
        Vector<ParseUnit> extendees = currentParseUnit.getExtendees();
        Vector<ParseUnit> instancees = currentParseUnit.getInstancees();
        for (i = 0; i < extendees.size(); ++i) {
            this.calculateDependencies(extendees.elementAt(i));
        }
        for (i = 0; i < instancees.size(); ++i) {
            this.calculateDependencies(instancees.elementAt(i));
        }
        if (!this.semanticAnalysisVector.contains(currentParseUnit.getName())) {
            this.semanticAnalysisVector.addElement(currentParseUnit.getName());
        }
    }

    private String pathToString(Vector<ParseUnit> path) {
        Object ret = "";
        for (int i = 0; i < path.size(); ++i) {
            ret = (String)ret + path.elementAt(i).getFileName() + " --> ";
        }
        return (String)ret + path.elementAt(0).getFileName();
    }

    private void nonCircularityTest(ParseUnit parseUnit, Errors errors) throws AbortException {
        HashSet<ParseUnit> alreadyVisited = new HashSet<ParseUnit>();
        Vector<ParseUnit> circularPath = new Vector<ParseUnit>();
        circularPath.addElement(parseUnit);
        this.nonCircularityBody(parseUnit, parseUnit, errors, alreadyVisited, circularPath);
    }

    private void nonCircularityBody(ParseUnit parseUnit, ParseUnit candidate, Errors errors, Set<ParseUnit> alreadyVisited, Vector<ParseUnit> circularPath) throws AbortException {
        if (alreadyVisited.contains(candidate)) {
            return;
        }
        alreadyVisited.add(candidate);
        Vector<ParseUnit> referencees = candidate.getExtendees();
        referencees.appendNoRepeats(candidate.getInstancees());
        for (int i = 0; i < referencees.size(); ++i) {
            ParseUnit referencee = referencees.elementAt(i);
            if (referencee == parseUnit) {
                throw errors.addError(ErrorCode.MODULE_DEPENDENCIES_ARE_CIRCULAR, Location.nullLoc, "Circular dependency among .tla files; dependency cycle is:\n\n  " + this.pathToString(circularPath));
            }
            circularPath.addElement(referencee);
            this.nonCircularityBody(parseUnit, referencee, errors, alreadyVisited, circularPath);
            circularPath.removeElementAt(circularPath.size() - 1);
        }
    }

    private boolean findNextUnresolvedExtention(ModulePointer currentModule) {
        HashSet<ModulePointer> alreadyVisited = new HashSet<ModulePointer>();
        return this.findNextUnresolvedExtentionBody(currentModule, alreadyVisited);
    }

    private boolean findNextUnresolvedExtentionBody(ModulePointer currentModule, HashSet<ModulePointer> alreadyVisited) {
        int i;
        if (alreadyVisited.contains(currentModule)) {
            this.extentionFound = false;
            return false;
        }
        alreadyVisited.add(currentModule);
        ModuleContext currentContext = currentModule.getContext();
        Vector<String> extendees = currentModule.getNamesOfModulesExtended();
        Vector<String> instancees = currentModule.getNamesOfModulesInstantiated();
        for (i = 0; i < extendees.size(); ++i) {
            if (currentContext.resolve(extendees.elementAt(i)) != null) continue;
            this.nextParseUnitName = extendees.elementAt(i);
            this.nextExtenderOrInstancerModule = currentModule;
            this.extentionFound = true;
            return true;
        }
        for (i = 0; i < extendees.size(); ++i) {
            if (!this.findNextUnresolvedExtentionBody(currentContext.resolve(extendees.elementAt(i)), alreadyVisited)) continue;
            this.extentionFound = true;
            return true;
        }
        for (i = 0; i < instancees.size(); ++i) {
            if (currentContext.resolve(instancees.elementAt(i)) == null || !this.findNextUnresolvedExtentionBody(currentContext.resolve(instancees.elementAt(i)), alreadyVisited)) continue;
            this.extentionFound = true;
            return true;
        }
        Vector<ModulePointer> innerModules = currentModule.getDirectInnerModules();
        for (int i2 = 0; i2 < innerModules.size(); ++i2) {
            if (!this.findNextUnresolvedExtentionBody(innerModules.elementAt(i2), alreadyVisited)) continue;
            this.extentionFound = true;
            return true;
        }
        this.extentionFound = false;
        return false;
    }

    private boolean findNextUnresolvedInstantiation(ModulePointer currentModule) {
        HashSet<ModulePointer> alreadyVisited = new HashSet<ModulePointer>();
        return this.findNextUnresolvedInstantiationBody(currentModule, alreadyVisited);
    }

    private boolean instanceResolvesToInternalModule(ModulePointer currentModule, String instanceeName) {
        TreeNode body = currentModule.getBody();
        HashSet<String> internalModulesSeen = new HashSet<String>();
        for (int i = 0; i < body.heirs().length; ++i) {
            int nonLocalInstanceNodeIX;
            TreeNode[] instanceHeirs;
            String instanceModuleName;
            TreeNode def = body.heirs()[i];
            if (def.getImage().equals("N_Module")) {
                String innerModuleName = def.heirs()[0].heirs()[1].getImage();
                internalModulesSeen.add(innerModuleName);
                continue;
            }
            if (!(def.getImage().equals("N_Instance") ? (instanceModuleName = instanceHeirs[nonLocalInstanceNodeIX = (instanceHeirs = def.heirs())[0].getImage().equals("LOCAL") ? 1 : 0].heirs()[1].getImage()).equals(instanceeName) : def.getImage().equals("N_ModuleDefinition") && (instanceModuleName = instanceHeirs[nonLocalInstanceNodeIX = (instanceHeirs = def.heirs())[0].getImage().equals("LOCAL") ? 3 : 2].heirs()[1].getImage()).equals(instanceeName))) continue;
            return internalModulesSeen.contains(instanceeName);
        }
        return false;
    }

    private boolean findNextUnresolvedInstantiationBody(ModulePointer currentModule, HashSet<ModulePointer> alreadyVisited) {
        int i;
        if (alreadyVisited.contains(currentModule)) {
            this.instantiationFound = false;
            return false;
        }
        alreadyVisited.add(currentModule);
        ModuleContext currentContext = currentModule.getContext();
        Vector<String> extendees = currentModule.getNamesOfModulesExtended();
        Vector<String> instancees = currentModule.getNamesOfModulesInstantiated();
        for (i = 0; i < instancees.size(); ++i) {
            if (currentContext.resolve(instancees.elementAt(i)) != null || this.instanceResolvesToInternalModule(currentModule, instancees.elementAt(i))) continue;
            this.nextParseUnitName = instancees.elementAt(i);
            this.nextExtenderOrInstancerModule = currentModule;
            this.instantiationFound = true;
            return true;
        }
        for (i = 0; i < extendees.size(); ++i) {
            if (!this.findNextUnresolvedInstantiationBody(currentContext.resolve(extendees.elementAt(i)), alreadyVisited)) continue;
            this.instantiationFound = true;
            return true;
        }
        for (i = 0; i < instancees.size(); ++i) {
            if (currentContext.resolve(instancees.elementAt(i)) == null || !this.findNextUnresolvedInstantiationBody(currentContext.resolve(instancees.elementAt(i)), alreadyVisited)) continue;
            this.instantiationFound = true;
            return true;
        }
        Vector<ModulePointer> innerModules = currentModule.getDirectInnerModules();
        for (int i2 = 0; i2 < innerModules.size(); ++i2) {
            if (!this.findNextUnresolvedInstantiationBody(innerModules.elementAt(i2), alreadyVisited)) continue;
            this.instantiationFound = true;
            return true;
        }
        this.instantiationFound = false;
        return false;
    }

    private boolean directlyExtends(ModulePointer mod1, ModulePointer mod2) {
        ModuleRelatives mod1Rels = mod1.getRelatives();
        Vector<String> extendees = mod1Rels.directlyExtendedModuleNames;
        ModuleContext mod1Context = mod1Rels.context;
        for (int i = 0; i < extendees.size(); ++i) {
            if (mod1Context.resolve(extendees.elementAt(i)) != mod2) continue;
            return true;
        }
        return false;
    }

    private Vector<ModulePointer> getModulesIndirectlyExtending(ModulePointer module) {
        Vector<ModulePointer> extenders = new Vector<ModulePointer>();
        extenders.addElement(module);
        boolean additions = true;
        int lastAdditionsStart = 0;
        int lastAdditionsEnd = extenders.size();
        while (additions) {
            additions = false;
            for (int i = lastAdditionsStart; i < lastAdditionsEnd; ++i) {
                Enumeration<ModulePointer> enumModules = this.getModules();
                while (enumModules.hasMoreElements()) {
                    ModulePointer modPointer = enumModules.nextElement();
                    if (!this.directlyExtends(modPointer, extenders.elementAt(i))) continue;
                    if (!additions) {
                        lastAdditionsStart = lastAdditionsEnd;
                    }
                    extenders.addElement(modPointer);
                    additions = true;
                }
                lastAdditionsStart = lastAdditionsEnd;
                lastAdditionsEnd = extenders.size();
            }
        }
        return extenders;
    }

    private void resolveNamesBetweenSpecAndInstantiation(ModulePointer instancer, ParseUnit instancee) {
        ModuleContext instancerContext = instancer.getRelatives().context;
        instancerContext.bindIfNotBound(instancee.getName(), instancee.getRootModule());
    }

    private void resolveNamesBetweenSpecAndExtention(ModulePointer extender, ParseUnit extendee) {
        ModuleContext extenderContext = extender.getRelatives().context;
        extenderContext.bindIfNotBound(extendee.getName(), extendee.getRootModule());
        Vector<ModulePointer> modulesIndirectlyExtending = this.getModulesIndirectlyExtending(extender);
        for (int i = 0; i < modulesIndirectlyExtending.size(); ++i) {
            this.resolveNamesBetweenModuleAndExtention(modulesIndirectlyExtending.elementAt(i), extendee);
        }
    }

    private void resolveNamesBetweenModuleAndExtention(ModulePointer extenderModule, ParseUnit extendeeParseUnit) {
        String extendeeInnerName;
        ModulePointer extendeeInnerModule;
        int j;
        Vector<ModulePointer> extendeeInnerModules;
        int i;
        ModuleRelatives extenderRelatives = extenderModule.getRelatives();
        ModuleContext extenderContext = extenderRelatives.context;
        Vector<String> instantiatedNames = extenderRelatives.directlyInstantiatedModuleNames;
        Vector<String> extendedNames = extenderRelatives.directlyExtendedModuleNames;
        block0: for (i = 0; i < extendedNames.size(); ++i) {
            String extendedName = extendedNames.elementAt(i);
            extendeeInnerModules = extendeeParseUnit.getRootModule().getDirectInnerModules();
            for (j = 0; j < extendeeInnerModules.size(); ++j) {
                extendeeInnerModule = extendeeInnerModules.elementAt(j);
                extendeeInnerName = extendeeInnerModule.getName();
                if (!extendedName.equals(extendeeInnerName)) continue;
                extenderContext.bindIfNotBound(extendedName, extendeeInnerModule);
                continue block0;
            }
        }
        block2: for (i = 0; i < instantiatedNames.size(); ++i) {
            String instanceName = instantiatedNames.elementAt(i);
            extendeeInnerModules = extendeeParseUnit.getRootModule().getDirectInnerModules();
            for (j = 0; j < extendeeInnerModules.size(); ++j) {
                extendeeInnerModule = extendeeInnerModules.elementAt(j);
                extendeeInnerName = extendeeInnerModule.getName();
                if (!instanceName.equals(extendeeInnerName)) continue;
                extenderContext.bindIfNotBound(instanceName, extendeeInnerModule);
                continue block2;
            }
        }
        Vector<ModulePointer> extenderInnerModules = extenderRelatives.directInnerModules;
        for (int i2 = 0; i2 < extenderInnerModules.size(); ++i2) {
            ModulePointer nextInner = extenderInnerModules.elementAt(i2);
            this.resolveNamesBetweenModuleAndExtention(nextInner, extendeeParseUnit);
        }
    }

    public boolean loadSpec(String rootExternalModuleName, Errors errors, SanyOutput out) throws AbortException {
        return this.loadSpec(rootExternalModuleName, errors, false, out);
    }

    public boolean loadSpec(String rootExternalModuleName, Errors errors, boolean validateParseUnits, SanyOutput out) throws AbortException {
        this.rootParseUnit = this.findOrCreateParsedUnit(rootExternalModuleName, errors, true, out);
        this.rootModule = this.rootParseUnit.getRootModule();
        if (validateParseUnits) {
            this.validateParseUnit(this.rootParseUnit, errors);
        }
        ParseUnit nextExtentionOrInstantiationParseUnit = null;
        while (this.findNextUnresolvedExtention(this.rootModule) || this.findNextUnresolvedInstantiation(this.rootModule)) {
            nextExtentionOrInstantiationParseUnit = this.parseUnitContext.get(this.nextParseUnitName) == null ? this.findOrCreateParsedUnit(this.nextParseUnitName, errors, false, out) : this.parseUnitContext.get(this.nextParseUnitName);
            ParseUnit extenderOrInstancerParseUnit = this.nextExtenderOrInstancerModule.getParseUnit();
            if (this.extentionFound) {
                if (validateParseUnits) {
                    this.validateParseUnit(nextExtentionOrInstantiationParseUnit, errors);
                }
                extenderOrInstancerParseUnit.addExtendee(nextExtentionOrInstantiationParseUnit);
                nextExtentionOrInstantiationParseUnit.addExtendedBy(extenderOrInstancerParseUnit);
            }
            if (this.instantiationFound) {
                extenderOrInstancerParseUnit.addInstancee(nextExtentionOrInstantiationParseUnit);
                nextExtentionOrInstantiationParseUnit.addInstancedBy(extenderOrInstancerParseUnit);
            }
            this.nonCircularityTest(nextExtentionOrInstantiationParseUnit, errors);
            if (this.extentionFound) {
                this.resolveNamesBetweenSpecAndExtention(this.nextExtenderOrInstancerModule, nextExtentionOrInstantiationParseUnit);
            }
            if (!this.instantiationFound) continue;
            this.resolveNamesBetweenSpecAndInstantiation(this.nextExtenderOrInstancerModule, nextExtentionOrInstantiationParseUnit);
        }
        this.calculateDependencies(this.rootParseUnit);
        return true;
    }

    private void validateParseUnit(ParseUnit parseUnit, Errors errors) {
        File f = parseUnit.getNis().sourceFile();
        try (FileInputStream fis = new FileInputStream(f);){
            Set<Validator.ValidationResult> results = Validator.validate(parseUnit, fis);
            if (results.contains((Object)Validator.ValidationResult.TLA_DIVERGENCE_EXISTS) && results.contains((Object)Validator.ValidationResult.PCAL_DIVERGENCE_EXISTS)) {
                errors.addWarning(ErrorCode.PLUSCAL_ALGORITHM_AND_TRANSLATION_CHANGED_SINCE_LAST_TRANSLATION, Location.moduleLocation(parseUnit.getName()), "Both the PlusCal algorithm and its TLA+ translation in module " + parseUnit.getName() + " have changed since the last translation.");
            } else if (results.contains((Object)Validator.ValidationResult.TLA_DIVERGENCE_EXISTS)) {
                errors.addWarning(ErrorCode.PLUSCAL_TRANSLATION_CHANGED_SINCE_LAST_TRANSLATION, Location.moduleLocation(parseUnit.getName()), "The TLA+ translation in module " + parseUnit.getName() + " has changed since its last translation.");
            } else if (results.contains((Object)Validator.ValidationResult.PCAL_DIVERGENCE_EXISTS)) {
                errors.addWarning(ErrorCode.PLUSCAL_ALGORITHM_CHANGED_SINCE_LAST_TRANSLATION, Location.moduleLocation(parseUnit.getName()), "The PlusCal algorithm in module " + parseUnit.getName() + " has changed since its last translation.");
            } else if (results.contains((Object)Validator.ValidationResult.ERROR_ENCOUNTERED)) {
                errors.addError(ErrorCode.INTERNAL_ERROR, Location.moduleLocation(parseUnit.getName()), "A unexpected problem was encountered attempting to validate the specification for " + parseUnit.getName());
            }
        }
        catch (IOException e) {
            errors.addError(ErrorCode.INTERNAL_ERROR, Location.moduleLocation(parseUnit.getName()), "Encountered an exception while attempt to validate " + f.getAbsolutePath() + " - " + e.getMessage());
        }
    }

    public FilenameToStream getResolver() {
        return this.resolver;
    }

    public ParseUnit getRootParseUnit() {
        return this.parseUnitContext.get(this.getName());
    }

    public List<ExprNode> getPostConditionSpecs() {
        return new ArrayList<ExprNode>();
    }

    public List<Action> getInvariants(SpecProcessor specProcessor) throws ParseException, SemanticException, AbortException {
        return new ArrayList<Action>();
    }

    public List<OpDefNode> getConstraints() {
        return new ArrayList<OpDefNode>();
    }

    public List<OpDefNode> getActionConstraints() {
        return new ArrayList<OpDefNode>();
    }

    public void processConstantDefns(Defns defns) {
    }
}

