/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.Errors;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import util.WrongInvocationException;

public class LevelNode
extends SemanticNode {
    public boolean levelCorrect = true;
    public int level = 0;
    public HashSet<SymbolNode> levelParams = new HashSet();
    public SetOfLevelConstraints levelConstraints = new SetOfLevelConstraints();
    public SetOfArgLevelConstraints argLevelConstraints = new SetOfArgLevelConstraints();
    public HashSet<ArgLevelParam> argLevelParams = new HashSet();
    public HashSet<SymbolNode> allParams = new HashSet();
    public HashSet<SymbolNode> nonLeibnizParams = new HashSet();
    public int levelChecked = 0;

    LevelNode(int kind, TreeNode stn) {
        super(kind, stn);
    }

    public boolean levelCheck(Errors errors) {
        return this.levelCheck(this.levelChecked + 1, errors);
    }

    public boolean levelCheck(int iter, Errors errors) {
        throw new WrongInvocationException("Level checking of " + kinds[this.getKind()] + " node not implemented.");
    }

    public boolean levelCheckSubnodes(int iter, LevelNode[] sub, Errors errors) {
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        this.levelChecked = iter;
        for (int i = 0; i < sub.length; ++i) {
            if (sub[i].getKind() == 1 || sub[i].getKind() == 6) continue;
            boolean bl = this.levelCorrect = sub[i].levelCheck(iter, errors) && this.levelCorrect;
            if (this.level < sub[i].getLevel()) {
                this.level = sub[i].getLevel();
            }
            this.levelParams.addAll(sub[i].getLevelParams());
            this.levelConstraints.putAll(sub[i].getLevelConstraints());
            this.argLevelConstraints.putAll(sub[i].getArgLevelConstraints());
            this.argLevelParams.addAll(sub[i].getArgLevelParams());
            this.allParams.addAll(sub[i].getAllParams());
            this.nonLeibnizParams.addAll(sub[i].getNonLeibnizParams());
        }
        return this.levelCorrect;
    }

    static void addTemporalLevelConstraintToConstants(HashSet<SymbolNode> params, SetOfLevelConstraints constrs) {
        for (SymbolNode node : params) {
            if (node.getKind() != 2) continue;
            constrs.put(node, Levels[2]);
        }
    }

    public int getLevel() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getLevel called before levelCheck");
        }
        return this.level;
    }

    public HashSet<SymbolNode> getLevelParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getLevelParams called before levelCheck");
        }
        return this.levelParams;
    }

    public HashSet<SymbolNode> getAllParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getAllParams called before levelCheck");
        }
        return this.allParams;
    }

    public HashSet<SymbolNode> getNonLeibnizParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getAllParams called before levelCheck");
        }
        return this.nonLeibnizParams;
    }

    public SetOfLevelConstraints getLevelConstraints() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getLevelConstraints called before levelCheck");
        }
        return this.levelConstraints;
    }

    public SetOfArgLevelConstraints getArgLevelConstraints() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getArgLevelConstraints called before levelCheck");
        }
        return this.argLevelConstraints;
    }

    public HashSet<ArgLevelParam> getArgLevelParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getArgLevelParams called before levelCheck");
        }
        return this.argLevelParams;
    }

    public String defaultLevelDataToString() {
        return "Level:" + this.getLevel() + "\nLevelParams: " + String.valueOf(this.getLevelParams()) + "\nLevelConstraints: " + String.valueOf(this.getLevelConstraints()) + "\nArgLevelConstraints: " + String.valueOf(this.getArgLevelConstraints()) + "\nArgLevelParams: " + LevelNode.ALPHashSetToString(this.getArgLevelParams()) + "\nAllParams: " + LevelNode.HashSetToString(this.getAllParams()) + "\nNonLeibnizParams: " + LevelNode.HashSetToString(this.getNonLeibnizParams());
    }

    public static String HashSetToString(HashSet<? extends SymbolNode> hs) {
        Object rval = "{";
        boolean first = true;
        Iterator<? extends SymbolNode> iter = hs.iterator();
        while (iter.hasNext()) {
            if (!first) {
                rval = (String)rval + ", ";
            }
            rval = (String)rval + String.valueOf(iter.next().getName());
            first = false;
        }
        rval = (String)rval + "}";
        return rval;
    }

    public static String ALPHashSetToString(HashSet<ArgLevelParam> hs) {
        Object rval = "{";
        boolean first = true;
        Iterator<ArgLevelParam> iter = hs.iterator();
        while (iter.hasNext()) {
            if (!first) {
                rval = (String)rval + ", ";
            }
            ArgLevelParam alp = iter.next();
            rval = (String)rval + "<" + String.valueOf(alp.op.getName()) + ", " + alp.i + ", " + String.valueOf(alp.param.getName()) + ">";
            first = false;
        }
        rval = (String)rval + "}";
        return rval;
    }

    @Override
    public String levelDataToString() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("levelDataToString called before levelCheck");
        }
        return this.defaultLevelDataToString();
    }

    @Override
    protected Element getSemanticElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = this.getLevelElement(doc, context, filter);
        try {
            Element l = this.appendText(doc, "level", Integer.toString(this.getLevel()));
            e.insertBefore(l, e.getFirstChild());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return e;
    }

    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        throw new UnsupportedOperationException("xml export is not yet supported for: " + String.valueOf(this.getClass()));
    }
}

