/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.AnyDefNode;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.BuiltInOperators;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.OpDefOrLabelNode;
import tla2sany.semantic.ParamAndPosition;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolTable;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;
import tlc2.tool.BuiltInOPs;
import util.UniqueString;
import util.WrongInvocationException;

public class OpDefNode
extends OpDefOrDeclNode
implements OpDefOrLabelNode,
AnyDefNode {
    private boolean local = false;
    private ExprNode body = null;
    private FormalParamNode[] params = null;
    private LevelNode stepNode = null;
    int letInLevel = -1;
    boolean inRecursive = false;
    boolean inRecursiveSection = false;
    int recursiveSection = -1;
    boolean isDefined = false;
    private Hashtable<UniqueString, LabelNode> labels = null;
    private OpDefNode source = null;
    private UniqueString[] compoundID = null;
    int[] maxLevels;
    int[] weights;
    int[][] minMaxLevel;
    boolean[] isLeibnizArg;
    boolean isLeibniz;
    private boolean[][][] opLevelCond;

    public boolean getInRecursive() {
        return this.inRecursive;
    }

    public OpDefNode(UniqueString us) {
        super(us, 0, -2, null, null, SyntaxTreeNode.nullSTN);
        if (this.st != null) {
            this.st.addSymbol(us, this);
        }
    }

    public OpDefNode(BuiltInOperators.BuiltInOperator op) {
        super(op.Name, 7, op.Arity, null, null, new SyntaxTreeNode(op.Name));
        if (this.arity >= 0) {
            this.params = new FormalParamNode[this.arity];
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i] = new FormalParamNode(UniqueString.uniqueStringOf("Formal_" + i), 0, null, null, null);
            }
        }
        if (this.st != null) {
            this.st.addSymbol(op.Name, this);
        }
        this.isDefined = true;
        if (op.ArgMaxLevels != null && op.ArgWeights != null) {
            this.setBuiltInLevel(op);
        }
    }

    public OpDefNode(UniqueString us, int k, FormalParamNode[] parms, boolean localness, ExprNode exp, ModuleNode oModNode, SymbolTable symbolTable, TreeNode stn, boolean defined, OpDefNode src) {
        super(us, k, parms != null ? parms.length : 0, oModNode, symbolTable, stn);
        this.local = localness;
        this.params = parms != null ? parms : new FormalParamNode[]{};
        this.body = exp;
        this.isDefined = defined;
        this.source = src;
        this.maxLevels = new int[this.params.length];
        this.weights = new int[this.params.length];
        this.isLeibniz = true;
        this.isLeibnizArg = new boolean[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            this.maxLevels[i] = 3;
            this.weights[i] = 0;
            this.isLeibnizArg[i] = true;
        }
        if (this.st != null) {
            this.st.addSymbol(us, this);
        }
    }

    public OpDefNode(UniqueString us, int k, FormalParamNode[] parms, boolean localness, ExprNode exp, ModuleNode oModNode, SymbolTable symbolTable, TreeNode stn, boolean defined, OpDefNode src, UniqueString[] compoundID) {
        this(us, k, parms, localness, exp, oModNode, symbolTable, stn, defined, src);
        this.compoundID = compoundID;
    }

    final UniqueString[] getCompoundId() {
        if (this.compoundID != null) {
            return this.compoundID;
        }
        return new UniqueString[]{this.getName()};
    }

    public final UniqueString getLocalName() {
        if (this.compoundID != null) {
            return this.compoundID[this.compoundID.length - 1];
        }
        return this.getName();
    }

    public final boolean hasPath() {
        if (this.compoundID != null) {
            return this.compoundID.length > 1;
        }
        return false;
    }

    public final UniqueString getPathName() {
        if (this.compoundID != null) {
            return UniqueString.join("!", this.compoundID.length - 1, this.compoundID);
        }
        return UniqueString.of("");
    }

    public OpDefNode(UniqueString us, FormalParamNode[] parms, boolean localness, ModuleNode oModNode, SymbolTable symbolTable, TreeNode stn, OpDefNode src) {
        super(us, 6, parms == null ? -1 : parms.length, oModNode, symbolTable, stn);
        this.params = parms;
        this.local = localness;
        this.source = src;
        if (this.st != null) {
            this.st.addSymbol(us, this);
        }
    }

    public OpDefNode(UniqueString us, LevelNode step, ModuleNode oModNode, SymbolTable symbolTable, TreeNode stn) {
        super(us, 37, 0, oModNode, symbolTable, stn);
        this.stepNode = step;
        this.st.addSymbol(us, this);
    }

    @Override
    public final FormalParamNode[] getParams() {
        return this.params;
    }

    public final void setParams(FormalParamNode[] pms) {
        this.params = pms;
    }

    public final ExprNode getBody() {
        return this.body;
    }

    public final void setBody(ExprNode body) {
        this.body = body;
    }

    @Override
    public final OpDefNode getSource() {
        return this.source == null ? this : this.source;
    }

    public final boolean hasSource() {
        return this.source != null;
    }

    @Override
    public final boolean isLocal() {
        return this.local;
    }

    @Override
    public final int getArity() {
        return this.arity;
    }

    public final LevelNode getStepNode() {
        return this.stepNode;
    }

    private boolean matchingOpArgOperand(ExprOrOpArgNode arg, int i) {
        OpArgNode argOpArg;
        boolean result;
        boolean bl = result = arg instanceof OpArgNode && this.params[i].getArity() == ((OpArgNode)arg).getArity();
        if (result && (argOpArg = (OpArgNode)arg).getOp() instanceof OpDefNode) {
            OpDefNode opdefArg = (OpDefNode)argOpArg.getOp();
            for (int j = 0; j < opdefArg.getArity(); ++j) {
                if (opdefArg.getParams()[j].getArity() <= 0) continue;
                result = false;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean match(OpApplNode oanParent, ModuleNode mn, Errors errors) throws AbortException {
        Location loc;
        ExprOrOpArgNode[] args = oanParent.getArgs();
        boolean result = true;
        boolean tempResult = true;
        Location location = loc = oanParent.getTreeNode() != null ? oanParent.getTreeNode().getLocation() : null;
        if (this.getKind() == 6) {
            errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, loc, "Module instance identifier where operator should be.");
            return false;
        }
        if (this.arity == -1) {
            if (args == null) throw errors.addError(ErrorCode.INTERNAL_ERROR, loc, "Internal error: null args vector for operator '" + String.valueOf(this.getName()) + "' that should take variable number of args.");
            int i = 0;
            while (i < args.length) {
                if (args[i] instanceof OpArgNode) {
                    errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, loc, "Illegal expression used as argument " + (i + 1) + " to operator '" + String.valueOf(this.getName()) + "'.");
                    result = false;
                }
                ++i;
            }
            return result;
        }
        if (args == null | this.params == null) {
            throw errors.addError(ErrorCode.INTERNAL_ERROR, loc, "Internal error: Null args or params vector for operator '" + String.valueOf(this.getName()) + "'.");
        }
        if (this.params.length != args.length) {
            errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, loc, "Wrong number of arguments (" + args.length + ") given to operator '" + String.valueOf(this.getName()) + "', \nwhich requires " + this.params.length + " arguments.");
            return false;
        }
        if (this.getKind() == 7) {
            int i = 0;
            while (i < this.params.length) {
                if (args[i] instanceof OpArgNode) {
                    errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, loc, "Non-expression used as argument number " + (i + 1) + " to BuiltIn operator '" + String.valueOf(this.getName()) + "'.");
                    result = false;
                }
                ++i;
            }
            return result;
        }
        if (this.getKind() != 5) throw errors.addError(ErrorCode.INTERNAL_ERROR, Location.nullLoc, "Internal error: operator neither BuiltIn nor UserDefined \nin call to OpDefNode.match()");
        int i = 0;
        while (i < this.params.length) {
            if (this.params[i].getArity() == 0) {
                if (args[i] instanceof OpArgNode) {
                    errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, loc, "Operator used in argument number " + (i + 1) + " has incorrect number of arguments.");
                    result = false;
                }
            } else if (this.params[i].getArity() > 0) {
                if (!this.matchingOpArgOperand(args[i], i)) {
                    errors.addError(ErrorCode.HIGHER_ORDER_OPERATOR_ARGUMENT_HAS_INCORRECT_ARITY, loc, "Argument number " + (i + 1) + " to operator '" + String.valueOf(this.getName()) + "' \nshould be a " + this.params[i].getArity() + "-parameter operator.");
                    result = false;
                }
            } else {
                errors.addError(ErrorCode.INTERNAL_ERROR, loc, "Internal error: Operator '" + String.valueOf(this.getName()) + "' indicates that it requires \na negative number of arguments.");
            }
            ++i;
        }
        return result;
    }

    @Override
    public void setLabels(Hashtable<UniqueString, LabelNode> ht) {
        this.labels = ht;
    }

    @Override
    public LabelNode getLabel(UniqueString us) {
        if (this.labels == null) {
            return null;
        }
        return this.labels.get(us);
    }

    @Override
    public boolean addLabel(LabelNode odn) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        if (this.labels.containsKey(odn.getName())) {
            return false;
        }
        this.labels.put(odn.getName(), odn);
        return true;
    }

    @Override
    public LabelNode[] getLabels() {
        if (this.labels == null) {
            return new LabelNode[0];
        }
        Vector<LabelNode> v = new Vector<LabelNode>();
        Enumeration<LabelNode> e = this.labels.elements();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        LabelNode[] retVal = new LabelNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retVal[i] = (LabelNode)v.elementAt(i);
        }
        return retVal;
    }

    public Hashtable<UniqueString, LabelNode> getLabelsHT() {
        return this.labels;
    }

    @Override
    public boolean[] getIsLeibnizArg() {
        return this.isLeibnizArg;
    }

    @Override
    public boolean getIsLeibniz() {
        return this.isLeibniz;
    }

    private final void setBuiltInLevel(BuiltInOperators.BuiltInOperator op) {
        if (this.arity == -1) {
            if (op.ArgMaxLevels.length > 0) {
                this.maxLevels = new int[1];
                this.maxLevels[0] = op.ArgMaxLevels[0];
                this.weights = new int[1];
                this.weights[0] = op.ArgWeights[0];
            } else {
                this.maxLevels = new int[0];
                this.weights = new int[0];
            }
        } else {
            this.maxLevels = op.ArgMaxLevels;
            this.weights = op.ArgWeights;
        }
        this.isLeibniz = true;
        this.isLeibnizArg = new boolean[op.ArgWeights.length];
        for (int i = 0; i < op.ArgWeights.length; ++i) {
            this.isLeibnizArg[i] = op.ArgWeights[i] > 0;
            this.isLeibniz = this.isLeibniz && this.isLeibnizArg[i];
        }
        this.level = op.OpLevel;
        this.levelChecked = 99;
    }

    @Override
    public final boolean levelCheck(int itr, Errors errors) {
        int i;
        int j;
        int i2;
        if (this.levelChecked >= itr || !this.inRecursiveSection && this.levelChecked > 0) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        if (this.getKind() == 37) {
            LevelNode[] subs = new LevelNode[]{this.stepNode};
            this.levelCorrect = this.stepNode.levelCheck(itr, errors);
            return this.levelCheckSubnodes(itr, subs, errors);
        }
        this.levelCorrect = this.body.levelCheck(itr, errors);
        this.level = Math.max(this.level, this.body.getLevel());
        SetOfLevelConstraints lcSet = this.body.getLevelConstraints();
        for (i2 = 0; i2 < this.params.length; ++i2) {
            Object plevel = lcSet.get(this.params[i2]);
            if (plevel == null) continue;
            this.maxLevels[i2] = Math.min(this.maxLevels[i2], (Integer)plevel);
        }
        for (i2 = 0; i2 < this.params.length; ++i2) {
            if (!this.body.getLevelParams().contains(this.params[i2])) continue;
            this.weights[i2] = Math.max(this.weights[i2], 1);
        }
        this.minMaxLevel = new int[this.params.length][];
        SetOfArgLevelConstraints alcSet = this.body.getArgLevelConstraints();
        for (int i3 = 0; i3 < this.params.length; ++i3) {
            int alen = this.params[i3].getArity();
            this.minMaxLevel[i3] = new int[alen];
            for (j = 0; j < alen; ++j) {
                Object alevel = alcSet.get(new ParamAndPosition(this.params[i3], j));
                this.minMaxLevel[i3][j] = alevel == null ? 0 : (Integer)alevel;
            }
        }
        this.opLevelCond = new boolean[this.params.length][this.params.length][];
        HashSet<ArgLevelParam> alpSet = this.body.getArgLevelParams();
        for (i = 0; i < this.params.length; ++i) {
            for (j = 0; j < this.params.length; ++j) {
                this.opLevelCond[i][j] = new boolean[this.params[i].getArity()];
                for (int k = 0; k < this.params[i].getArity(); ++k) {
                    ArgLevelParam alp = new ArgLevelParam(this.params[i], k, this.params[j]);
                    this.opLevelCond[i][j][k] = alpSet.contains(alp);
                }
            }
        }
        this.levelParams.addAll(this.body.getLevelParams());
        this.allParams.addAll(this.body.getAllParams());
        this.nonLeibnizParams.addAll(this.body.getNonLeibnizParams());
        for (i = 0; i < this.params.length; ++i) {
            this.levelParams.remove(this.params[i]);
            this.allParams.remove(this.params[i]);
            if (!this.nonLeibnizParams.contains(this.params[i])) continue;
            this.nonLeibnizParams.remove(this.params[i]);
            this.isLeibnizArg[i] = false;
            this.isLeibniz = false;
        }
        this.levelConstraints = new SetOfLevelConstraints(lcSet);
        for (i = 0; i < this.params.length; ++i) {
            this.levelConstraints.remove(this.params[i]);
        }
        this.argLevelConstraints = new SetOfArgLevelConstraints(alcSet);
        for (i = 0; i < this.params.length; ++i) {
            int alen = this.params[i].getArity();
            for (int j2 = 0; j2 < alen; ++j2) {
                this.argLevelConstraints.remove(new ParamAndPosition(this.params[i], j2));
            }
        }
        for (ArgLevelParam alp : alpSet) {
            if (alp.op.occur(this.params) && alp.param.occur(this.params)) continue;
            this.argLevelParams.add(alp);
        }
        return this.levelCorrect;
    }

    @Override
    public final int getMaxLevel(int i) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getMaxLevel called before levelCheck");
        }
        int idx = this.getArity() == -1 ? 0 : i;
        return this.maxLevels[idx];
    }

    @Override
    public final int getWeight(int i) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getWeight called before levelCheck");
        }
        int idx = this.getArity() == -1 ? 0 : i;
        return this.weights[idx];
    }

    @Override
    public final int getMinMaxLevel(int i, int j) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getMinMaxLevel called before levelCheck");
        }
        if (this.minMaxLevel == null) {
            return 0;
        }
        return this.minMaxLevel[i][j];
    }

    @Override
    public final boolean getOpLevelCond(int i, int j, int k) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getOpLevelCond called before levelCheck");
        }
        if (this.opLevelCond == null) {
            return false;
        }
        return this.opLevelCond[i][j][k];
    }

    public final int[] getArgMaxLevels() {
        return this.maxLevels == null ? null : Arrays.copyOf(this.maxLevels, this.maxLevels.length);
    }

    public final int[] getArgWeights() {
        return this.weights == null ? null : Arrays.copyOf(this.weights, this.weights.length);
    }

    @Override
    public final String levelDataToString() {
        if (this.getKind() == 6 || this.getKind() == 37) {
            return "";
        }
        if (this.arity < 0) {
            return "Arity: " + this.arity + "\nLevel: " + this.getLevel() + "\nMaxLevel: " + this.maxLevels[0] + "\n";
        }
        Object maxLevelStr = "";
        for (int i = 0; i < this.maxLevels.length; ++i) {
            if (i > 0) {
                maxLevelStr = (String)maxLevelStr + ", ";
            }
            maxLevelStr = (String)maxLevelStr + this.maxLevels[i];
        }
        Object isLeibnizArgStr = "";
        for (int i = 0; i < this.isLeibnizArg.length; ++i) {
            if (i > 0) {
                isLeibnizArgStr = (String)isLeibnizArgStr + ", ";
            }
            isLeibnizArgStr = (String)isLeibnizArgStr + this.isLeibnizArg[i];
        }
        Object opLevelCondStr = "";
        if (this.opLevelCond != null) {
            opLevelCondStr = "[";
            for (int i = 0; i < this.opLevelCond.length; ++i) {
                opLevelCondStr = (String)opLevelCondStr + " [";
                for (int j = 0; j < this.opLevelCond[i].length; ++j) {
                    opLevelCondStr = (String)opLevelCondStr + " [";
                    for (int k = 0; k < this.opLevelCond[i][j].length; ++k) {
                        String foo = " ";
                        if (k == 0) {
                            foo = "";
                        }
                        opLevelCondStr = (String)opLevelCondStr + foo + this.opLevelCond[i][j][k];
                    }
                    opLevelCondStr = (String)opLevelCondStr + "]";
                }
                opLevelCondStr = (String)opLevelCondStr + "]";
            }
            opLevelCondStr = (String)opLevelCondStr + "]";
        }
        return "Arity: " + this.arity + "\nLevel: " + this.getLevel() + "\nLevelParams: " + String.valueOf(this.getLevelParams()) + "\nLevelConstraints: " + String.valueOf(this.getLevelConstraints()) + "\nArgLevelConstraints: " + String.valueOf(this.getArgLevelConstraints()) + "\nArgLevelParams: " + OpDefNode.ALPHashSetToString(this.getArgLevelParams()) + "\nMaxLevel: " + (String)maxLevelStr + "\nopLevelCond: " + (String)opLevelCondStr + "\nAllParams: " + OpDefNode.HashSetToString(this.getAllParams()) + "\nNonLeibnizParams: " + OpDefNode.HashSetToString(this.getNonLeibnizParams()) + "\nIsLeibniz: " + this.isLeibniz + "\nisLeibnizArg: " + (String)isLeibnizArgStr + "\n";
    }

    public boolean hasOpcode(int opCode) {
        return opCode == BuiltInOPs.getOpCode(this.getName());
    }

    @Override
    public SemanticNode[] getChildren() {
        return new SemanticNode[]{this.body};
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.params != null && this.params.length > 0) {
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] == null) continue;
                this.params[i].walkGraph(semNodesTable, visitor);
            }
        }
        if (this.body != null) {
            this.body.walkGraph(semNodesTable, visitor);
        }
        if (this.stepNode != null) {
            this.stepNode.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public String getSignature() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName().toString());
        if (this.getArity() > 0 && this.getKind() != 7) {
            buf.append("(");
            FormalParamNode[] params = this.getParams();
            for (int i = 0; i < params.length - 1; ++i) {
                FormalParamNode formalParamNode = params[i];
                if (formalParamNode.getTreeNode() == null) continue;
                SyntaxTreeNode treeNode = (SyntaxTreeNode)formalParamNode.getTreeNode();
                buf.append(treeNode.getHumanReadableImage());
                buf.append(", ");
            }
            if (params[params.length - 1].getTreeNode() != null) {
                TreeNode treeNode = params[params.length - 1].getTreeNode();
                buf.append(treeNode.getHumanReadableImage());
            }
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*OpDefNode: " + this.getName().toString() + "\n  " + super.toString(depth, errors) + "\n  local: " + this.local + "\n  letInLevel: " + this.letInLevel + "\n  inRecursive: " + this.inRecursive + "\n  inRecursiveSection: " + this.inRecursiveSection + "\n  recursiveSection: " + this.recursiveSection + "\n  local: " + this.local + "\n  source: " + (String)(this.source == null ? "this" : this.source.getName().toString() + " (uid: " + this.source.myUID + ")") + "\n  originallyDefinedInModule: " + (String)(this.originallyDefinedInModule == null ? "null" : this.originallyDefinedInModule.getName().toString() + " (uid: " + this.originallyDefinedInModule.myUID + ")") + (String)(this.stepNode == null ? "" : "\n  stepNode: " + Strings.indent(4, this.stepNode.toString(depth - 3, errors)));
        if (this.params != null) {
            String tempString = "\n  Formal params: " + this.params.length;
            for (int i = 0; i < this.params.length; ++i) {
                tempString = tempString + Strings.indent(4, this.params[i] != null ? this.params[i].toString(depth - 1, errors) : "\nnull");
            }
            ret = ret + tempString;
        } else {
            ret = ret + Strings.indent(2, "\nFormal params: null");
        }
        if (depth > 1) {
            ret = this.st != null ? ret + "\n  SymbolTable: non-null" : ret + "\n  SymbolTable: null";
        }
        ret = this.body != null ? ret + Strings.indent(2, "\nBody:" + Strings.indent(2, this.body.toString(depth - 1, errors))) : ret + Strings.indent(2, "\nBody: null");
        if (this.labels != null) {
            ret = ret + "\n  Labels: ";
            Enumeration<UniqueString> list = this.labels.keys();
            while (list.hasMoreElements()) {
                ret = ret + list.nextElement().toString() + "  ";
            }
        } else {
            ret = ret + "\n  Labels: null";
        }
        return ret;
    }

    @Override
    public String getHumanReadableImage() {
        String comment = this.getComment();
        StringBuffer buf = new StringBuffer(comment);
        buf.append("\n");
        TreeNode[] ones = this.getTreeNode().one();
        if (ones != null) {
            for (TreeNode treeNode : ones) {
                buf.append(treeNode.getHumanReadableImage());
                buf.append(" ");
            }
        } else {
            buf.append(this.toString());
        }
        return buf.toString().trim();
    }

    @Override
    protected String getNodeRef() {
        switch (this.getKind()) {
            case 5: {
                return "UserDefinedOpKindRef";
            }
            case 7: {
                return "BuiltInKindRef";
            }
            case 6: {
                return "ModuleInstanceKindRef";
            }
        }
        throw new IllegalArgumentException("unsupported kind: " + this.getKind() + " in xml export");
    }

    @Override
    protected Element getSymbolElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element ret = null;
        switch (this.getKind()) {
            case 5: {
                ret = doc.createElement("UserDefinedOpKind");
                ret.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
                ret.appendChild(this.appendText(doc, "arity", Integer.toString(this.getArity())));
                if (this.getPreComments().length > 0) {
                    ret.appendChild(this.appendCDATA(doc, "pre-comments", Arrays.stream(this.getPreComments()).filter(Objects::nonNull).map(String::stripTrailing).filter(s -> !s.isEmpty()).collect(Collectors.joining(System.lineSeparator()))));
                }
                ret.appendChild(this.appendElement(doc, "body", this.body.export(doc, context, filter)));
                if (this.params != null) {
                    Element arguments = doc.createElement("params");
                    for (int i = 0; i < this.params.length; ++i) {
                        Element lp = doc.createElement("leibnizparam");
                        lp.appendChild(this.params[i].export(doc, context, filter));
                        if (this.isLeibnizArg != null && this.isLeibnizArg[i]) {
                            lp.appendChild(doc.createElement("leibniz"));
                        }
                        arguments.appendChild(lp);
                    }
                    ret.appendChild(arguments);
                }
                if (!this.inRecursive) break;
                ret.appendChild(doc.createElement("recursive"));
                break;
            }
            case 7: {
                ret = doc.createElement("BuiltInKind");
                ret.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
                ret.appendChild(this.appendText(doc, "arity", Integer.toString(this.getArity())));
                Element arguments2 = doc.createElement("params");
                if (this.params == null) break;
                for (int i = 0; i < this.params.length; ++i) {
                    Element lp = doc.createElement("leibnizparam");
                    lp.appendChild(this.params[i].export(doc, context, filter));
                    if (this.isLeibnizArg != null && this.isLeibnizArg[i]) {
                        lp.appendChild(doc.createElement("leibniz"));
                    }
                    arguments2.appendChild(lp);
                }
                ret.appendChild(arguments2);
                break;
            }
            case 6: {
                ret = doc.createElement("ModuleInstanceKind");
                ret.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported kind: " + this.getKind() + " in xml export");
            }
        }
        return ret;
    }
}

