/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class StringNode
extends ExprNode
implements ExploreNode {
    private UniqueString value;

    public StringNode(TreeNode stn, boolean strip) {
        super(18, stn);
        this.value = stn.getUS();
        if (strip) {
            String str = this.value.toString();
            str = str.substring(1, str.length() - 1);
            this.value = UniqueString.uniqueStringOf(str);
        }
    }

    public final UniqueString getRep() {
        return this.value;
    }

    @Override
    public final boolean levelCheck(int iter, Errors errors) {
        this.levelChecked = iter;
        return true;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        visitor.postVisit(this);
    }

    final String PrintVersion(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        block8: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\"': {
                    buf.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block8;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block8;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block8;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block8;
                }
                default: {
                    buf.append(str.charAt(i));
                }
            }
        }
        return buf.toString();
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        return "\n*StringNode: " + super.toString(depth, errors) + "Value: '" + this.PrintVersion(this.value.toString()) + "' Length: " + this.value.length();
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("StringValue");
        Text n = doc.createTextNode(this.value.toString());
        e.appendChild(n);
        return this.appendElement(doc, "StringNode", e);
    }
}

