/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.Misc;
import tla2tex.OutputFileWriter;
import tla2tex.Position;
import tla2tex.Token;

public class WriteTLAFile {
    public static void Write(Token[][] spec, String fileName) {
        OutputFileWriter writer = new OutputFileWriter(fileName);
        boolean deleting = false;
        int multiBelow = 0;
        for (int line = 0; line < spec.length; ++line) {
            Object outLine = "";
            boolean nullComment = false;
            block13: for (int item = 0; item < spec[line].length; ++item) {
                Token tok = spec[line][item];
                outLine = item > 0 ? (String)outLine + WriteTLAFile.SpacesString(tok.column - spec[line][item - 1].column - spec[line][item - 1].getWidth()) : (String)outLine + WriteTLAFile.SpacesString(tok.column);
                switch (tok.type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: 
                    case 13: {
                        outLine = (String)outLine + tok.string;
                        continue block13;
                    }
                    case 3: {
                        outLine = (String)outLine + "\"" + tok.string + "\"";
                        continue block13;
                    }
                    case 5: {
                        CommentToken ctok = (CommentToken)tok;
                        if (ctok.subtype == 7) {
                            deleting = false;
                            multiBelow = 0;
                        }
                        Object commentString = "";
                        if (ctok.subtype == 8 || ctok.subtype == 9) {
                            CommentToken bctok;
                            Token btok;
                            Position bpos;
                            for (int i = 0; ctok != null && i < multiBelow; ++i) {
                                bpos = ctok.belowAlign;
                                ctok = null;
                                if (bpos.line == -1) continue;
                                btok = bpos.toToken(spec);
                                if (btok.type != 5) continue;
                                bctok = (CommentToken)btok;
                                if (bctok.subtype != 8 && bctok.subtype != 9) continue;
                                ctok = bctok;
                            }
                            if (ctok != null) {
                                commentString = ctok.string;
                                if (deleting) {
                                    commentString = "`^" + (String)commentString;
                                }
                                deleting = WriteTLAFile.UnmatchedDelete((String)commentString);
                                commentString = WriteTLAFile.RemoveDeletions((String)commentString);
                                while (deleting && ctok != null && Misc.isBlank((String)commentString)) {
                                    bpos = ctok.belowAlign;
                                    ctok = null;
                                    if (bpos.line == -1) continue;
                                    btok = bpos.toToken(spec);
                                    if (btok.type != 5) continue;
                                    bctok = (CommentToken)btok;
                                    if (bctok.subtype != 8 && bctok.subtype != 9) continue;
                                    ctok = bctok;
                                    ++multiBelow;
                                    commentString = ctok.string;
                                    deleting = WriteTLAFile.UnmatchedDelete("`^" + (String)commentString);
                                    commentString = WriteTLAFile.RemoveDeletions("`^" + (String)commentString);
                                }
                            }
                            if (ctok != null && Misc.isBlank((String)commentString)) {
                                commentString = WriteTLAFile.SpacesString(ctok.string.length());
                            }
                        } else {
                            commentString = WriteTLAFile.RemoveDeletions(ctok.string);
                            commentString = (String)commentString + WriteTLAFile.SpacesString(ctok.string.length() - ((String)commentString).length());
                        }
                        if (ctok != null) {
                            commentString = WriteTLAFile.ReplaceQuoteTildes((String)commentString);
                            switch (ctok.rsubtype) {
                                case 1: {
                                    outLine = (String)outLine + "(*" + (String)commentString + "*)";
                                    continue block13;
                                }
                                case 2: {
                                    outLine = (String)outLine + "\\*" + (String)commentString;
                                    continue block13;
                                }
                                case 3: {
                                    outLine = (String)outLine + "(*" + (String)commentString;
                                    continue block13;
                                }
                                case 4: {
                                    outLine = (String)outLine + (String)commentString + "*)";
                                    continue block13;
                                }
                                case 5: {
                                    outLine = (String)outLine + (String)commentString;
                                    continue block13;
                                }
                            }
                            Debug.ReportBug("Bad CommentToken subtype found.");
                            continue block13;
                        }
                        nullComment = true;
                        continue block13;
                    }
                    default: {
                        Debug.ReportBug("Bad token type found.");
                    }
                }
            }
            if (nullComment && spec[line].length == 1) continue;
            writer.putLine((String)outLine);
        }
        writer.close();
    }

    private static String SpacesString(int n) {
        Object result = "";
        for (int i = 0; i < n; ++i) {
            result = (String)result + " ";
        }
        return result;
    }

    private static boolean UnmatchedDelete(String str) {
        return str.lastIndexOf("^'") < str.lastIndexOf("`^");
    }

    private static String RemoveDeletions(String str) {
        String rest = str;
        Object start = "";
        int nextDel = rest.indexOf("`^");
        while (nextDel != -1) {
            start = (String)start + rest.substring(0, nextDel);
            int nextEnd = (rest = rest.substring(nextDel)).indexOf("^'");
            if (nextEnd == -1) {
                nextDel = -1;
                rest = "";
                continue;
            }
            rest = rest.substring(nextEnd + 2);
            nextDel = rest.indexOf("`^");
        }
        return (String)start + rest;
    }

    private static String ReplaceQuoteTildes(String str) {
        Object result = str;
        int nextRepl = ((String)result).indexOf("`~");
        while (nextRepl != -1) {
            result = ((String)result).substring(0, nextRepl) + "  " + ((String)result).substring(nextRepl + 2);
            nextRepl = ((String)result).indexOf("`~");
        }
        nextRepl = ((String)result).indexOf("~'");
        while (nextRepl != -1) {
            result = ((String)result).substring(0, nextRepl) + "  " + ((String)result).substring(nextRepl + 2);
            nextRepl = ((String)result).indexOf("~'");
        }
        nextRepl = ((String)result).indexOf("`.");
        while (nextRepl != -1) {
            result = ((String)result).substring(0, nextRepl) + "  " + ((String)result).substring(nextRepl + 2);
            nextRepl = ((String)result).indexOf("`.");
        }
        nextRepl = ((String)result).indexOf(".'");
        while (nextRepl != -1) {
            result = ((String)result).substring(0, nextRepl) + "  " + ((String)result).substring(nextRepl + 2);
            nextRepl = ((String)result).indexOf(".'");
        }
        return result;
    }
}

