/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tlc2.tool.liveness.AbstractGraphNode;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.TBGraph;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.tool.liveness.TBPar;
import tlc2.tool.liveness.TableauNodePtrTable;
import tlc2.util.BitVector;
import tlc2.util.BufferedRandomAccessFile;

public class GraphNode
extends AbstractGraphNode {
    private static final int NNODE_RECORD_SIZE = 3;
    private static final int[] emptyIntArr = new int[0];
    final long stateFP;
    private int[] nnodes;
    final int tindex;
    private int offset = -1;
    private static final int NO_FREE_SLOTS = -1;

    public GraphNode(long fp, int tindex) {
        this(fp, tindex, emptyIntArr, new BitVector(0));
    }

    private GraphNode(long fp, int tindex, int[] nnodes, BitVector checks) {
        super(checks);
        this.stateFP = fp;
        this.tindex = tindex;
        this.nnodes = nnodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.stateFP ^ this.stateFP >>> 32);
        result = 31 * result + this.tindex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphNode other = (GraphNode)obj;
        if (this.stateFP != other.stateFP) {
            return false;
        }
        return this.tindex == other.tindex;
    }

    public final long getStateFP(int i) {
        long high = this.nnodes[3 * i];
        long low = this.nnodes[3 * i + 1];
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public final int getTidx(int i) {
        return this.nnodes[3 * i + 2];
    }

    public final int succSize() {
        if (this.offset != -1) {
            return this.offset / 3;
        }
        return this.nnodes.length / 3;
    }

    private final void allocate(int transitions) {
        int len = this.nnodes.length;
        int[] newNodes = new int[len + 3 * transitions];
        System.arraycopy(this.nnodes, 0, newNodes, 0, len);
        this.nnodes = newNodes;
        this.offset = len;
    }

    public final void addTransition(long fp, int tidx, int slen, int alen, BitVector acts, int actsOffset, int allocationHint) {
        if (acts != null) {
            int pos = slen + alen * this.succSize();
            for (int i = 0; i < alen; ++i) {
                if (!acts.get(actsOffset + i)) continue;
                this.checks.set(pos + i);
            }
        }
        if (this.offset == -1) {
            this.allocate(Math.max(allocationHint, 1));
        }
        this.nnodes[this.offset] = (int)(fp >>> 32);
        this.nnodes[this.offset + 1] = (int)(fp & 0xFFFFFFFFL);
        this.nnodes[this.offset + 2] = tidx;
        this.offset += 3;
        if (this.offset == this.nnodes.length) {
            this.offset = -1;
        }
    }

    public int realign() {
        int result = 0;
        if (this.offset != -1) {
            result = (this.nnodes.length - this.offset) / 3;
            int[] newNodes = new int[this.offset];
            System.arraycopy(this.nnodes, 0, newNodes, 0, newNodes.length);
            this.nnodes = newNodes;
            this.offset = -1;
        }
        return result;
    }

    public final boolean transExists(long fp, int tidx) {
        int len = this.nnodes.length;
        if (this.offset != -1) {
            len = this.offset;
        }
        int high = (int)(fp >>> 32);
        int low = (int)(fp & 0xFFFFFFFFL);
        for (int i = 0; i < len; i += 3) {
            if (this.nnodes[i] != high || this.nnodes[i + 1] != low || this.nnodes[i + 2] != tidx) continue;
            return true;
        }
        return false;
    }

    public boolean checkInvariants(int slen, int alen) {
        HashSet<Transition> transitions = new HashSet<Transition>();
        for (int i = 0; i < this.succSize(); ++i) {
            Transition t = new Transition(this.getStateFP(i), this.getTidx(i), this.getCheckAction(slen, alen, i));
            transitions.add(t);
        }
        return transitions.size() == this.succSize();
    }

    public Set<Transition> getTransition() {
        return this.getTransition(0, 0);
    }

    public Set<Transition> getTransition(int slen, int alen) {
        HashSet<Transition> transitions = new HashSet<Transition>();
        for (int i = 0; i < this.succSize(); ++i) {
            BitVector bv = new BitVector(alen);
            for (int j = 0; j < alen; ++j) {
                if (!this.getCheckAction(slen, alen, i, j)) continue;
                bv.set(j);
            }
            transitions.add(new Transition(this.getStateFP(i), this.getTidx(i), bv));
        }
        return transitions;
    }

    public final TBGraphNode getTNode(TBGraph tableau) {
        return tableau.getNode(this.tindex);
    }

    void write(BufferedRandomAccessFile nodeRAF) throws IOException {
        assert (this.offset == -1);
        int cnt = this.nnodes.length;
        nodeRAF.writeNat(cnt);
        for (int i = 0; i < cnt; ++i) {
            nodeRAF.writeInt(this.nnodes[i]);
        }
        this.checks.write(nodeRAF);
    }

    void read(BufferedRandomAccessFile nodeRAF) throws IOException {
        int cnt = nodeRAF.readNat();
        this.nnodes = new int[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.nnodes[i] = nodeRAF.readInt();
        }
        this.checks = new BitVector();
        this.checks.read(nodeRAF);
        assert (this.offset == -1);
    }

    public final String toString() {
        return this.toString(0).replace("[] ", "");
    }

    public final String toString(int alen) {
        StringBuffer buf = new StringBuffer();
        buf.append("<" + this.stateFP + "," + this.tindex + "> --> ");
        for (int i = 0; i < this.succSize(); ++i) {
            buf.append("[");
            for (int j = 0; j < alen; ++j) {
                if (this.getCheckAction(0, 2, i, j)) {
                    buf.append("t");
                    continue;
                }
                buf.append("f");
            }
            buf.append("] ");
            buf.append("<" + this.getStateFP(i) + "," + this.getTidx(i) + ">");
            buf.append(", ");
        }
        return buf.substring(0, buf.length() - ", ".length());
    }

    public String toDotViz(boolean isInitState, boolean hasTableau, int slen, int alen, OrderOfSolution oos, Map<Long, String> labels) {
        return this.toDotViz(isInitState, hasTableau, slen, alen, null, oos, labels);
    }

    public String toDotViz(boolean isInitState, boolean hasTableau, int slen, int alen, TableauNodePtrTable filter, OrderOfSolution oos) {
        return this.toDotViz(isInitState, hasTableau, slen, alen, oos, new HashMap<Long, String>());
    }

    public String toDotViz(boolean isInitState, boolean hasTableau, int slen, int alen, TableauNodePtrTable filter, OrderOfSolution oos, Map<Long, String> labels) {
        int plen;
        Object id = Long.toString(this.stateFP);
        if (hasTableau) {
            id = (String)id + "." + this.tindex;
        }
        String label = labels.getOrDefault(this.stateFP, "") + Long.toString(this.stateFP).substring(0, 6) + (String)(hasTableau ? "." + this.tindex : "");
        if (slen > 0) {
            label = label + "\n";
            for (int i = 0; i < slen; ++i) {
                label = this.getCheckState(i) ? label + "t" : label + "f";
            }
        }
        if ((plen = oos.getPromises().length) > 0) {
            label = label + "\n";
            for (int i = 0; i < plen; ++i) {
                LNEven promise = oos.getPromises()[i];
                TBPar par = this.getTNode(oos.getTableau()).getPar();
                boolean fulfilling = par.isFulfilling(promise);
                label = fulfilling ? label + "t" : label + "f";
            }
        }
        StringBuffer buf = new StringBuffer();
        if (isInitState) {
            buf.append("\"" + (String)id + "\" [style = filled][label = \"" + label + "\"]\n");
        } else {
            buf.append("\"" + (String)id + "\" [label = \"" + label + "\"]\n");
        }
        for (int i = 0; i < this.succSize(); ++i) {
            long stateFP = this.getStateFP(i);
            int tidx = this.getTidx(i);
            if (filter != null && filter.get(stateFP, tidx) == -1L) continue;
            String fp = Long.toString(stateFP);
            buf.append("\"" + (String)id + "\" -> ");
            if (hasTableau) {
                buf.append("\"" + fp + "." + tidx + "\"");
            } else {
                buf.append("\"" + fp + "\"");
            }
            buf.append(" [label=\"");
            for (int j = 0; j < alen; ++j) {
                if (this.getCheckAction(slen, alen, i, j)) {
                    buf.append("t");
                    continue;
                }
                buf.append("f");
            }
            buf.append("\"];");
            buf.append("\n");
        }
        return buf.toString();
    }

    public static class Transition {
        private final long fp;
        private final int tidx;
        private final BitVector bv;

        public Transition(long fp, int tidx, BitVector bv) {
            this.fp = fp;
            this.tidx = tidx;
            this.bv = bv;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bv == null ? 0 : this.bv.hashCode());
            result = 31 * result + (int)(this.fp ^ this.fp >>> 32);
            result = 31 * result + this.tidx;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Transition other = (Transition)obj;
            if (this.bv == null ? other.bv != null : !this.bv.equals(other.bv)) {
                return false;
            }
            if (this.fp != other.fp) {
                return false;
            }
            return this.tidx == other.tidx;
        }

        public BitVector getChecks() {
            return this.bv;
        }

        public long getFP() {
            return this.fp;
        }

        public int getTidx() {
            return this.tidx;
        }
    }
}

