/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.Serializable;
import java.util.Collection;
import tlc2.TLCGlobals;
import tlc2.value.impl.Value;
import util.WrongInvocationException;

public class ValueVec
implements Serializable {
    private Value[] elementData;
    private int elementCount;
    private static final Value[] empty = new Value[0];

    public ValueVec() {
        this(10);
    }

    public ValueVec(int initialCapacity) {
        this.elementCount = 0;
        this.elementData = initialCapacity == 0 ? empty : new Value[initialCapacity];
    }

    public ValueVec(Value[] elems) {
        this.elementData = elems;
        this.elementCount = elems.length;
    }

    public ValueVec(Collection<Value> elems) {
        this(elems.size());
        for (Value value : elems) {
            this.addElement(value);
        }
    }

    public final void addElementAt(Value val, int index) {
        this.elementData[index] = val;
        ++this.elementCount;
    }

    public final void addElement(Value val) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        this.elementData[this.elementCount++] = val;
    }

    public final void addElement1(Value val) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        for (int i = 0; i < this.elementCount; ++i) {
            int cmp = this.elementData[i].compareTo(val);
            if (cmp == 0) {
                return;
            }
            if (cmp <= 0) continue;
            for (int j = this.elementCount - 1; j >= i; --j) {
                this.elementData[j + 1] = this.elementData[j];
            }
            this.elementData[i] = val;
            ++this.elementCount;
            return;
        }
        this.elementData[this.elementCount++] = val;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final boolean contains(Value elem) {
        return this.indexOf(elem) != -1;
    }

    public final void copyInto(Value[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public final Value elementAt(int index) {
        return this.elementData[index];
    }

    public final void ensureCapacity(int minCapacity) {
        if (this.elementData.length >= TLCGlobals.setBound) {
            throw new WrongInvocationException("Attempted to construct a set with too many elements (>" + TLCGlobals.setBound + ").");
        }
        if (this.elementData.length < minCapacity) {
            int newCapacity = this.elementData.length + this.elementData.length;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            if (newCapacity > TLCGlobals.setBound) {
                newCapacity = TLCGlobals.setBound;
            }
            Value[] oldData = this.elementData;
            this.elementData = new Value[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final Value firstElement() {
        return this.elementData[0];
    }

    public final int indexOf(Value elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(Value elem, int index) {
        for (int pos = index; pos < this.elementCount; ++pos) {
            if (!elem.equals(this.elementData[pos])) continue;
            return pos;
        }
        return -1;
    }

    public final void insertElementAt(Value obj, int index) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final Value lastElement() {
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(Value obj, int index) {
        this.elementData[index] = obj;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean search(Value elem, boolean sorted) {
        if (sorted) {
            int cmp = 0;
            int mid = 0;
            int low = 0;
            int high = this.elementCount;
            while (low < high) {
                mid = low + high >> 1;
                cmp = elem.compareTo(this.elementData[mid]);
                if (cmp == 0) {
                    return true;
                }
                if (cmp < 0) {
                    high = mid;
                    continue;
                }
                low = mid + 1;
            }
        } else {
            for (int i = 0; i < this.elementCount; ++i) {
                if (!this.elementData[i].equals(elem)) continue;
                return true;
            }
        }
        return false;
    }

    public final ValueVec sort(boolean noDup) {
        int newCount = this.elementCount == 0 ? 0 : 1;
        for (int i = 1; i < this.elementCount; ++i) {
            Value elem = this.elementData[i];
            int cmp = 0;
            int idx = 0;
            int low = 0;
            int high = newCount;
            while (low < high && (cmp = elem.compareTo(this.elementData[idx = low + high >> 1])) != 0) {
                if (cmp < 0) {
                    high = idx;
                    continue;
                }
                low = idx + 1;
            }
            if (cmp == 0 && noDup) continue;
            idx = cmp < 0 ? idx : idx + 1;
            for (int j = newCount; j > idx; --j) {
                this.elementData[j] = this.elementData[j - 1];
            }
            this.elementData[idx] = elem;
            ++newCount;
        }
        this.elementCount = newCount;
        return this;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        if (this.size() > 0) {
            sb = sb.append(this.elementData[0].toString());
        }
        for (int pos = 1; pos < this.size(); ++pos) {
            sb = sb.append(", ");
            sb = sb.append(this.elementData[pos].toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public Value[] toArray() {
        Value[] copy = new Value[this.elementCount];
        System.arraycopy(this.elementData, 0, copy, 0, this.elementCount);
        return copy;
    }
}

