/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.lamport.tla.toolbox.editor.basic.tla.TLAWhitespaceDetector;
import org.lamport.tla.toolbox.editor.basic.tla.TLAWordDetector;
import tla2sany.st.Location;

public class DocumentHelper {
    public static IWordDetector getDefaultWordDetector() {
        return new TLAWordDetector();
    }

    public static IWhitespaceDetector getDefaultWhitespaceDetector() {
        return new TLAWhitespaceDetector();
    }

    public static IRegion getRegionExpandedBackwards(IDocument document, int documentOffset, IWordDetector detector) {
        int charCounter = 0;
        try {
            char c;
            while (detector.isWordPart(c = document.getChar(--documentOffset))) {
                ++charCounter;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Region(documentOffset + 1, charCounter);
    }

    public static IRegion getRegionExpandedForwards(IDocument document, int documentOffset, IWordDetector detector) {
        int charCounter = 0;
        try {
            char c;
            while (detector.isWordPart(c = document.getChar(++documentOffset))) {
                ++charCounter;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Region(documentOffset - charCounter, charCounter + 1);
    }

    public static WordRegion getRegionExpandedBoth(IDocument document, int documentOffset) throws BadLocationException {
        return DocumentHelper.getRegionExpandedBoth(document, documentOffset, DocumentHelper.getDefaultWordDetector());
    }

    public static WordRegion getRegionExpandedBoth(IDocument document, int documentOffset, IWordDetector detector) throws BadLocationException {
        IRegion backwards = DocumentHelper.getRegionExpandedBackwards(document, documentOffset, detector);
        IRegion forwards = DocumentHelper.getRegionExpandedForwards(document, documentOffset, detector);
        String word = document.get(backwards.getOffset(), backwards.getLength() + forwards.getLength());
        return new WordRegion(backwards.getOffset(), backwards.getLength() + forwards.getLength(), word);
    }

    public static IRegion locationToRegion(IDocument document, Location location) throws BadLocationException {
        int offset = document.getLineOffset(location.beginLine() - 1) + location.beginColumn() - 1;
        int length = document.getLineOffset(location.endLine() - 1) + location.endColumn() - offset;
        return new Region(offset, length);
    }

    public static IRegion getRegionWithPreviousLine(IDocument document, IRegion region) throws BadLocationException {
        int currentFirstLine = document.getLineOfOffset(region.getOffset());
        if (currentFirstLine > 0) {
            int newOffset = document.getLineOffset(currentFirstLine - 1);
            return new Region(newOffset, region.getLength() + (region.getOffset() - newOffset));
        }
        return region;
    }

    public static class WordRegion
    extends Region
    implements IRegion {
        private final String word;

        public WordRegion(int offset, int length, String word) {
            super(offset, length);
            this.word = word;
        }

        public String getWord() {
            return this.word;
        }
    }
}

