/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.lamport.tla.toolbox.editor.basic.PDFViewingPage;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;

public class TLAEditorAndPDFViewer
extends FormEditor
implements INavigationLocationProvider,
ITextEditor {
    public static final String ID = "org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer";
    public static final String PDFPage_ID = "pdfPage";
    private static final int tlaEditorIndex = 0;
    private Image rootImage = TLAEditorActivator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox.editor.basic", (String)"/icons/root_file.gif").createImage();
    PDFViewingPage pdfViewingPage;
    IEditorInput tlaEditorInput;
    TLAEditor tlaEditor;

    protected void addPages() {
        try {
            if (this.getContainer() instanceof CTabFolder) {
                CTabFolder cTabFolder = (CTabFolder)this.getContainer();
                cTabFolder.setTabPosition(128);
                if (cTabFolder.getItemCount() <= 1) {
                    cTabFolder.setTabHeight(0);
                } else {
                    cTabFolder.setTabHeight(-1);
                }
            }
            this.tlaEditor = new TLAEditor();
            this.addPage(0, (IEditorPart)this.tlaEditor, this.tlaEditorInput);
            this.setPageText(0, "TLA Module");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public int addPage(IFormPage page) throws PartInitException {
        int idx = super.addPage(page);
        if (this.getContainer() instanceof CTabFolder) {
            CTabFolder cTabFolder = (CTabFolder)this.getContainer();
            if (cTabFolder.getItemCount() <= 1) {
                cTabFolder.setTabHeight(0);
            } else {
                cTabFolder.setTabHeight(-1);
            }
        }
        return idx;
    }

    public void removePage(int pageIndex) {
        super.removePage(pageIndex);
        if (this.getContainer() instanceof CTabFolder) {
            CTabFolder cTabFolder = (CTabFolder)this.getContainer();
            if (cTabFolder.getItemCount() <= 1) {
                cTabFolder.setTabHeight(0);
            } else {
                cTabFolder.setTabHeight(-1);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        FileEditorInput finput;
        this.tlaEditorInput = input;
        if (input instanceof FileEditorInput && (finput = (FileEditorInput)input) != null) {
            IFile file = finput.getFile();
            if (ResourceHelper.isModule((IResource)file)) {
                this.setPartName(file.getName().replaceFirst(".tla$", ""));
            }
            if (ResourceHelper.isRoot((IFile)file)) {
                this.setTitleImage(this.rootImage);
            }
        }
        super.init(site, input);
    }

    public void doSave(IProgressMonitor monitor) {
        this.tlaEditor.doSave(monitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSaveAs() {
        Path newPath;
        Shell shell;
        IFile file;
        block14: {
            File newFile;
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            shell = UIHelper.getShellProvider().getShell();
            Path specRootPrefix = new Path(ResourceHelper.getParentDirName((IResource)ToolboxHandle.getRootModule()));
            FileDialog saveAsDialog = null;
            while (true) {
                saveAsDialog = new FileDialog(shell, 8192);
                saveAsDialog.setOverwrite(true);
                saveAsDialog.setText("Select the new filename...");
                saveAsDialog.setFilterExtensions(new String[]{"*.tla"});
                saveAsDialog.setFilterNames(new String[]{"TLA+ Files"});
                saveAsDialog.setFilterPath(ResourceHelper.getParentDirName((IResource)file));
                String result = saveAsDialog.open();
                saveAsDialog = null;
                if (result == null) return;
                newPath = new Path(result);
                if (!specRootPrefix.isPrefixOf((IPath)newPath)) {
                    MessageDialog.openError((Shell)shell, (String)"Wrong location selected", (String)"The provided filename must point to the same directory as the specification root file");
                    continue;
                }
                if (!"tla".equals(newPath.getFileExtension())) {
                    newPath = newPath.addFileExtension("tla");
                }
                if (!(newFile = newPath.toFile()).exists()) break;
                boolean confirmOverwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite file?", (String)("The provided filename already exists. The existing file will be overwritten.\nDo you want to overwrite the file " + newPath.toOSString() + "?"));
                if (!confirmOverwrite) {
                    continue;
                }
                break block14;
                break;
            }
            boolean newFileCreated = false;
            try {
                newFileCreated = newFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!newFileCreated) {
                MessageDialog.openError((Shell)shell, (String)"Error saving a file", (String)"File could not be created");
                return;
            }
        }
        IFile newResource = ResourceHelper.getLinkedFile((IProject)file.getProject(), (String)newPath.toOSString());
        FileEditorInput newInput = new FileEditorInput(newResource);
        IDocumentProvider provider = this.tlaEditor.getDocumentProvider();
        boolean saveAsSuccess = false;
        try {
            try {
                provider.aboutToChange((Object)newInput);
                provider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)newInput, provider.getDocument((Object)this.getEditorInput()), true);
                saveAsSuccess = true;
                return;
            }
            catch (CoreException x) {
                MessageDialog.openError((Shell)shell, (String)"Error saving a file", (String)"File could not be created");
                provider.changed((Object)newInput);
                if (!saveAsSuccess) return;
                this.setInput((IEditorInput)newInput);
                this.tlaEditor.setInput((IEditorInput)newInput);
                if (!(newInput instanceof FileEditorInput)) return;
                FileEditorInput fin = newInput;
                this.setPartName(fin.getFile().getName());
            }
            return;
        }
        finally {
            provider.changed((Object)newInput);
            if (saveAsSuccess) {
                this.setInput((IEditorInput)newInput);
                this.tlaEditor.setInput((IEditorInput)newInput);
                if (newInput instanceof FileEditorInput) {
                    FileEditorInput fin = newInput;
                    this.setPartName(fin.getFile().getName());
                }
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return this.tlaEditor.isSaveAsAllowed();
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return this.tlaEditor.createEmptyNavigationLocation();
    }

    public INavigationLocation createNavigationLocation() {
        return this.tlaEditor.createNavigationLocation();
    }

    public PDFViewingPage getPDFViewingPage() {
        if (this.pdfViewingPage == null) {
            this.pdfViewingPage = new PDFViewingPage(this, PDFPage_ID, "PDF Viewer");
            try {
                this.addPage((IFormPage)this.pdfViewingPage);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return this.pdfViewingPage;
    }

    public TLAEditor getTLAEditor() {
        return this.tlaEditor;
    }

    public void setFocus() {
        super.setFocus();
        IEditorInput input = this.getEditorInput();
        if (input != null) {
            if (input instanceof FileEditorInput) {
                FileEditorInput fin = (FileEditorInput)input;
                this.tlaEditor.setStatusMessage(String.format("%s [ %s ]", this.getPartName(), fin.getPath().toOSString()));
            } else {
                this.tlaEditor.setStatusMessage(input.getName());
            }
        }
    }

    public void setTLAEditorActive() {
        this.setActivePage(0);
    }

    public IDocumentProvider getDocumentProvider() {
        return this.tlaEditor.getDocumentProvider();
    }

    public boolean isEditable() {
        return this.tlaEditor.isEditable();
    }

    public void doRevertToSaved() {
        this.tlaEditor.doRevertToSaved();
    }

    public void setAction(String actionID, IAction action) {
        this.tlaEditor.setAction(actionID, action);
    }

    public IAction getAction(String actionId) {
        return this.tlaEditor.getAction(actionId);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        this.tlaEditor.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
    }

    public void removeActionActivationCode(String actionId) {
        this.tlaEditor.removeActionActivationCode(actionId);
    }

    public boolean showsHighlightRangeOnly() {
        return this.tlaEditor.showsHighlightRangeOnly();
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        this.tlaEditor.showHighlightRangeOnly(showHighlightRangeOnly);
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        this.tlaEditor.setHighlightRange(offset, length, moveCursor);
    }

    public IRegion getHighlightRange() {
        return this.tlaEditor.getHighlightRange();
    }

    public void resetHighlightRange() {
        this.tlaEditor.resetHighlightRange();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.tlaEditor.getSelectionProvider();
    }

    public void selectAndReveal(int offset, int length) {
        this.tlaEditor.selectAndReveal(offset, length);
    }
}

