/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.semantic.AnyDefNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolMatcher;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;

public class ShowDeclarationsHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell parent = UIHelper.getShellProvider().getShell();
        ShowDeclarationsPopupDialog popup = new ShowDeclarationsPopupDialog(parent);
        popup.open();
        return null;
    }

    public static String infoText(boolean showAll) {
        return "Type space to " + (showAll ? "hide" : "show") + " instantiated definitions";
    }

    public static String titleText(String prefix) {
        if (prefix == "") {
            return "Definitions and Declarations";
        }
        return prefix;
    }

    public static class ShowDeclarationsKeyListener
    implements KeyListener {
        ShowDeclarationsPopupDialog popup;

        public ShowDeclarationsKeyListener(ShowDeclarationsPopupDialog popup) {
            this.popup = popup;
        }

        public void keyPressed(KeyEvent e) {
            char keyPressed = e.character;
            int keyCode = e.keyCode;
            List list = this.popup.list;
            int selection = list.getSelectionIndex();
            e.doit = false;
            if (keyPressed == ' ') {
                this.popup.showAll = !this.popup.showAll;
                this.popup.setList();
                this.popup.setInfoText(ShowDeclarationsHandler.infoText(this.popup.showAll));
                if (list.getItemCount() > 0) {
                    list.select(0);
                }
            } else if (keyCode == 0x1000002 || keyCode == 0x1000004) {
                if (list.getItemCount() == 0 || selection == -1) {
                    return;
                }
                list.select(Math.min(list.getItemCount(), selection + 1));
            } else if (keyCode == 0x1000001 || keyCode == 0x1000003) {
                if (list.getItemCount() == 0 || selection == -1) {
                    return;
                }
                list.select(Math.max(0, selection - 1));
            } else if (keyCode == 13 || keyCode == 0x1000050) {
                SymbolNode node = (SymbolNode)list.getData(list.getSelection()[0]);
                EditorUtil.setReturnFromOpenDecl(this.popup.editor);
                UIHelper.jumpToDefOrDecl((SymbolNode)node);
                this.popup.close();
            } else if (Character.isLetterOrDigit(keyPressed) || keyPressed == '_' || keyPressed == '!' || keyPressed == '\\' || keyPressed == '+' || keyPressed == '-' || keyPressed == '%' || keyPressed == '^' || keyPressed == '.' || keyPressed == '<' || keyPressed == '>' || keyPressed == ':' || keyPressed == '&' || keyPressed == '|' || keyPressed == '#' || keyPressed == '$' || keyPressed == '?' || keyPressed == '@' || keyPressed == '*' || keyPressed == '=' || keyPressed == '/') {
                this.popup.filterPrefix = this.popup.filterPrefix + keyPressed;
                this.popup.setList();
                this.popup.setTitleText(ShowDeclarationsHandler.titleText(this.popup.filterPrefix));
                this.popup.setInfoText(ShowDeclarationsHandler.infoText(this.popup.showAll));
                if (list.getItemCount() > 0) {
                    list.select(0);
                }
            } else if (!(keyCode != 127 && keyCode != 8 || this.popup.filterPrefix.equals(""))) {
                this.popup.filterPrefix = this.popup.filterPrefix.substring(0, this.popup.filterPrefix.length() - 1);
                this.popup.setList();
                this.popup.setTitleText(ShowDeclarationsHandler.titleText(this.popup.filterPrefix));
                this.popup.setInfoText(ShowDeclarationsHandler.infoText(this.popup.showAll));
                if (list.getItemCount() > 0) {
                    list.select(0);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public static class ShowDeclarationsPopupDialog
    extends PopupDialog {
        Shell parent;
        List list;
        boolean showAll = true;
        String filterPrefix = "";
        TLAEditor editor;
        ModuleNode module;
        private final SymbolMatcher.NameAndTypeMatcher matcher = new SymbolMatcher.NameAndTypeMatcher(){

            public Set<Class<? extends SymbolNode>> matchTypes() {
                HashSet<Class<? extends SymbolNode>> set = new HashSet<Class<? extends SymbolNode>>();
                set.add(OpDefNode.class);
                set.add(OpDeclNode.class);
                set.add(ThmOrAssumpDefNode.class);
                return set;
            }

            public boolean matches(SymbolNode aSymbol) {
                if (aSymbol instanceof ThmOrAssumpDefNode || aSymbol instanceof OpDefNode) {
                    if (aSymbol.getKind() == 6) {
                        return false;
                    }
                    if (aSymbol.getKind() == 7) {
                        return false;
                    }
                    if (!ResourceHelper.isFromUserModule((SemanticNode)((SemanticNode)((AnyDefNode)aSymbol).getSource()))) {
                        return false;
                    }
                    if (!showAll && ((AnyDefNode)aSymbol).getSource() != aSymbol) {
                        return false;
                    }
                }
                return super.matches(aSymbol);
            }
        };

        public ShowDeclarationsPopupDialog(Shell parent) {
            super(parent, 8, true, false, true, true, true, "Definitions and Declarations", "");
            this.parent = parent;
            this.showAll = true;
            this.setInfoText(ShowDeclarationsHandler.infoText(this.showAll));
            this.editor = EditorUtil.getTLAEditorWithFocus();
            if (this.editor != null) {
                this.module = ResourceHelper.getModuleNode((String)this.editor.getModuleName());
            }
        }

        public void setInfoText(String str) {
            super.setInfoText(str);
        }

        public void setTitleText(String str) {
            super.setTitleText(str);
        }

        protected void setList() {
            this.list.removeAll();
            if (this.module == null) {
                return;
            }
            Collection symbols = this.module.getSymbols((SymbolMatcher)this.matcher.setPrefix(this.filterPrefix.toLowerCase()));
            for (SymbolNode symbolNode : symbols) {
                this.list.add(symbolNode.getName().toString());
                this.list.setData(symbolNode.getName().toString(), (Object)symbolNode);
            }
        }

        protected Control createDialogArea(Composite composite) {
            this.list = new List(composite, 532);
            this.setList();
            this.list.addSelectionListener((SelectionListener)new ShowDeclarationsSelectionListener(EditorUtil.getTLAEditorWithFocus()));
            this.list.addKeyListener((KeyListener)new ShowDeclarationsKeyListener(this));
            this.list.setSelection(0);
            return this.list;
        }
    }

    public static class ShowDeclarationsSelectionListener
    implements SelectionListener {
        private TLAEditor srcEditor;

        public ShowDeclarationsSelectionListener(TLAEditor editor) {
            this.srcEditor = editor;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            List list = (List)e.widget;
            SymbolNode node = (SymbolNode)list.getData(list.getSelection()[0]);
            EditorUtil.setReturnFromOpenDecl(this.srcEditor);
            UIHelper.jumpToDefOrDecl((SymbolNode)node);
        }
    }
}

