/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.lamport.tla.toolbox.ApplicationWorkbenchAdvisor;
import org.lamport.tla.toolbox.StandaloneActivator;

public class Application
implements IApplication {
    public Object start(IApplicationContext context) throws InvocationTargetException, InterruptedException {
        String instanceLoc;
        String previousInstanceLoc;
        Location instanceLocation;
        Object argObject = context.getArguments().get("application.args");
        if (argObject != null && argObject instanceof String[]) {
            String[] args = (String[])argObject;
            if (args.length != 0) {
                StandaloneActivator.getDefault().logDebug(context.getBrandingName() + " started with " + args.length + " arguments.");
                int i = 0;
                while (i < args.length) {
                    StandaloneActivator.getDefault().logDebug(args[i] + (i == args.length - 1 ? "" : ", "));
                    ++i;
                }
            } else {
                StandaloneActivator.getDefault().logDebug(context.getBrandingName() + " started without arguments.");
            }
        }
        if (!new File((instanceLocation = Platform.getInstanceLocation()).getURL().getFile() + File.separator + ".metadata" + File.separator).exists() && (previousInstanceLoc = Application.getPreviousInstanceLocation(instanceLocation)) != null && !(instanceLoc = instanceLocation.getURL().toExternalForm()).equals(previousInstanceLoc)) {
            Application.clearPreviousInstanceLocation(instanceLocation);
            MessageDialog md = new MessageDialog(PlatformUI.createDisplay().getActiveShell(), "Migrate Toolbox files.", null, "Previously, your Toolbox used a different location to store its list of specifications and preferences. Starting with Toolbox release 1.5.4, the Toolbox keeps this data in a canonical location.\n\nIf you do not let the Toolbox migrate this data, it will come up with default preferences and an empty spec explorer. You will have to manually configure the preferences and import your existing specifications.\n\nClick \"Migrate\" if you want the Toolbox to migrate the data now and continue Toolbox start-up.\n\nClick \"Start Fresh\" to continue Toolbox start-up and to manually import your specifications.", 3, new String[]{"Migrate", "Start Fresh"}, 0);
            if (md.open() == 0) {
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                pmd.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Migrating Toolbox metadata to new location.", -1);
                        Application.copyRecurively(Application.toPath(previousInstanceLoc, ".metadata"), Application.toPath(instanceLoc), monitor);
                        monitor.done();
                    }
                });
            }
        }
        StandaloneActivator.getDefault().getStateLocation();
        try {
            if (!instanceLocation.lock()) {
                File workspaceDirectory = new File(Platform.getInstanceLocation().getURL().getFile());
                if (workspaceDirectory.exists()) {
                    MessageDialog.openError((Shell)PlatformUI.createDisplay().getActiveShell(), (String)"Toolbox files cannot be locked", (String)NLS.bind((String)"Could not launch the Toolbox because the associated workspace is currently in use by another Toolbox. Opening two instances on the same workspace leads to data corruption.\n\nIf this is incorrect and there is no other Toolbox running, an earlier Toolbox terminated without releasing the lock. Please manually delete the lock file ''{0}'' and try restarting the Toolbox.", (Object)workspaceDirectory.getAbsolutePath().concat(File.separator + ".metadata" + File.separator + ".lock")));
                }
                System.exit(0);
            }
        }
        catch (IOException e) {
            StandaloneActivator.getDefault().logError("Toolbox files cannot be locked", e);
            MessageDialog.openError((Shell)PlatformUI.createDisplay().getActiveShell(), (String)"Toolbox files cannot be locked", (String)"Could not launch the Toolbox because acquiring the associated workspace lock failed. We are sorry, this is a bug. Please get in contact with us.");
            System.exit(0);
        }
        Display display = PlatformUI.createDisplay();
        try {
            Integer n;
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                n = IApplication.EXIT_RESTART;
                return n;
            }
            n = IApplication.EXIT_OK;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException((Throwable)e){

                @Override
                public String toString() {
                    return "The Toolbox failed to launch because of an unexpected error. Please try to launch the Toolbox with the \"-clean\" parameter.\nIf \"-clean\" does not fix the problem, please open a bug and attach the .log file.\n\n" + super.toString();
                }
            };
        }
        finally {
            display.dispose();
        }
    }

    private static Path toPath(String prefix) {
        return Application.toPath(prefix, "");
    }

    private static Path toPath(String prefix, String suffix) {
        if (prefix.replaceFirst("file:", "").contains(":")) {
            return Paths.get(prefix.replaceFirst("file:/", ""), suffix);
        }
        return Paths.get(prefix.replaceFirst("file:", ""), suffix);
    }

    private static void clearPreviousInstanceLocation(Location instanceLocation) {
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLocation.getDefault());
        launchData.setRecentWorkspaces(new String[0]);
        launchData.writePersistedData();
    }

    private static String getPreviousInstanceLocation(Location instanceLocation) {
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLocation.getDefault());
        List<String> recentWorkspaces = Arrays.asList(launchData.getRecentWorkspaces());
        if (!recentWorkspaces.isEmpty()) {
            int i = 0;
            while (i < recentWorkspaces.size()) {
                if (recentWorkspaces.get(i) != null) {
                    return recentWorkspaces.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    private static void copyRecurively(final Path src, Path dst, final IProgressMonitor monitor) throws InvocationTargetException {
        try {
            dst.toFile().mkdir();
            final Path target = dst.resolve(src.getFileName());
            Files.walkFileTree(src, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.copy(dir, target.resolve(src.relativize(dir)), StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        // empty catch block
                    }
                    monitor.worked(1);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, target.resolve(src.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES);
                    monitor.worked(1);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                    Files.setLastModifiedTime(target.resolve(src.relativize(dir)), time);
                    monitor.worked(1);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

