/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.preference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TLCChainedPreferenceStore
implements IPreferenceStore {
    private IPreferenceStore[] fPreferenceStores;
    private ListenerList<IPropertyChangeListener> fClientListeners = new ListenerList(1);
    private List<PropertyChangeListener> fChildListeners = new ArrayList<PropertyChangeListener>();

    public TLCChainedPreferenceStore(IPreferenceStore[] preferenceStores) {
        Assert.isTrue((preferenceStores != null && preferenceStores.length > 0 ? 1 : 0) != 0);
        this.fPreferenceStores = new IPreferenceStore[preferenceStores.length];
        System.arraycopy(preferenceStores, 0, this.fPreferenceStores, 0, preferenceStores.length);
        int i = 0;
        int length = this.fPreferenceStores.length;
        while (i < length) {
            PropertyChangeListener listener = new PropertyChangeListener(this.fPreferenceStores[i]);
            this.fChildListeners.add(listener);
            ++i;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fClientListeners.size() == 0) {
            this.registerChildListeners();
        }
        this.fClientListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fClientListeners.remove((Object)listener);
        if (this.fClientListeners.size() == 0) {
            this.unregisterChildListeners();
        }
    }

    public boolean contains(String name) {
        return this.getVisibleStore(name) != null;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.firePropertyChangeEvent(new PropertyChangeEvent((Object)this, name, oldValue, newValue));
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        Object[] listeners = this.fClientListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public boolean getBoolean(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getBoolean(name);
        }
        return false;
    }

    public boolean getDefaultBoolean(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getDefaultBoolean(name);
        }
        return false;
    }

    public double getDefaultDouble(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getDefaultDouble(name);
        }
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getDefaultFloat(name);
        }
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getDefaultInt(name);
        }
        return 0;
    }

    public long getDefaultLong(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getDefaultLong(name);
        }
        return 0L;
    }

    public String getDefaultString(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getDefaultString(name);
        }
        return "";
    }

    public double getDouble(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getDouble(name);
        }
        return 0.0;
    }

    public float getFloat(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getFloat(name);
        }
        return 0.0f;
    }

    public int getInt(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getInt(name);
        }
        return 0;
    }

    public long getLong(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getLong(name);
        }
        return 0L;
    }

    public String getString(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.getString(name);
        }
        return "";
    }

    public boolean isDefault(String name) {
        IPreferenceStore visibleStore = this.getVisibleStore(name);
        if (visibleStore != null) {
            return visibleStore.isDefault(name);
        }
        return false;
    }

    public boolean needsSaving() {
        IPreferenceStore[] iPreferenceStoreArray = this.fPreferenceStores;
        int n = this.fPreferenceStores.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceStore store = iPreferenceStoreArray[n2];
            if (store.needsSaving()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void putValue(String name, String value) {
        this.getVisibleStore(name).putValue(name, value);
    }

    public void setDefault(String name, double value) {
        this.getVisibleStore(name).setDefault(name, value);
    }

    public void setDefault(String name, float value) {
        this.getVisibleStore(name).setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.getVisibleStore(name).setDefault(name, value);
    }

    public void setDefault(String name, long value) {
        this.getVisibleStore(name).setDefault(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.getVisibleStore(name).setDefault(name, defaultObject);
    }

    public void setDefault(String name, boolean value) {
        this.getVisibleStore(name).setDefault(name, value);
    }

    public void setToDefault(String name) {
        this.getVisibleStore(name).setToDefault(name);
    }

    public void setValue(String name, double value) {
        this.getVisibleStore(name).setValue(name, value);
    }

    public void setValue(String name, float value) {
        this.getVisibleStore(name).setValue(name, value);
    }

    public void setValue(String name, int value) {
        this.getVisibleStore(name).setValue(name, value);
    }

    public void setValue(String name, long value) {
        this.getVisibleStore(name).setValue(name, value);
    }

    public void setValue(String name, String value) {
        this.getVisibleStore(name).setValue(name, value);
    }

    public void setValue(String name, boolean value) {
        this.getVisibleStore(name).setValue(name, value);
    }

    private void handlePropertyChangeEvent(IPreferenceStore childPreferenceStore, PropertyChangeEvent event) {
        String property = event.getProperty();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        IPreferenceStore visibleStore = this.getVisibleStore(property);
        if (visibleStore == null && newValue != null) {
            visibleStore = childPreferenceStore;
        }
        if (visibleStore == null) {
            if (oldValue != null) {
                this.firePropertyChangeEvent(event);
            }
        } else if (visibleStore == childPreferenceStore) {
            if (oldValue != null) {
                this.firePropertyChangeEvent(event);
            } else {
                IPreferenceStore oldVisibleStore = null;
                int i = 0;
                int length = this.fPreferenceStores.length;
                while (i < length && this.fPreferenceStores[i++] != visibleStore) {
                }
                while (oldVisibleStore == null && i < length) {
                    if (this.fPreferenceStores[i].contains(property)) {
                        oldVisibleStore = this.fPreferenceStores[i];
                    }
                    ++i;
                }
                if (oldVisibleStore == null) {
                    this.firePropertyChangeEvent(event);
                } else {
                    oldValue = this.getOtherValue(property, oldVisibleStore, newValue);
                    if (!oldValue.equals(newValue)) {
                        this.firePropertyChangeEvent(property, oldValue, newValue);
                    }
                }
            }
        } else {
            boolean eventBeforeVisibleStore = false;
            int i = 0;
            int length = this.fPreferenceStores.length;
            while (i < length) {
                IPreferenceStore store = this.fPreferenceStores[i];
                if (store == visibleStore) break;
                if (store == childPreferenceStore) {
                    eventBeforeVisibleStore = true;
                    break;
                }
                ++i;
            }
            if (eventBeforeVisibleStore && !(newValue = this.getOtherValue(property, visibleStore, oldValue)).equals(oldValue)) {
                this.firePropertyChangeEvent(property, oldValue, newValue);
            }
        }
    }

    private Object getOtherValue(String property, IPreferenceStore store, Object thisValue) {
        if (thisValue instanceof Boolean) {
            return store.getBoolean(property) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (thisValue instanceof Double) {
            return store.getDouble(property);
        }
        if (thisValue instanceof Float) {
            return Float.valueOf(store.getFloat(property));
        }
        if (thisValue instanceof Integer) {
            return store.getInt(property);
        }
        if (thisValue instanceof Long) {
            return store.getLong(property);
        }
        if (thisValue instanceof String) {
            return store.getString(property);
        }
        return store.getString(property);
    }

    private IPreferenceStore getVisibleStore(String property) {
        if (property.toLowerCase().contains("color") && !property.endsWith("predicate") || property.contains("appliesToLeafOnly") || property.contains("stepStatusOverview")) {
            return this.fPreferenceStores[0];
        }
        return this.fPreferenceStores[1];
    }

    private void registerChildListeners() {
        for (PropertyChangeListener listener : this.fChildListeners) {
            listener.register();
        }
    }

    private void unregisterChildListeners() {
        for (PropertyChangeListener listener : this.fChildListeners) {
            listener.unregister();
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private IPreferenceStore fPreferenceStore;

        public PropertyChangeListener(IPreferenceStore preferenceStore) {
            this.setPreferenceStore(preferenceStore);
        }

        public void propertyChange(PropertyChangeEvent event) {
            IPreferenceStore childPreferenceStore = this.getPreferenceStore();
            TLCChainedPreferenceStore.this.handlePropertyChangeEvent(childPreferenceStore, event);
        }

        public void register() {
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void unregister() {
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }

        public IPreferenceStore getPreferenceStore() {
            return this.fPreferenceStore;
        }

        public void setPreferenceStore(IPreferenceStore preferenceStore) {
            this.fPreferenceStore = preferenceStore;
        }
    }
}

