/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.prover.job.ProverJob;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.tool.prover.ui.dialog.TLAPMErrorDialog;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ColorPredicate;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ErrorMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationStatus;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationStatusMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.StepStatusMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.StepTuple;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.WarningMessage;
import org.lamport.tla.toolbox.tool.prover.ui.view.ObligationsView;
import org.lamport.tla.toolbox.ui.dialog.InformationDialog;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.LegacyFileDocumentProvider;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.semantic.LeafProofNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.TheoremNode;
import tla2sany.semantic.UseOrHideNode;
import tla2sany.st.Location;
import util.UniqueString;

public class ProverHelper {
    public static final String OBLIGATION_MARKER = "org.lamport.tla.toolbox.tool.prover.obligation";
    public static final String OBLIGATION_ID = "org.lamport.tla.toolbox.tool.prover.obId";
    public static final String SANY_MARKER = "org.lamport.tla.toolbox.tool.prover.ui.sanyMarker";
    public static final String SANY_LOC_ATR = "org.lamport.tla.toolbox.tool.prover.ui.sanyLoc";
    public static final String SANY_IS_LEAF_ATR = "org.lamport.tla.toolbox.tool.prover.ui.isLeafStep";
    public static final String LOC_DELIM = ":";
    public static final String BEING_PROVED = "being proved";
    public static final String PROVED = "proved";
    public static final String FAILED = "failed";
    public static final String TRIVIAL = "trivial";
    public static final String INTERUPTED = "interrupted";
    public static final String TO_BE_PROVED = "to be proved";
    public static final String STEP_PROVING_FAILED_MARKER = "org.lamport.tla.toolbox.tool.prover.ui.stepProvingFailed";
    public static final String STEP_CHECKING_FAILED_MARKER = "org.lamport.tla.toolbox.tool.prover.ui.stepCheckingFailed";
    public static final String STEP_MISSING_MARKER = "org.lamport.tla.toolbox.tool.prover.ui.stepMissing";
    public static final String STEP_OMITTED_MARKER = "org.lamport.tla.toolbox.tool.prover.ui.stepOmitted";
    public static final String STEP_CHECKED_MARKER = "org.lamport.tla.toolbox.tool.prover.ui.stepChecked";
    public static final String STEP_PROVED_MARKER = "org.lamport.tla.toolbox.tool.prover.ui.stepProved";
    public static final String STEP_BEING_PROVED_MARKER = "org.lamport.tla.toolbox.tool.prover.ui.stepBeingProved";
    public static final String STEP_LEAF_FAILED = "org.lamport.tla.toolbox.tool.prover.ui.leafFailed";
    public static final String STEP_STATUS_MARKER = "org.lamport.tla.toolbox.tool.prover.ui.proofStepStatus";
    public static final int STEP_CHECKED_INT = 0;
    public static final int STEP_PROVED_INT = 1;
    public static final int STEP_TO_BE_PROVED_INT = 2;
    public static final int STEP_BEING_PROVED_INT = 3;
    public static final int STEP_PROOF_OMITTED_INT = 4;
    public static final int STEP_PROOF_MISSING_INT = 5;
    public static final int STEP_PROVING_FAILED_INT = 6;
    public static final int STEP_CHECKING_FAILED_INT = 100;
    public static final int STEP_UNKNOWN_INT = -1;

    public static void clearObligationMarkers(IResource resource) throws CoreException {
        if (resource.exists()) {
            resource.deleteMarkers(OBLIGATION_MARKER, false, 1);
        }
    }

    public static boolean isInterestingObligation(ObligationStatus status) {
        int obState = status.getObligationState();
        String[] proverStatuses = ColorPredicate.proverStatuses(obState);
        boolean oneSucceeded = false;
        boolean oneFailed = false;
        boolean oneStopped = false;
        int i = 0;
        while (i < proverStatuses.length) {
            if (proverStatuses[i].equals("proving")) {
                return true;
            }
            if (proverStatuses[i].equals(FAILED)) {
                oneFailed = true;
            } else if (proverStatuses[i].equals("stopped")) {
                oneStopped = true;
            } else if (proverStatuses[i].equals(PROVED)) {
                oneSucceeded = true;
            }
            ++i;
        }
        return !oneSucceeded && (oneFailed || oneStopped);
    }

    public static boolean isBeingProvedObligation(ObligationStatus status) {
        int obState = status.getObligationState();
        String[] proverStatuses = ColorPredicate.proverStatuses(obState);
        int i = 0;
        while (i < proverStatuses.length) {
            if (proverStatuses[i].equals("proving")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isObligationFinished(ObligationStatusMessage message, ProverJob proverJob) {
        String status = message.getStatus();
        boolean isTrivial = status.equals(TRIVIAL);
        return isTrivial || status.equals(PROVED);
    }

    public static IMarker[] getObMarkersCurSpec() throws CoreException {
        if (ToolboxHandle.getCurrentSpec() != null) {
            return ToolboxHandle.getCurrentSpec().getProject().findMarkers(OBLIGATION_MARKER, false, 1);
        }
        return null;
    }

    public static ObligationStatus[] getObligationStatuses() {
        if (ProverJob.getLastJob() == null) {
            return null;
        }
        ProverJob lastJob = ProverJob.getLastJob();
        if (ToolboxHandle.getCurrentSpec() == null || !lastJob.getModule().getProject().equals((Object)ToolboxHandle.getCurrentSpec().getProject())) {
            return null;
        }
        Collection<ObligationStatus> statuses = lastJob.getObsMap().values();
        return statuses.toArray(new ObligationStatus[statuses.size()]);
    }

    public static void removeSANYStepMarkers(IResource module) throws CoreException {
        module.deleteMarkers(SANY_MARKER, false, 0);
    }

    public static void prepareModuleForProverLaunch(final IFile module, final ProverJob proverJob) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (module == null) {
                    ProverUIActivator.getDefault().logDebug("Module is null in method prepareModuleForProverLaunch. This is a bug.");
                    return;
                }
                if (proverJob.getLevelNode() == null) {
                    ProverUIActivator.getDefault().logDebug("Module is null in method prepareModuleForProverLaunch. This is a bug.");
                    return;
                }
                ProverHelper.removeSANYStepMarkers((IResource)module);
                if (proverJob.getLevelNode() instanceof ModuleNode) {
                    ProverHelper.removeStatusFromModule((IResource)module);
                } else {
                    ProverHelper.removeStatusFromTree(module, proverJob.getLevelNode());
                }
                proverJob.getObsMap().clear();
                proverJob.getLeafStepMap().clear();
                proverJob.getStepMessageMap().clear();
                if (proverJob.getLevelNode() instanceof ModuleNode) {
                    ParseResult parseResult = ResourceHelper.getValidParseResult((IFile)module);
                    if (parseResult == null) {
                        return;
                    }
                    String moduleName = ResourceHelper.getModuleName((IResource)module);
                    ModuleNode moduleNode = parseResult.getSpecObj().getExternalModuleTable().getModuleNode(UniqueString.uniqueStringOf((String)moduleName));
                    LevelNode[] topLevelNodes = moduleNode.getTopLevel();
                    int i = 0;
                    while (i < topLevelNodes.length) {
                        if (topLevelNodes[i].getLocation().source().equals(moduleName)) {
                            ProverHelper.prepareTreeForProverLaunch(topLevelNodes[i], (IResource)module, proverJob);
                        }
                        ++i;
                    }
                } else {
                    ProverHelper.prepareTreeForProverLaunch(proverJob.getLevelNode(), (IResource)module, proverJob);
                    return;
                }
            }
        };
        module.getWorkspace().run(runnable, null, 1, null);
    }

    public static StepTuple prepareTreeForProverLaunch(LevelNode levelNode, IResource module, ProverJob proverJob) throws CoreException {
        if (levelNode == null) {
            return null;
        }
        if (levelNode instanceof UseOrHideNode || levelNode instanceof TheoremNode) {
            Location locForAttr;
            IMarker marker = module.createMarker(SANY_MARKER);
            if (levelNode instanceof UseOrHideNode) {
                locForAttr = levelNode.getLocation();
            } else {
                TheoremNode theoremNode = (TheoremNode)levelNode;
                Location beginLoc = theoremNode.getLocation();
                Location statementLoc = theoremNode.getTheorem().getLocation();
                locForAttr = new Location(UniqueString.uniqueStringOf((String)statementLoc.source()), beginLoc.beginLine(), beginLoc.beginColumn(), statementLoc.endLine(), statementLoc.endColumn());
            }
            marker.setAttribute(SANY_LOC_ATR, (Object)ProverHelper.locToString(locForAttr));
            IRegion locRegion = AdapterFactory.locationToRegion((Location)locForAttr);
            marker.setAttribute("charStart", locRegion.getOffset());
            marker.setAttribute("charEnd", locRegion.getOffset() + locRegion.getLength());
            StepTuple stepTuple = new StepTuple(proverJob);
            stepTuple.setSanyMarker(marker);
            if (levelNode instanceof TheoremNode) {
                TheoremNode theoremNode = (TheoremNode)levelNode;
                ProofNode proof = theoremNode.getProof();
                if (proof != null) {
                    if (proof instanceof NonLeafProofNode) {
                        NonLeafProofNode nonLeafProof = (NonLeafProofNode)proof;
                        LevelNode[] steps = nonLeafProof.getSteps();
                        marker.setAttribute(SANY_IS_LEAF_ATR, steps.length == 0);
                        int i = 0;
                        while (i < steps.length) {
                            StepTuple childTuple = ProverHelper.prepareTreeForProverLaunch(steps[i], module, proverJob);
                            if (childTuple != null) {
                                childTuple.setParent(stepTuple);
                                stepTuple.addChild(childTuple);
                            }
                            ++i;
                        }
                    } else {
                        marker.setAttribute(SANY_IS_LEAF_ATR, true);
                        LeafProofNode leafProof = (LeafProofNode)proof;
                        if (leafProof.getOmitted()) {
                            stepTuple.addChild(new ObligationStatus(stepTuple, ProverHelper.createObligationMarker(-1, theoremNode.getLocation()), 1, theoremNode.getLocation(), -1));
                        }
                    }
                } else {
                    OpApplNode opApplAss;
                    String name;
                    marker.setAttribute(SANY_IS_LEAF_ATR, true);
                    LevelNode assertion = theoremNode.getTheorem();
                    boolean shouldHaveProof = true;
                    if (assertion instanceof OpApplNode && ((name = (opApplAss = (OpApplNode)assertion).getOperator().getName().toString()).equals("$Have") || name.equals("$Take") || name.equals("$Witness"))) {
                        shouldHaveProof = false;
                    }
                    if (shouldHaveProof) {
                        stepTuple.addChild(new ObligationStatus(stepTuple, ProverHelper.createObligationMarker(-1, theoremNode.getLocation()), 0, theoremNode.getLocation(), -1));
                    }
                }
            } else {
                marker.setAttribute(SANY_IS_LEAF_ATR, true);
            }
            if (marker.getAttribute(SANY_IS_LEAF_ATR, false) && proverJob.getLeafStepMap().put(locForAttr.beginLine(), stepTuple) != null) {
                System.out.println("Two steps start on line " + locForAttr.beginLine());
                UIHelper.runUIAsync((Runnable)new ResourceHelper.ErrorMessageRunnable("Error in Proof", "Two different proof steps begin on line" + locForAttr.beginLine() + ".\nThis may cause an error in reporting the proof status of some steps.\n\nAlways start a new proof step on a separate line."));
            }
            return stepTuple;
        }
        return null;
    }

    public static String locToString(Location location) {
        StringBuilder sb = new StringBuilder();
        sb.append(location.source()).append(LOC_DELIM).append(location.beginLine()).append(LOC_DELIM).append(location.beginColumn()).append(LOC_DELIM).append(location.endLine()).append(LOC_DELIM).append(location.endColumn());
        return sb.toString();
    }

    public static Location stringToLoc(String locString) {
        String[] segments = locString.split(LOC_DELIM);
        return new Location(UniqueString.uniqueStringOf((String)segments[0]), Integer.parseInt(segments[1]), Integer.parseInt(segments[2]), Integer.parseInt(segments[3]), Integer.parseInt(segments[4]));
    }

    public static IMarker findSANYMarker(IResource module, Location location) {
        try {
            IMarker[] sanyMarkers = module.findMarkers(SANY_MARKER, false, 0);
            int i = 0;
            while (i < sanyMarkers.length) {
                Location sanyLoc;
                String sanyLocString = sanyMarkers[i].getAttribute(SANY_LOC_ATR, "");
                if (sanyLocString.length() != 0 && (sanyLoc = ProverHelper.stringToLoc(sanyLocString)).beginLine() == location.beginLine()) {
                    return sanyMarkers[i];
                }
                ++i;
            }
        }
        catch (CoreException e) {
            ProverUIActivator.getDefault().logError("Error finding existing SANY marker for location " + String.valueOf(location), e);
        }
        return null;
    }

    public static String statusStringToMarkerType(String status, boolean isLeafStep) {
        if (status == null) {
            return null;
        }
        if (status.equals("checked")) {
            return STEP_CHECKED_MARKER;
        }
        if (status.equals("checking failed")) {
            return STEP_CHECKING_FAILED_MARKER;
        }
        if (status.equals("missing proofs")) {
            return STEP_MISSING_MARKER;
        }
        if (status.equals("omitted proofs")) {
            return STEP_OMITTED_MARKER;
        }
        if (status.equals(PROVED)) {
            return STEP_PROVED_MARKER;
        }
        if (status.equals("proving failed")) {
            if (isLeafStep) {
                return STEP_LEAF_FAILED;
            }
            return STEP_PROVING_FAILED_MARKER;
        }
        if (status.equals(BEING_PROVED)) {
            return STEP_BEING_PROVED_MARKER;
        }
        return null;
    }

    public static String colorPredNumToMarkerType(int predNum, boolean isLeaf) {
        return "org.lamport.tla.toolbox.tool.prover.ui.stepColor" + predNum + (isLeaf ? "B" : "A");
    }

    public static String statusIntToStatusString(int status) {
        switch (status) {
            case 0: {
                return "checked";
            }
            case 100: {
                return "checking failed";
            }
            case 5: {
                return "missing proofs";
            }
            case 4: {
                return "omitted proofs";
            }
            case 1: {
                return PROVED;
            }
            case 6: {
                return "proving failed";
            }
            case 3: {
                return BEING_PROVED;
            }
            case 2: {
                return TO_BE_PROVED;
            }
        }
        return null;
    }

    public static void processObligationMessage(ObligationStatusMessage message, final ProverJob proverJob) {
        if (message.getStatus().equals(TO_BE_PROVED)) {
            if (proverJob.getNoToBeProved()) {
                ProverUIActivator.getDefault().logDebug("First to be proved " + proverJob.getCurRelTime());
                proverJob.setNoToBeProved(false);
            }
            proverJob.addObMessageList(message);
        } else {
            ObligationStatus obStatus;
            if (proverJob.isToBeProvedOnly()) {
                ProverUIActivator.getDefault().logDebug("Before obligation marker creation " + proverJob.getCurRelTime());
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        for (ObligationStatusMessage message : proverJob.getObMessageList()) {
                            IMarker obMarker = ProverHelper.createObligationMarker(message.getID(), message.getLocation());
                            ObligationStatus obStatus = new ObligationStatus(null, obMarker, ColorPredicate.TO_BE_PROVED_STATE, message.getLocation(), message.getID());
                            proverJob.getObsMap().put(message.getID(), obStatus);
                        }
                    }
                };
                try {
                    proverJob.getModule().getWorkspace().run(runnable, null, 1, null);
                }
                catch (CoreException e) {
                    ProverUIActivator.getDefault().logError("Error creating marker obligations", e);
                }
                proverJob.setToBeProvedOnly(false);
                ProverUIActivator.getDefault().logDebug("After obligation marker creation " + proverJob.getCurRelTime());
            }
            if ((obStatus = proverJob.getObsMap().get(message.getID())).getParent() == null) {
                ProverUIActivator.getDefault().logDebug("Before ob parenting creation " + proverJob.getCurRelTime());
                for (ObligationStatus obligation : proverJob.getObs()) {
                    int searchLine = obligation.getTLAPMLocation().beginLine();
                    while (searchLine >= 0) {
                        StepTuple stepTuple = proverJob.getLeafStepMap().get(searchLine);
                        if (stepTuple != null) {
                            obligation.setParent(stepTuple);
                            stepTuple.addChild(obligation);
                            break;
                        }
                        --searchLine;
                    }
                    if (searchLine >= 0) continue;
                    UIHelper.runUIAsync((Runnable)new ResourceHelper.ErrorMessageRunnable("Error", "There is an error in the information sent by\nTLAPS to the Toolbox.  This may cause incorrect\nreporting of a step's proof status.\n\nPlease report this problem to the developers."));
                }
                ProverUIActivator.getDefault().logDebug("After ob parenting creation " + proverJob.getCurRelTime());
            }
            try {
                obStatus.updateObligation(message);
            }
            catch (NullPointerException e) {
                System.out.println("NullPointerException caused by message with id " + message.getID() + " and location " + message.getLocation().toString());
            }
            UIHelper.runUIAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    ObligationsView.updateObligationView(obStatus);
                }
            });
        }
    }

    public static IMarker createObligationMarker(int id, Location location) {
        IResource module = ResourceHelper.getResourceByModuleName((String)location.source());
        if (module != null && module instanceof IFile && module.exists()) {
            FileEditorInput fileEditorInput = new FileEditorInput((IFile)module);
            LegacyFileDocumentProvider fileDocumentProvider = new LegacyFileDocumentProvider();
            try {
                HashMap<String, Integer> markerAttributes = new HashMap<String, Integer>();
                markerAttributes.put(OBLIGATION_ID, id);
                fileDocumentProvider.connect((Object)fileEditorInput);
                IDocument document = fileDocumentProvider.getDocument((Object)fileEditorInput);
                IRegion obRegion = AdapterFactory.locationToRegion((IDocument)document, (Location)location);
                markerAttributes.put("charStart", obRegion.getOffset());
                markerAttributes.put("charEnd", obRegion.getOffset() + obRegion.getLength());
                IMarker marker = module.createMarker(OBLIGATION_MARKER);
                marker.setAttributes(markerAttributes);
                IMarker iMarker = marker;
                return iMarker;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            finally {
                fileDocumentProvider.disconnect((Object)fileEditorInput);
            }
        }
        return null;
    }

    public static void newStepStatusMessage(StepStatusMessage status, ProverJob proverJob) {
        proverJob.getStepMessageMap().put(status.getLocation().beginLine(), status);
    }

    public static void compareStepStatusComputations(ProverJob proverJob) {
    }

    public static void newStepStatusMarker(final IMarker sanyMarker, int predNum) {
        if (sanyMarker == null) {
            ProverUIActivator.getDefault().logDebug("Null sanyMarker passed to newStepStatusMarker. This is a bug.");
            return;
        }
        try {
            final IResource module = sanyMarker.getResource();
            final String markerType = ProverHelper.colorPredNumToMarkerType(predNum, sanyMarker.getAttribute(SANY_IS_LEAF_ATR, false));
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int newCharEnd;
                    int newCharStart;
                    Position curPosition = EditorUtil.getMarkerPosition((IMarker)sanyMarker);
                    if (curPosition != null) {
                        newCharStart = curPosition.getOffset();
                        newCharEnd = curPosition.getOffset() + curPosition.getLength();
                    } else {
                        newCharStart = sanyMarker.getAttribute("charStart", 0);
                        newCharEnd = sanyMarker.getAttribute("charEnd", 0);
                    }
                    IMarker[] existingMarkers = module.findMarkers(ProverHelper.STEP_STATUS_MARKER, true, 0);
                    int i = 0;
                    while (i < existingMarkers.length) {
                        IMarker existingMarker = existingMarkers[i];
                        int existingCharStart = existingMarker.getAttribute("charStart", -1);
                        int existingCharEnd = existingMarker.getAttribute("charEnd", -1);
                        if (existingCharStart < newCharEnd && existingCharEnd > newCharStart) {
                            existingMarker.delete();
                        }
                        ++i;
                    }
                    if (markerType != null) {
                        HashMap<String, Integer> markerAttributes = new HashMap<String, Integer>(2);
                        markerAttributes.put("charStart", newCharStart);
                        markerAttributes.put("charEnd", newCharEnd);
                        markerAttributes.put("lineNumber", ProverHelper.stringToLoc(sanyMarker.getAttribute(ProverHelper.SANY_LOC_ATR, "")).beginLine());
                        IMarker newMarker = module.createMarker(markerType);
                        newMarker.setAttributes(markerAttributes);
                    }
                }
            };
            module.getWorkspace().run(runnable, null, 1, null);
        }
        catch (CoreException e) {
            ProverUIActivator.getDefault().logError("Error creating new status marker.", e);
        }
    }

    public static void removeStatusFromModule(IResource module) {
        try {
            module.deleteMarkers(STEP_STATUS_MARKER, true, 0);
        }
        catch (CoreException e) {
            ProverUIActivator.getDefault().logError("Error removing status markers from module " + String.valueOf(module), e);
        }
    }

    public static void removeStatusFromTree(IFile module, LevelNode root) {
        try {
            IDocument document = ResourceHelper.getDocFromFile((IFile)module);
            int beginLine = root.getLocation().beginLine() - 1;
            int endLine = root.getLocation().endLine() - 1;
            if (root instanceof TheoremNode && ((TheoremNode)root).getProof() != null) {
                endLine = ((TheoremNode)root).getProof().getLocation().endLine() - 1;
            }
            int treeBeginChar = document.getLineOffset(beginLine);
            int treeEndChar = document.getLineOffset(endLine) + document.getLineLength(endLine);
            IMarker[] markers = module.findMarkers(STEP_STATUS_MARKER, true, 0);
            int i = 0;
            while (i < markers.length) {
                IMarker newMarker;
                IMarker oldMarker = markers[i];
                int markerStartChar = oldMarker.getAttribute("charStart", -1);
                int markerEndChar = oldMarker.getAttribute("charEnd", -1);
                if (markerStartChar >= treeBeginChar && markerEndChar <= treeEndChar) {
                    oldMarker.delete();
                } else if (markerStartChar < treeBeginChar && markerEndChar >= treeBeginChar && markerEndChar <= treeEndChar) {
                    newMarker = module.createMarker(oldMarker.getType());
                    newMarker.setAttribute("charStart", markerStartChar);
                    newMarker.setAttribute("charEnd", treeBeginChar - 1);
                    oldMarker.delete();
                } else if (markerStartChar < treeBeginChar && markerEndChar > treeEndChar) {
                    IMarker beforeMarker = module.createMarker(oldMarker.getType());
                    beforeMarker.setAttribute("charStart", markerStartChar);
                    beforeMarker.setAttribute("charEnd", treeBeginChar - 1);
                    IMarker afterMarker = module.createMarker(oldMarker.getType());
                    afterMarker.setAttribute("charStart", treeEndChar + 1);
                    afterMarker.setAttribute("charEnd", markerEndChar);
                    oldMarker.delete();
                } else if (markerStartChar >= treeBeginChar && markerStartChar <= treeEndChar && markerEndChar > treeEndChar) {
                    newMarker = module.createMarker(oldMarker.getType());
                    newMarker.setAttribute("charStart", treeEndChar + 1);
                    newMarker.setAttribute("charEnd", markerEndChar);
                    oldMarker.delete();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            ProverUIActivator.getDefault().logError("Error removing status markers from tree rooted at " + String.valueOf(root), e);
        }
        catch (BadLocationException e) {
            ProverUIActivator.getDefault().logError("Error removing status markers from tree rooted at " + String.valueOf(root), e);
        }
    }

    public static void cancelProverJobs(boolean wait) {
        ProverJob.ProverJobMatcher jobMatcher = new ProverJob.ProverJobMatcher();
        Job.getJobManager().cancel((Object)jobMatcher);
        if (wait) {
            while (Job.getJobManager().find((Object)jobMatcher).length > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    ProverUIActivator.getDefault().logError("Error sleeping thread.", e);
                }
            }
        }
    }

    public static void runProverForActiveSelection(boolean checkStatus, boolean isaprove) {
        boolean proceed = UIHelper.promptUserForDirtyModules();
        if (!proceed) {
            return;
        }
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        Assert.isNotNull((Object)editor, (String)"User attempted to run prover without a tla editor in focus. This is a bug.");
        String[] options = null;
        if (isaprove) {
            options = new String[]{"--isaprove"};
        }
        ProverJob proverJob = new ProverJob(((FileEditorInput)editor.getEditorInput()).getFile(), ((ITextSelection)editor.getSelectionProvider().getSelection()).getOffset(), checkStatus, options, true);
        proverJob.setUser(true);
        proverJob.schedule();
    }

    public static void runProverForEntireModule(boolean checkStatus, boolean isaprove) {
        boolean proceed = UIHelper.promptUserForDirtyModules();
        if (!proceed) {
            return;
        }
        String[] options = null;
        if (isaprove) {
            options = new String[]{"--isaprove"};
        }
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        Assert.isNotNull((Object)editor, (String)"User attempted to run prover without a tla editor in focus. This is a bug.");
        ProverJob proverJob = new ProverJob(((FileEditorInput)editor.getEditorInput()).getFile(), -1, checkStatus, options, true);
        proverJob.setUser(true);
        proverJob.schedule();
    }

    public static int getIntFromStringStatus(String status, int currentState, String backEndName) {
        int backendNum = ProverHelper.getNumOfBackend(backEndName);
        if (status.equals(PROVED) || status.equals(TRIVIAL)) {
            return ColorPredicate.newStateNumber(currentState, backendNum, ColorPredicate.numberOfProverStatus(backendNum, PROVED));
        }
        if (status.equals(BEING_PROVED)) {
            return ColorPredicate.newStateNumber(currentState, backendNum, ColorPredicate.numberOfProverStatus(backendNum, "proving"));
        }
        if (status.equals(FAILED)) {
            return ColorPredicate.newStateNumber(currentState, backendNum, ColorPredicate.numberOfProverStatus(backendNum, FAILED));
        }
        if (status.equals(INTERUPTED)) {
            return ColorPredicate.newStateNumber(currentState, backendNum, ColorPredicate.numberOfProverStatus(backendNum, "stopped"));
        }
        Assert.isTrue((boolean)false, (String)("Unknown status : " + status));
        return currentState;
    }

    public static int getNumOfBackend(String backend) {
        if (backend.equals("isabelle")) {
            return 0;
        }
        if (backend.equals("tlapm")) {
            return 2;
        }
        return 1;
    }

    public static void processWarningMessage(final WarningMessage warningMessage) {
        UIHelper.runUIAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                InformationDialog.openWarning((String)warningMessage.getMessage(), (String)"TLAPM Warning");
            }
        });
    }

    public static void processErrorMessage(final ErrorMessage message) {
        UIHelper.runUIAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                TLAPMErrorDialog.open(message.getMessage(), "TLAPM Error", message.getURL());
            }
        });
    }

    public static void stopObligation(IMarker marker) {
        ProverUIActivator.getDefault().logDebug("Stop obligation " + marker.getAttribute(OBLIGATION_ID, -1));
        int numProverJobs = 0;
        Job[] jobs = Job.getJobManager().find((Object)new ProverJob.ProverJobMatcher());
        int i = 0;
        while (i < jobs.length) {
            if (jobs[i] instanceof ProverJob && jobs[i].getState() == 4) {
                ++numProverJobs;
                ProverJob proverJob = (ProverJob)jobs[i];
                proverJob.stopObligation(marker.getAttribute(OBLIGATION_ID, -1));
            }
            ++i;
        }
        if (numProverJobs > 1) {
            ProverUIActivator.getDefault().logDebug("We found " + numProverJobs + " running when obligation " + marker.getAttribute(OBLIGATION_ID, -1) + " was stopped. This is a bug.");
        }
    }

    public static void setThreadsOption(List<String> command) {
        String numThreadsText = ProverUIActivator.getDefault().getPreferenceStore().getString("num_threads");
        if (numThreadsText.trim().length() == 0) {
            return;
        }
        command.add("--threads");
        command.add(numThreadsText);
    }

    public static void setSolverOption(List<String> command) {
        String solverText = ProverUIActivator.getDefault().getPreferenceStore().getString("solver");
        if (solverText.trim().length() == 0) {
            return;
        }
        command.add("--solver");
        command.add(solverText);
    }

    public static void setSafeFPOption(List<String> command) {
        boolean safefp = ProverUIActivator.getDefault().getPreferenceStore().getBoolean("safefp");
        if (safefp) {
            command.add("--safefp");
        }
    }
}

