/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.part;

import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.BasicFormPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableTableSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.provider.AssignmentContentProvider;
import org.lamport.tla.toolbox.tool.tlc.ui.wizard.AssignmentWizard;
import tlc2.model.Assignment;

public class ValidateableConstantSectionPart
extends ValidateableTableSectionPart {
    public ValidateableConstantSectionPart(Composite composite, String title, String description, FormToolkit toolkit, int flags, BasicFormPage page, String sectionName) {
        super(composite, title, description, toolkit, flags, page, sectionName);
    }

    protected Assignment doEditFormula(Assignment formula) {
        Assert.isNotNull((Object)formula);
        AssignmentWizard wizard = new AssignmentWizard(this.getSection().getText(), this.getSection().getDescription(), formula, 1, "constant_assignment_wizard");
        WizardDialog dialog = new WizardDialog(this.getTableViewer().getTable().getShell(), (IWizard)wizard);
        wizard.setWizardDialog(dialog);
        dialog.setHelpAvailable(true);
        if (dialog.open() == 0) {
            return wizard.getFormula();
        }
        return null;
    }

    @Override
    protected void doAdd() {
        Assignment formula = this.doEditFormula((Assignment)null);
        if (formula != null) {
            Vector input = (Vector)this.tableViewer.getInput();
            input.add(formula);
            this.tableViewer.setInput((Object)input);
            this.doMakeDirty();
        }
    }

    @Override
    protected void doEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Assignment formula = (Assignment)selection.getFirstElement();
        if (formula == null) {
            return;
        }
        Assignment editedFormula = this.doEditFormula(formula);
        if (editedFormula != null) {
            formula.setParams(editedFormula.getParams());
            formula.setRight(editedFormula.getRight());
            super.doMakeDirty();
            this.tableViewer.refresh();
        }
    }

    @Override
    protected TableViewer createTableViewer(Table table) {
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new AssignmentContentProvider());
        tableViewer.addSelectionChangedListener(this.fSelectionChangedListener);
        tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ValidateableConstantSectionPart.this.doEdit();
            }
        });
        return tableViewer;
    }

    @Override
    protected Table createTable(Composite sectionArea, FormToolkit toolkit) {
        Table table = toolkit.createTable(sectionArea, 66306);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        return table;
    }

    @Override
    protected void createButtons(Composite sectionArea, FormToolkit toolkit, boolean add, boolean edit, boolean remove) {
        this.doCreateButtons(sectionArea, toolkit, false, true, false);
    }
}

