/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output;

import org.eclipse.jface.text.BadLocationException;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.IProcessOutputSink;
import org.lamport.tla.toolbox.tool.tlc.output.source.TagBasedTLCOutputIncrementalParser;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;

public class ParsingTLCOutputSink
implements IProcessOutputSink {
    private TagBasedTLCOutputIncrementalParser parser;
    private String buffer = "";

    public synchronized void appendText(String text) {
        int length;
        text = this.buffer + (String)text;
        this.buffer = "";
        int lastLineBreak = ((String)text).lastIndexOf(10);
        if (lastLineBreak == (length = ((String)text).length())) {
            this.addIncrement((String)text);
        } else {
            String substring = ((String)text).substring(0, lastLineBreak + 1);
            this.addIncrement(substring);
            this.buffer = ((String)text).substring(lastLineBreak + 1);
        }
    }

    private void addIncrement(String input) {
        try {
            this.parser.addIncrement(input);
        }
        catch (BadLocationException e) {
            TLCUIActivator.getDefault().logError("Error parsing the TLC output stream for " + String.valueOf(this.parser.getSource().getModel()), e);
        }
    }

    public void initializeSink(Model model, int sinkType) {
        boolean isTraceExploration = sinkType == 3;
        this.parser = new TagBasedTLCOutputIncrementalParser(model, 4, isTraceExploration);
    }

    public void processFinished() {
        if (this.buffer.length() > 0) {
            this.addIncrement(this.buffer);
        }
        this.parser.done();
    }
}

