/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.lamport.tla.toolbox.tool.tlc.output.data.ActionInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.ModuleCoverageInformation;
import org.lamport.tla.toolbox.tool.tlc.output.data.Representation;
import org.lamport.tla.toolbox.tool.tlc.ui.util.IModuleLocatable;
import tla2sany.st.Location;

public class CoverageInformationItem
implements IModuleLocatable {
    private static final String COLON = ": ";
    private static final String AT = "at ";
    protected Location location;
    protected String modelName;
    protected long count;
    protected long cost;
    protected int layer;
    private final Set<CoverageInformationItem> siblings = new HashSet<CoverageInformationItem>();
    private final Set<CoverageInformationItem> childs = new HashSet<CoverageInformationItem>();
    private CoverageInformationItem parent;
    private ActionInformationItem root;
    private boolean active = false;
    protected final Map<Representation, Color[]> representations = new HashMap<Representation, Color[]>();
    private IRegion region;

    protected CoverageInformationItem(Location location, long count, String modelName, int layer) {
        this.location = location;
        this.count = count;
        this.modelName = modelName;
        assert (layer >= -1);
        this.layer = layer;
    }

    public CoverageInformationItem(Location location, long count, long cost, String modelName, int layer) {
        this(location, count, modelName, layer);
        this.cost = cost;
    }

    public CoverageInformationItem() {
    }

    public final String getModule() {
        return this.location.source();
    }

    public final String getLocation() {
        return this.location.linesAndColumns();
    }

    public final boolean isInFile(IFile f) {
        String nameWithoutSuffix = f.getName().replace(".tla", "");
        return nameWithoutSuffix.equalsIgnoreCase(this.location.source());
    }

    public boolean includeInCounts() {
        return true;
    }

    public long getCount() {
        return this.count;
    }

    public final long getCost() {
        return this.cost;
    }

    public long getCountAndCost() {
        return this.count + this.cost;
    }

    public int getLayer() {
        return this.layer;
    }

    public static CoverageInformationItem parse(String outputMessage, String modelName) {
        outputMessage = outputMessage.trim();
        int layer = outputMessage.lastIndexOf(124) + 1;
        int index = outputMessage.indexOf(COLON);
        return new CoverageInformationItem(Location.parseLocation((String)outputMessage.substring(layer, index)), Long.parseLong(outputMessage.substring(index + COLON.length())), modelName, layer);
    }

    public static CoverageInformationItem parseCost(String outputMessage, String modelName) {
        outputMessage = outputMessage.trim();
        Pattern pattern = Pattern.compile("^(\\|*?)(line .*): ([0-9]+):([0-9]+)$");
        Matcher matcher = pattern.matcher(outputMessage);
        matcher.find();
        int layer = matcher.group(1).length();
        Location location = Location.parseLocation((String)matcher.group(2));
        long count = Long.parseLong(matcher.group(3));
        long cost = Long.parseLong(matcher.group(4));
        return new CoverageInformationItem(location, count, cost, modelName, layer);
    }

    public static String parseCoverageTimestamp(String outputMessage) {
        return outputMessage.substring(outputMessage.lastIndexOf(AT) + AT.length());
    }

    @Override
    public Location getModuleLocation() {
        return this.location;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    CoverageInformationItem setRoot(ActionInformationItem root) {
        this.root = root;
        return this;
    }

    CoverageInformationItem setSiblings(List<CoverageInformationItem> siblings) {
        this.siblings.clear();
        this.siblings.addAll(siblings);
        this.siblings.remove(this);
        return this;
    }

    boolean hasSiblings() {
        return !this.siblings.isEmpty();
    }

    public long getTotalCount() {
        return this.siblings.stream().mapToLong(CoverageInformationItem::getCount).sum() + this.getCount();
    }

    public long getTotalCost() {
        return this.siblings.stream().mapToLong(CoverageInformationItem::getCost).sum() + this.getCost();
    }

    public long getTotalCountAndCost() {
        return this.getTotalCost() + this.getTotalCount();
    }

    Collection<CoverageInformationItem> getChildren() {
        return this.childs;
    }

    CoverageInformationItem addChild(CoverageInformationItem child) {
        assert (child != this);
        this.childs.add(child);
        assert (child.parent == null);
        child.parent = this;
        child.root = this.root;
        return this;
    }

    CoverageInformationItem setLayer(int i) {
        assert (this.layer > -1);
        this.layer = i;
        return this;
    }

    public IRegion getRegion() {
        return this.region;
    }

    CoverageInformationItem setRegion(IRegion locationToRegion) {
        this.region = locationToRegion;
        return this;
    }

    protected boolean isRoot() {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    protected StyleRange addStlye(StyleRange sr) {
        return sr;
    }

    public void style(TextPresentation textPresentation, Representation rep) {
        if (this.isRoot()) {
            this.style(textPresentation, true, rep);
        } else {
            this.style(textPresentation, false, rep);
        }
    }

    protected void style(TextPresentation textPresentation, boolean merge, Representation rep) {
        if (!this.isRoot()) {
            StyleRange rs = new StyleRange();
            rs.start = this.region.getOffset();
            rs.length = this.region.getLength();
            rs.background = rep.getColor(this, merge ? Representation.Grouping.COMBINED : Representation.Grouping.INDIVIDUAL);
            if (!(rep != Representation.STATES_DISTINCT && rep != Representation.STATES || this instanceof ActionInformationItem)) {
                rs.background = JFaceResources.getColorRegistry().get("GRAY");
                rs.borderStyle = 0;
                rs.borderColor = null;
            } else if (rep != Representation.COST && rep.getValue(this, Representation.Grouping.INDIVIDUAL) == 0L) {
                rs.background = null;
                rs.borderStyle = 1;
                rs.borderColor = JFaceResources.getColorRegistry().get("RED");
            }
            rs.data = this;
            this.active = true;
            textPresentation.mergeStyleRange(this.addStlye(rs));
        }
        for (CoverageInformationItem child : this.childs) {
            child.style(textPresentation, merge, rep);
        }
    }

    public void style(TextPresentation textPresentation, Color c, Representation rep) {
        if (!this.isRoot()) {
            StyleRange rs = new StyleRange();
            rs.start = this.region.getOffset();
            rs.length = this.region.getLength();
            rs.background = c;
            if (!(rep != Representation.STATES_DISTINCT && rep != Representation.STATES || this instanceof ActionInformationItem)) {
                rs.background = JFaceResources.getColorRegistry().get("GRAY");
                rs.borderStyle = 0;
                rs.borderColor = null;
            } else if (rep != Representation.COST && rep.getValue(this, Representation.Grouping.INDIVIDUAL) == 0L) {
                rs.background = null;
                rs.borderStyle = 1;
                rs.borderColor = JFaceResources.getColorRegistry().get("RED");
            }
            this.active = false;
            textPresentation.replaceStyleRange(this.addStlye(rs));
        }
        for (CoverageInformationItem child : this.childs) {
            child.style(textPresentation, c, rep);
        }
    }

    Color colorItem(TreeSet<Long> counts, Representation rep) {
        int hue = ModuleCoverageInformation.getHue(rep.getValue(this, Representation.Grouping.INDIVIDUAL), counts);
        String key = Integer.toString(hue);
        if (!JFaceResources.getColorRegistry().hasValueFor(key)) {
            JFaceResources.getColorRegistry().put(key, new RGB((float)hue, 0.25f, 1.0f));
        }
        Color color = JFaceResources.getColorRegistry().get(key);
        Color[] colors = new Color[2];
        colors[Representation.Grouping.INDIVIDUAL.ordinal()] = color;
        colors[Representation.Grouping.COMBINED.ordinal()] = color;
        this.representations.put(rep, colors);
        if (this.hasSiblings()) {
            hue = ModuleCoverageInformation.getHue(rep.getValue(this, Representation.Grouping.COMBINED), counts);
            key = Integer.toString(hue);
            if (!JFaceResources.getColorRegistry().hasValueFor(key)) {
                JFaceResources.getColorRegistry().put(key, new RGB((float)hue, 0.25f, 1.0f));
            }
            Color aggregate = JFaceResources.getColorRegistry().get(key);
            colors = new Color[2];
            colors[Representation.Grouping.INDIVIDUAL.ordinal()] = color;
            colors[Representation.Grouping.COMBINED.ordinal()] = aggregate;
            this.representations.put(rep, colors);
            return aggregate;
        }
        return color;
    }

    public CoverageInformationItem getParent() {
        return this.parent;
    }

    public ActionInformationItem getRoot() {
        return this.root;
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public TreeSet<CoverageInformationItem> getLegend(Representation rep) {
        if (rep == Representation.STATES || rep == Representation.STATES_DISTINCT) {
            TreeSet<CoverageInformationItem> s = new TreeSet<CoverageInformationItem>(rep.getComparator(Representation.Grouping.INDIVIDUAL));
            s.add(this);
            return s;
        }
        return this.collectActive(new TreeSet<CoverageInformationItem>(rep.getComparator(Representation.Grouping.INDIVIDUAL)));
    }

    protected TreeSet<CoverageInformationItem> collectActive(TreeSet<CoverageInformationItem> legend) {
        if (this.addThisToLegend()) {
            legend.add(this);
        }
        for (CoverageInformationItem child : this.childs) {
            if (!child.isActive()) continue;
            child.collectActive(legend);
        }
        return legend;
    }

    protected boolean addThisToLegend() {
        return true;
    }
}

