/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;

public class StateSpaceInformationItem {
    private Date time;
    private long diameter;
    private long foundStates;
    private long distinctStates;
    private long leftStates;
    private long spm;
    private long distinctSPM;
    private boolean isMostRecent = true;

    private StateSpaceInformationItem(Date time, long diameter, long foundStates, long distinctStates, long leftStates, long spm, long distinctSPM) {
        this.time = time;
        this.diameter = diameter;
        this.foundStates = foundStates;
        this.distinctStates = distinctStates;
        this.leftStates = leftStates;
        this.spm = spm;
        this.distinctSPM = distinctSPM;
    }

    private StateSpaceInformationItem(Date time, long foundStates, long distinctStates) {
        this(time, 0L, foundStates, distinctStates, distinctStates, 0L, 0L);
    }

    private StateSpaceInformationItem(Date time, long distinctStates) {
        this(time, distinctStates, distinctStates);
    }

    private StateSpaceInformationItem(long foundStates, long distinctStates) {
        this(new Date(), 0L, foundStates, distinctStates, distinctStates, 0L, 0L);
    }

    private StateSpaceInformationItem(long distinctStates) {
        this(distinctStates, distinctStates);
    }

    public boolean isMostRecent() {
        return this.isMostRecent;
    }

    public void setMostRecent(boolean isMostRecent) {
        this.isMostRecent = isMostRecent;
    }

    public final Date getTime() {
        return this.time;
    }

    public final void setTime(Date time) {
        this.time = time;
    }

    public final long getDiameter() {
        return this.diameter;
    }

    public final void setDiameter(long diameter) {
        this.diameter = diameter;
    }

    public final long getFoundStates() {
        return this.foundStates;
    }

    public final void setFoundStates(long foundStates) {
        this.foundStates = foundStates;
    }

    public final long getDistinctStates() {
        return this.distinctStates;
    }

    public final void setDistinctStates(int distinctStates) {
        this.distinctStates = distinctStates;
    }

    public final long getLeftStates() {
        return this.leftStates;
    }

    public final void setLeftStates(long leftStates) {
        this.leftStates = leftStates;
    }

    public long getSpm() {
        return this.spm;
    }

    public long getDistinctSPM() {
        return this.distinctSPM;
    }

    private static long localizedNum2Long(String number) {
        String justDigits = number.replaceAll("[^0-9]", "");
        return Long.parseLong(justDigits);
    }

    public static StateSpaceInformationItem parse(String outputMessage) {
        String OB = "(";
        String AT = ") at ";
        String COLON = ": ";
        String GENERATED = " states generated (";
        String SPM = " s/min), ";
        String DISTINCT = " distinct states found (";
        String DISTINCT_SPM = " ds/min), ";
        String LEFT = " states left on queue.";
        int[] i = new int[]{outputMessage.indexOf("("), outputMessage.indexOf(") at "), outputMessage.indexOf(": "), outputMessage.indexOf(" states generated ("), outputMessage.indexOf(" s/min), "), outputMessage.indexOf(" distinct states found ("), outputMessage.indexOf(" ds/min), "), outputMessage.indexOf(" states left on queue.")};
        int j = 0;
        while (j < i.length) {
            if (i[j] == -1) {
                return StateSpaceInformationItem.parseOld(outputMessage);
            }
            ++j;
        }
        try {
            Date time = TLCModelLaunchDataProvider.parseDate(outputMessage.substring(i[1] + ") at ".length(), i[2]));
            long diameter = StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[0] + "(".length(), i[1]));
            long foundStates = StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[2] + ": ".length(), i[3]));
            long statesPerMinute = StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[3] + " states generated (".length(), i[4]));
            long distinctStates = StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[4] + " s/min), ".length(), i[5]));
            long distinctStatesPerMinute = StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[5] + " distinct states found (".length(), i[6]));
            long leftStates = StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[6] + " ds/min), ".length(), i[7]));
            return new StateSpaceInformationItem(time, diameter, foundStates, distinctStates, leftStates, statesPerMinute, distinctStatesPerMinute);
        }
        catch (NumberFormatException e) {
            TLCUIActivator.getDefault().logError("Error reading progress information", e);
            return null;
        }
    }

    public static StateSpaceInformationItem parseInit(String outputMessage) {
        Pattern pattern = Pattern.compile("^Finished computing initial states: ([0-9]+) distinct state[s]* generated.$");
        Matcher matcher = pattern.matcher(outputMessage);
        if (matcher.find()) {
            long distinctStates = Long.parseLong(matcher.group(1));
            return new StateSpaceInformationItem(distinctStates);
        }
        pattern = Pattern.compile("^Finished computing initial states: ([0-9]+) states generated, with ([0-9]+) of them distinct.$");
        matcher = pattern.matcher(outputMessage);
        if (matcher.find()) {
            long foundStates = Long.parseLong(matcher.group(1));
            long distinctStates = Long.parseLong(matcher.group(2));
            return new StateSpaceInformationItem(foundStates, distinctStates);
        }
        pattern = Pattern.compile("^Finished computing initial states: ([0-9]+) distinct state[s]* generated at (.*).$");
        matcher = pattern.matcher(outputMessage);
        if (matcher.find()) {
            long distinctStates = Long.parseLong(matcher.group(1));
            Date date = TLCModelLaunchDataProvider.parseDate(matcher.group(2));
            return new StateSpaceInformationItem(date, distinctStates);
        }
        pattern = Pattern.compile("^Finished computing initial states: ([0-9]+) states generated, with ([0-9]+) of them distinct at (.*).$");
        matcher = pattern.matcher(outputMessage);
        if (matcher.find()) {
            long foundStates = Long.parseLong(matcher.group(1));
            long distinctStates = Long.parseLong(matcher.group(2));
            Date date = TLCModelLaunchDataProvider.parseDate(matcher.group(3));
            return new StateSpaceInformationItem(date, foundStates, distinctStates);
        }
        return null;
    }

    public static StateSpaceInformationItem parseOld(String outputMessage) {
        String OB = "(";
        String AT = ") at ";
        String COLON = ": ";
        String GENERATED = " states generated, ";
        String DISTINCT = " distinct states found, ";
        String LEFT = " states left on queue.";
        int[] i = new int[]{outputMessage.indexOf("("), outputMessage.indexOf(") at "), outputMessage.indexOf(": "), outputMessage.indexOf(" states generated, "), outputMessage.indexOf(" distinct states found, "), outputMessage.indexOf(" states left on queue.")};
        int j = 0;
        while (j < i.length) {
            if (i[j] == -1) {
                TLCUIActivator.getDefault().logError("Error reading progress information", new IllegalArgumentException(outputMessage + " is in wrong format"));
                return null;
            }
            ++j;
        }
        try {
            return new StateSpaceInformationItem(TLCModelLaunchDataProvider.parseDate(outputMessage.substring(i[1] + ") at ".length(), i[2])), StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[0] + "(".length(), i[1])), StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[2] + ": ".length(), i[3])), StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[3] + " states generated, ".length(), i[4])), StateSpaceInformationItem.localizedNum2Long(outputMessage.substring(i[4] + " distinct states found, ".length(), i[5])), 0L, 0L);
        }
        catch (NumberFormatException e) {
            TLCUIActivator.getDefault().logError("Error reading progress information", e);
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.diameter ^ this.diameter >>> 32);
        result = 31 * result + (int)(this.distinctStates ^ this.distinctStates >>> 32);
        result = 31 * result + (int)(this.foundStates ^ this.foundStates >>> 32);
        result = 31 * result + (int)(this.leftStates ^ this.leftStates >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateSpaceInformationItem other = (StateSpaceInformationItem)obj;
        if (this.diameter != other.diameter) {
            return false;
        }
        if (this.distinctStates != other.distinctStates) {
            return false;
        }
        if (this.foundStates != other.foundStates) {
            return false;
        }
        return this.leftStates == other.leftStates;
    }
}

