/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.dialog;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;

public class FilteredDefinitionSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SETTINGS = "org.lamport.tla.toolbox.tool.tlc.ui.dialog.FilteredDefinitionSelectionDialog";
    private SpecObj specObj;
    private final Set<String> names = new HashSet<String>();

    private static String toString(OpDefNode node) {
        Object name = node.getName().toString();
        if (node.getSource() != node) {
            name = ((String)name).substring(((String)name).lastIndexOf("!") + 1);
            name = (String)name + " [" + node.getSource().getOriginallyDefinedInModuleNode().getName().toString() + "]";
        }
        return name;
    }

    public FilteredDefinitionSelectionDialog(Shell shell, boolean multi, SpecObj specObj, String[] names) {
        super(shell, multi);
        this.specObj = specObj;
        this.setListLabelProvider(this.getListLabelProvider());
        this.setDetailsLabelProvider(this.getDetailLabelProvider());
        this.setSelectionHistory(new DefinitionHistory());
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            OpDefNode opDefNode = ModelHelper.getOpDefNode((SpecObj)specObj, (String)name);
            this.names.add(FilteredDefinitionSelectionDialog.toString(opDefNode));
            ++n2;
        }
    }

    private ILabelProvider getDetailLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof OpDefNode) {
                    OpDefNode node = (OpDefNode)element;
                    return node.getSource().getName().toString() + (String)(node.getSource().getOriginallyDefinedInModuleNode() != null ? " : " + node.getSource().getOriginallyDefinedInModuleNode().getName().toString() : "");
                }
                return super.getText(element);
            }
        };
    }

    private ILabelProvider getListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof OpDefNode) {
                    OpDefNode node = (OpDefNode)element;
                    if (node.getSource() == node) {
                        return node.getName().toString();
                    }
                    IPreferenceStore ips = TLCUIActivator.getDefault().getPreferenceStore();
                    String style = ips.getString("definitionOverrideStyle");
                    boolean moduleNameStyle = "byModuleName".equals(style);
                    if (moduleNameStyle) {
                        return node.getSource().getName().toString() + " [" + node.getSource().getOriginallyDefinedInModuleNode().getName().toString() + "]";
                    }
                    if (node.getSource().getOriginallyDefinedInModuleNode() != null) {
                        return node.getName().toString();
                    }
                    return node.getSource().getName().toString();
                }
                return super.getText(element);
            }
        };
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new DefinitionFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (this.specObj == null) {
            return;
        }
        OpDefNode[] opDefs = this.specObj.getExternalModuleTable().getRootModule().getOpDefs();
        HashSet<String> dupes = new HashSet<String>(opDefs.length);
        progressMonitor.beginTask("Looking up definitions...", opDefs.length);
        int i = 0;
        while (i < opDefs.length) {
            OpDefNode opDefNode = opDefs[i];
            String string = FilteredDefinitionSelectionDialog.toString(opDefNode);
            if (!this.names.contains(string) && !dupes.contains(string)) {
                dupes.add(string);
                contentProvider.add((Object)opDefNode, itemsFilter);
                progressMonitor.worked(1);
            }
            ++i;
        }
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        OpDefNode node = (OpDefNode)item;
        return node.getSource().getName().toString() + node.getSource().getOriginallyDefinedInModuleNode().getName().toString();
    }

    protected Comparator<OpDefNode> getItemsComparator() {
        return new Comparator<OpDefNode>(){

            @Override
            public int compare(OpDefNode node0, OpDefNode node1) {
                int moduleCompare;
                ModuleNode module0 = node0.getOriginallyDefinedInModuleNode();
                ModuleNode module1 = node1.getOriginallyDefinedInModuleNode();
                boolean module0user = ToolboxHandle.isUserModule((String)module0.getName().toString());
                boolean module1user = ToolboxHandle.isUserModule((String)module1.getName().toString());
                if (module0user) {
                    if (!module1user) {
                        return -1;
                    }
                } else if (module1user) {
                    return 1;
                }
                if ((moduleCompare = module0.getName().toString().compareToIgnoreCase(module1.getName().toString())) == 0) {
                    return node0.getName().toString().compareToIgnoreCase(node1.getName().toString());
                }
                return moduleCompare;
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = TLCUIActivator.getDefault().getDialogSettings().getSection(SETTINGS);
        if (settings == null) {
            settings = TLCUIActivator.getDefault().getDialogSettings().addNewSection(SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public class DefinitionFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public DefinitionFilter() {
            super((FilteredItemsSelectionDialog)FilteredDefinitionSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            if (this.getPattern() == null || this.getPattern().length() == 0) {
                return true;
            }
            return this.matches(((OpDefNode)item).getSource().getName().toString());
        }
    }

    public class DefinitionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        protected Object restoreItemFromMemento(IMemento element) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
        }
    }
}

