/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.editor.basic.TLAEditorReadOnly;
import org.lamport.tla.toolbox.editor.basic.TLASourceViewerConfiguration;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.ModuleCoverageInformation;
import org.lamport.tla.toolbox.tool.tlc.output.data.Representation;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.util.UIHelper;

public class TLACoverageEditor
extends TLAEditorReadOnly {
    private static final Color lightGray;
    private static final Color darkGray;
    protected final Image coverageEditorImage = TLAEditorActivator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox.tool.tlc.ui", (String)"/icons/full/report2_obj.gif").createImage();
    private final ResizeListener resizeListener = new ResizeListener();
    private ModuleCoverageInformation coverage;
    private Composite heatMapComposite;
    private TLACoveragePainter painter;
    private static final DecimalFormat df;
    private static final Pair ALL;
    private static final Pair TERMINATE;

    static {
        JFaceResources.getColorRegistry().put("LIGHT_GRAY", new RGB(245, 245, 245));
        JFaceResources.getColorRegistry().put("DARK_GRAY", new RGB(200, 200, 200));
        lightGray = JFaceResources.getColorRegistry().get("LIGHT_GRAY");
        darkGray = JFaceResources.getColorRegistry().get("DARK_GRAY");
        df = new DecimalFormat("0.0E0");
        ALL = new Pair(-1);
        TERMINATE = new Pair(-42);
    }

    public TLACoverageEditor(ModuleCoverageInformation coverage) {
        this.coverage = coverage;
    }

    public void dispose() {
        this.painter.queue.offer(TERMINATE);
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.addListener(11, (Listener)this.resizeListener);
        Composite editorComposite = new Composite(composite, 0);
        editorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fillLayout.spacing = 0;
        editorComposite.setLayout((Layout)fillLayout);
        this.heatMapComposite = new Composite(composite, 2048);
        GridData layoutData = new GridData(4, 128, true, false);
        this.heatMapComposite.setLayoutData((Object)layoutData);
        this.heatMapComposite.setLayout((Layout)new FillLayout(256));
        ISourceViewer createSourceViewer = super.createSourceViewer(editorComposite, ruler, styles);
        final StyledText textWidget = createSourceViewer.getTextWidget();
        textWidget.setCursor(new Cursor((Device)textWidget.getDisplay(), 21));
        textWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == SWT.MOD1 || e.keyCode == SWT.MOD2 || e.keyCode == SWT.MOD3 || e.keyCode == SWT.MOD4) {
                    return;
                }
                textWidget.setBackground(darkGray);
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == SWT.MOD1 || e.keyCode == SWT.MOD2 || e.keyCode == SWT.MOD3 || e.keyCode == SWT.MOD4) {
                    return;
                }
                textWidget.setBackground(lightGray);
            }
        });
        return createSourceViewer;
    }

    protected void initEditorNameAndDescription(IEditorInput input) {
        if (input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            this.setPartName(fei.getName().replaceFirst(".tla$", " (ro)"));
            this.setTitleImage(this.coverageEditorImage);
        } else {
            TLCActivator.logDebug((String)("Unexpected input for TLACoverageEditor of type: " + input.getClass().getName()));
        }
    }

    protected boolean isEditorInputIncludedInContextMenu() {
        return false;
    }

    protected TLASourceViewerConfiguration getTLASourceViewerConfiguration(IPreferenceStore preferenceStore) {
        return new TLACoverageSourceViewerConfiguration(preferenceStore, (TLAEditor)this);
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        this.painter = new TLACoveragePainter(this);
        ((TextViewer)viewer).addTextPresentationListener((ITextPresentationListener)this.painter);
        return super.getSourceViewerDecorationSupport(viewer);
    }

    public void resetInput(ModuleCoverageInformation ci) throws PartInitException {
        if (this.coverage == ci) {
            return;
        }
        this.coverage = ci;
        this.painter.queue.offer(ALL);
    }

    private static class Pair {
        public final int offset;
        public final Representation rep;

        public Pair(int offset) {
            this(offset, Representation.INV);
        }

        public Pair(int offset, Representation rep) {
            this.offset = offset;
            this.rep = rep;
        }
    }

    private static class ResizeListener
    implements Listener {
        private final Point size = new Point(1024, 768);

        private ResizeListener() {
        }

        public void handleEvent(Event event) {
            Widget widget = event.widget;
            if (widget instanceof Composite) {
                Composite c = (Composite)widget;
                this.size.x = c.getSize().x;
                this.size.y = c.getSize().y;
            }
        }

        public int getWidth() {
            return this.size.x;
        }
    }

    public class TLACoveragePainter
    implements ITextPresentationListener {
        private ComboViewer viewer;
        private final TLACoverageEditor editor;
        private final BlockingQueue<Pair> queue = new ArrayBlockingQueue<Pair>(10);
        private final Job painter = new Job("Coverage Painter"){

            protected IStatus run(IProgressMonitor monitor) {
                while (true) {
                    Pair p = this.getPair();
                    if (TLACoverageEditor.TERMINATE.offset == p.offset || monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    monitor.beginTask(String.format("Painting coverage for %s", p.offset), 1);
                    final Representation.Grouping grouping = TLACoverageEditor.ALL.offset == p.offset ? Representation.Grouping.COMBINED : Representation.Grouping.INDIVIDUAL;
                    TreeSet<CoverageInformationItem> legend = new TreeSet<CoverageInformationItem>();
                    if (grouping == Representation.Grouping.COMBINED) {
                        ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.coverage.getRoot().style(TLACoveragePainter.this.textPresentation, p.rep);
                        legend = ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.coverage.getLegend(p.rep);
                    } else {
                        CoverageInformationItem node = ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.coverage.getNode(p.offset);
                        if (node != null) {
                            ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.coverage.getRoot().style(TLACoveragePainter.this.textPresentation, JFaceResources.getColorRegistry().get("GRAY"), p.rep);
                            node.style(TLACoveragePainter.this.textPresentation, p.rep);
                            legend = node.getLegend(p.rep);
                        }
                    }
                    if (monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    final Collection<CoverageInformationItem> fLegend = this.collapseLegend(legend);
                    UIHelper.runUISync((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TextViewer viewer = (this).TLACoveragePainter.this.editor.getViewer();
                            if (viewer == null || viewer.getTextWidget() == null || viewer.getTextWidget().isDisposed()) {
                                return;
                            }
                            viewer.getTextWidget().removeListener(3, (this).TLACoveragePainter.this.listener);
                            viewer.changeTextPresentation((this).TLACoveragePainter.this.textPresentation, true);
                            this.updateLegend(fLegend, grouping);
                            viewer.getTextWidget().addListener(3, (this).TLACoveragePainter.this.listener);
                        }
                    });
                    monitor.done();
                }
            }

            private Collection<CoverageInformationItem> collapseLegend(TreeSet<CoverageInformationItem> legend) {
                double numLabel = (double)((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.resizeListener.getWidth() / 47.0;
                if (legend.size() <= (int)Math.ceil(numLabel)) {
                    return legend;
                }
                int nth = (int)Math.ceil((double)legend.size() / numLabel);
                ArrayList<CoverageInformationItem> result = new ArrayList<CoverageInformationItem>((int)Math.ceil(numLabel));
                result.add(legend.first());
                int i = 1;
                for (CoverageInformationItem cii : legend) {
                    if (i++ % nth != 0) continue;
                    result.add(cii);
                }
                result.add(legend.last());
                return result;
            }

            private Pair getPair() {
                try {
                    return TLACoveragePainter.this.queue.take();
                }
                catch (InterruptedException notExpectedException) {
                    notExpectedException.printStackTrace();
                    return TERMINATE;
                }
            }

            private void updateLegend(Collection<CoverageInformationItem> legend, Representation.Grouping grouping) {
                Composite parent = ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.heatMapComposite.getParent();
                if (legend.isEmpty()) {
                    ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.heatMapComposite.setVisible(false);
                } else {
                    Representation currentRepresentation = TLACoveragePainter.this.getActiveRepresentation();
                    ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.heatMapComposite.dispose();
                    Representation.Grouping grpng = grouping;
                    if (currentRepresentation == Representation.STATES || currentRepresentation == Representation.STATES_DISTINCT) {
                        grpng = Representation.Grouping.INDIVIDUAL;
                    }
                    ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.heatMapComposite = new Composite(parent, 2048);
                    GridData layoutData = new GridData(4, 128, true, false);
                    ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.heatMapComposite.setLayoutData((Object)layoutData);
                    ((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.heatMapComposite.setLayout((Layout)new FillLayout(256));
                    for (final CoverageInformationItem cii : legend) {
                        Label label = new Label(((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.heatMapComposite, 2048);
                        label.setAlignment(0x1000000);
                        label.setBackground(currentRepresentation.getColor(cii, grpng));
                        long value = currentRepresentation.getValue(cii, grpng);
                        if (value > 1000L) {
                            label.setText(df.format(value));
                        } else {
                            label.setText(String.format("%,d", value));
                        }
                        label.setToolTipText(String.format(currentRepresentation.getToolTipText(), value, cii.getLocation()));
                        label.addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseDown(MouseEvent e) {
                                IRegion region = cii.getRegion();
                                (this).TLACoveragePainter.this.editor.selectAndReveal(region.getOffset(), cii.getRegion().getLength());
                            }
                        });
                    }
                    TLACoveragePainter.this.viewer = new ComboViewer(((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.heatMapComposite, 2124);
                    TLACoveragePainter.this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                    TLACoveragePainter.this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof Representation) {
                                Representation current = (Representation)((Object)element);
                                return current.toString();
                            }
                            return super.getText(element);
                        }
                    });
                    TLACoveragePainter.this.viewer.setInput(((TLACoveragePainter)TLACoveragePainter.this).TLACoverageEditor.this.coverage.hasStates() ? Representation.values() : Representation.valuesNoStates());
                    TLACoveragePainter.this.viewer.setSelection((ISelection)new StructuredSelection((Object)currentRepresentation));
                    TLACoveragePainter.this.viewer.addSelectionChangedListener(event -> {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        Representation rep = (Representation)((Object)((Object)selection.getFirstElement()));
                        int offset = JFaceTextUtil.getOffsetForCursorLocation((ITextViewer)TLACoveragePainter.this.editor.getViewer());
                        TLACoveragePainter.this.queue.offer(new Pair(offset, rep));
                    });
                }
                parent.layout();
            }
        };
        private final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                boolean isControlClick;
                Representation activeRepresentation = TLACoveragePainter.this.getActiveRepresentation();
                int offset = JFaceTextUtil.getOffsetForCursorLocation((ITextViewer)TLACoveragePainter.this.editor.getViewer());
                Pair peek = (Pair)TLACoveragePainter.this.queue.peek();
                boolean bl = isControlClick = (event.stateMask & SWT.MOD1) != 0;
                if (isControlClick) {
                    TLACoveragePainter.this.editor.getViewer().getTextWidget().notifyListeners(4, null);
                    event.doit = false;
                    String moduleName = TLACoverageEditor.this.getModuleName() + ".tla";
                    TLAEditor editor = EditorUtil.openTLAEditor((String)moduleName);
                    if (editor != null) {
                        editor.selectAndReveal(offset, 0);
                    } else {
                        TLCUIActivator.getDefault().logError("Unable to open editor for name: " + moduleName);
                    }
                } else if (peek == null || peek.offset != offset || peek.rep != activeRepresentation) {
                    TLACoveragePainter.this.queue.offer(new Pair(offset, activeRepresentation));
                }
            }
        };
        private TextPresentation textPresentation;

        private Representation getActiveRepresentation() {
            if (this.viewer != null) {
                IStructuredSelection structuredSelection = this.viewer.getStructuredSelection();
                return (Representation)((Object)structuredSelection.getFirstElement());
            }
            return Representation.INV;
        }

        public TLACoveragePainter(TLACoverageEditor editor) {
            this.editor = editor;
            this.painter.setPriority(30);
            this.painter.setRule(null);
            this.painter.setSystem(true);
        }

        public synchronized void applyTextPresentation(TextPresentation textPresentation) {
            this.editor.getSourceViewer().getTextWidget().setBackground(lightGray);
            this.editor.getViewer().removeTextPresentationListener((ITextPresentationListener)this);
            this.textPresentation = textPresentation;
            this.editor.getViewer().addTextInputListener(new ITextInputListener(){

                public synchronized void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                    TLACoveragePainter.this.editor.getViewer().removeTextInputListener((ITextInputListener)this);
                    StyledText textWidget = TLACoveragePainter.this.editor.getViewer().getTextWidget();
                    textWidget.addListener(3, TLACoveragePainter.this.listener);
                    TLACoveragePainter.this.queue.add(ALL);
                    TLACoveragePainter.this.painter.schedule();
                }

                public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                }
            });
        }
    }

    private class TLACoverageSourceViewerConfiguration
    extends TLASourceViewerConfiguration {
        public TLACoverageSourceViewerConfiguration(IPreferenceStore preferenceStore, TLAEditor tlaCoverageEditor) {
            super(preferenceStore, tlaCoverageEditor);
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
            return new DefaultTextHover(sourceViewer){

                public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
                    return ((TLACoverageSourceViewerConfiguration)TLACoverageSourceViewerConfiguration.this).TLACoverageEditor.this.coverage.getHoverInfo(hoverRegion.getOffset());
                }
            };
        }
    }
}

