/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page.advanced;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.DataBindingManager;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.BasicFormPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableOverridesSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.util.DirtyMarkingListener;
import org.lamport.tla.toolbox.tool.tlc.ui.util.FormHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.util.SemanticHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.OpDefNode;
import tlc2.model.Assignment;
import tlc2.model.TypedSet;

public class AdvancedModelPage
extends BasicFormPage
implements Closeable {
    public static final String ID = "advancedModelPage";
    private SourceViewer constraintSource;
    private SourceViewer actionConstraintSource;
    private SourceViewer newDefinitionsSource;
    private SourceViewer modelValuesSource;
    private TableViewer definitionsTable;

    public AdvancedModelPage(FormEditor editor) {
        super(editor, ID, "Spec Options", "icons/full/advanced_model_options_[XXXXX].png");
        this.helpId = ID;
    }

    @Override
    protected void loadData() throws CoreException {
        List definitions = this.getModel().getAttribute("modelParameterDefinitions", new Vector());
        FormHelper.setSerializedInput(this.definitionsTable, definitions);
        String newDefinitions = this.getModel().getAttribute("modelParameterNewDefinitions", "");
        this.newDefinitionsSource.setDocument((IDocument)new Document(newDefinitions));
        String modelValues = this.getModel().getAttribute("modelParameterModelValues", "");
        this.modelValuesSource.setDocument((IDocument)new Document(modelValues));
        String constraint = this.getModel().getAttribute("modelParameterContraint", "");
        this.constraintSource.setDocument((IDocument)new Document(constraint));
        String actionConstraint = this.getModel().getAttribute("modelParameterActionConstraint", "");
        this.actionConstraintSource.setDocument((IDocument)new Document(actionConstraint));
    }

    @Override
    public void commit(boolean onSave) {
        List<String> definitions = FormHelper.getSerializedInput(this.definitionsTable);
        this.getModel().setAttribute("modelParameterDefinitions", definitions);
        String newDefinitions = FormHelper.trimTrailingSpaces(this.newDefinitionsSource.getDocument().get());
        this.getModel().setAttribute("modelParameterNewDefinitions", newDefinitions);
        String modelValues = FormHelper.trimTrailingSpaces(this.modelValuesSource.getDocument().get());
        TypedSet modelValuesSet = TypedSet.parseSet((String)modelValues);
        this.getModel().setAttribute("modelParameterModelValues", modelValuesSet.toString());
        String constraintFormula = FormHelper.trimTrailingSpaces(this.constraintSource.getDocument().get());
        this.getModel().setAttribute("modelParameterContraint", constraintFormula);
        String actionConstraintFormula = FormHelper.trimTrailingSpaces(this.actionConstraintSource.getDocument().get());
        this.getModel().setAttribute("modelParameterActionConstraint", actionConstraintFormula);
        super.commit(onSave);
    }

    @Override
    public void validatePage(boolean switchToErrorPage) {
        int j;
        TypedSet modelValuesSet;
        if (this.getManagedForm() == null) {
            return;
        }
        IMessageManager mm = this.getManagedForm().getMessageManager();
        mm.setAutoUpdate(false);
        ModelEditor modelEditor = (ModelEditor)this.getEditor();
        this.setComplete(true);
        this.getLookupHelper().resetModelNames(this);
        DataBindingManager dm = this.getDataBindingManager();
        IDocument document = this.modelValuesSource.getDocument();
        if (document != null && (modelValuesSet = TypedSet.parseSet((String)FormHelper.trimTrailingSpaces(document.get()))).getValueCount() > 0) {
            List values = modelValuesSet.getValuesAsList();
            this.validateUsage("modelParameterModelValues", values, "modelValues2_", "A model value", "Advanced Model Values", true);
            this.validateId("modelParameterModelValues", values, "modelValues2_", "A model value");
            Control widget = UIHelper.getWidget((Object)dm.getAttributeControl("modelParameterModelValues"));
            j = 0;
            while (j < values.size()) {
                String value = (String)values.get(j);
                if (SemanticHelper.isConfigFileKeyword(value)) {
                    modelEditor.addErrorMessage(value, "The toolbox cannot handle the model value " + value + ".", this.getId(), 3, widget);
                    this.setComplete(false);
                }
                ++j;
            }
        }
        SpecObj specObj = ToolboxHandle.getCurrentSpec().getValidRootModule();
        OpDefNode[] opDefNodes = null;
        if (specObj != null) {
            opDefNodes = specObj.getExternalModuleTable().getRootModule().getOpDefs();
        }
        Hashtable<String, OpDefNode> nodeTable = new Hashtable<String, OpDefNode>();
        if (opDefNodes != null) {
            j = 0;
            while (j < opDefNodes.length) {
                String key = opDefNodes[j].getName().toString();
                nodeTable.put(key, opDefNodes[j]);
                ++j;
            }
        }
        Control widget = UIHelper.getWidget((Object)dm.getAttributeControl("modelParameterDefinitions"));
        mm.removeMessages(widget);
        List definitions = (List)this.definitionsTable.getInput();
        if (definitions != null) {
            Assignment definition;
            int i = 0;
            while (i < definitions.size()) {
                definition = (Assignment)definitions.get(i);
                List<String> values = Arrays.asList(definition.getParams());
                this.validateUsage("modelParameterDefinitions", values, "param1_", "A parameter name", "Definition Overrides", false);
                this.validateId("modelParameterDefinitions", values, "param1_", "A parameter name");
                if (opDefNodes != null) {
                    if (!nodeTable.containsKey(definition.getLabel())) {
                        modelEditor.addErrorMessage(definition.getLabel(), "The defined symbol " + definition.getLabel().substring(definition.getLabel().lastIndexOf("!") + 1) + " has been removed from the specification. It must be removed from the list of definition overrides.", this.getId(), 3, widget);
                        this.setComplete(false);
                    } else {
                        OpDefNode opDefNode = (OpDefNode)nodeTable.get(definition.getLabel());
                        if (opDefNode.getSource().getNumberOfArgs() != definition.getParams().length) {
                            modelEditor.addErrorMessage(definition.getLabel(), "Edit the definition override for " + String.valueOf(opDefNode.getSource().getName()) + " to match the correct number of arguments.", this.getId(), 3, widget);
                            this.setComplete(false);
                        }
                    }
                }
                ++i;
            }
            int j2 = 0;
            while (j2 < definitions.size()) {
                definition = (Assignment)definitions.get(j2);
                String label = definition.getLabel();
                if (SemanticHelper.isConfigFileKeyword(label)) {
                    modelEditor.addErrorMessage(label, "The toolbox cannot override the definition of " + label + " because it is a configuration file keyword.", this.getId(), 3, widget);
                    this.setComplete(false);
                }
                ++j2;
            }
        }
        mm.setAutoUpdate(true);
        super.validatePage(switchToErrorPage);
    }

    @Override
    protected void createBodyContent(IManagedForm managedForm) {
        DataBindingManager dm = this.getDataBindingManager();
        int sectionFlags = 452;
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        TableWrapLayout twl = new TableWrapLayout();
        twl.leftMargin = 0;
        twl.rightMargin = 0;
        twl.numColumns = 2;
        body.setLayout((Layout)twl);
        Composite left = toolkit.createComposite(body);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        left.setLayout((Layout)gl);
        TableWrapData twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        left.setLayoutData((Object)twd);
        Composite right = toolkit.createComposite(body);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        right.setLayout((Layout)gl);
        twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        right.setLayoutData((Object)twd);
        Section section = FormHelper.createSectionComposite(left, "Additional Definitions", "Definitions required for the model checking, in addition to the definitions in the specification modules.", toolkit, 452, this.getExpansionListener());
        ValidateableSectionPart newDefinitionsPart = new ValidateableSectionPart(section, this, "__additional_definition");
        managedForm.addPart((IFormPart)newDefinitionsPart);
        DirtyMarkingListener newDefinitionsListener = new DirtyMarkingListener((AbstractFormPart)newDefinitionsPart, true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gd);
        Composite newDefinitionsArea = (Composite)section.getClient();
        this.newDefinitionsSource = FormHelper.createFormsSourceViewer(toolkit, newDefinitionsArea, 512);
        twd = new TableWrapData(128);
        twd.heightHint = 60;
        twd.grabHorizontal = true;
        this.newDefinitionsSource.getTextWidget().setLayoutData((Object)twd);
        this.newDefinitionsSource.addTextListener((ITextListener)newDefinitionsListener);
        this.newDefinitionsSource.getTextWidget().addFocusListener(this.focusListener);
        dm.bindAttribute("modelParameterNewDefinitions", this.newDefinitionsSource, newDefinitionsPart);
        int expand = 0;
        try {
            List definitions = this.getModel().getAttribute("modelParameterDefinitions", new Vector());
            if (definitions != null && definitions.size() != 0) {
                expand = 64;
            }
        }
        catch (CoreException definitions) {
            // empty catch block
        }
        ValidateableOverridesSectionPart definitionsPart = new ValidateableOverridesSectionPart(right, "Definition Override", "Directs TLC to use alternate definitions for operators.", toolkit, 0x1C4 | expand, this);
        managedForm.addPart((IFormPart)definitionsPart);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        definitionsPart.getSection().setLayoutData((Object)gd);
        this.definitionsTable = definitionsPart.getTableViewer();
        dm.bindAttribute("modelParameterDefinitions", this.definitionsTable, definitionsPart);
        section = FormHelper.createSectionComposite(left, "Model Values", "An additional set of model values.", toolkit, 452, this.getExpansionListener());
        ValidateableSectionPart modelValuesPart = new ValidateableSectionPart(section, this, "__model_values");
        managedForm.addPart((IFormPart)modelValuesPart);
        DirtyMarkingListener modelValuesListener = new DirtyMarkingListener((AbstractFormPart)modelValuesPart, true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gd);
        Composite modelValueArea = (Composite)section.getClient();
        this.modelValuesSource = FormHelper.createFormsSourceViewer(toolkit, modelValueArea, 512);
        twd = new TableWrapData(128);
        twd.heightHint = 60;
        twd.grabHorizontal = true;
        this.modelValuesSource.getTextWidget().setLayoutData((Object)twd);
        this.modelValuesSource.addTextListener((ITextListener)modelValuesListener);
        this.modelValuesSource.getTextWidget().addFocusListener(this.focusListener);
        dm.bindAttribute("modelParameterModelValues", this.modelValuesSource, modelValuesPart);
        section = FormHelper.createSectionComposite(right, "Action Constraint", "A formula restricting a transition if its evaluation is not satisfied.", toolkit, 452, this.getExpansionListener());
        ValidateableSectionPart actionConstraintPart = new ValidateableSectionPart(section, this, "__action_constraints");
        managedForm.addPart((IFormPart)actionConstraintPart);
        DirtyMarkingListener actionConstraintListener = new DirtyMarkingListener((AbstractFormPart)actionConstraintPart, true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gd);
        Composite actionConstraintArea = (Composite)section.getClient();
        this.actionConstraintSource = FormHelper.createFormsSourceViewer(toolkit, actionConstraintArea, 512);
        twd = new TableWrapData(128);
        twd.heightHint = 60;
        twd.grabHorizontal = true;
        this.actionConstraintSource.getTextWidget().setLayoutData((Object)twd);
        this.actionConstraintSource.addTextListener((ITextListener)actionConstraintListener);
        this.actionConstraintSource.getTextWidget().addFocusListener(this.focusListener);
        dm.bindAttribute("modelParameterActionConstraint", this.actionConstraintSource, actionConstraintPart);
        section = FormHelper.createSectionComposite(body, "State Constraint", "A formula restricting the possible states by a state predicate.", toolkit, 452, this.getExpansionListener());
        ValidateableSectionPart constraintPart = new ValidateableSectionPart(section, this, "__state_constraints");
        managedForm.addPart((IFormPart)constraintPart);
        DirtyMarkingListener constraintListener = new DirtyMarkingListener((AbstractFormPart)constraintPart, true);
        twd = new TableWrapData();
        twd.colspan = 2;
        twd.grabHorizontal = true;
        twd.align = 128;
        section.setLayoutData((Object)twd);
        Composite constraintArea = (Composite)section.getClient();
        this.constraintSource = FormHelper.createFormsSourceViewer(toolkit, constraintArea, 512);
        twd = new TableWrapData(128);
        twd.heightHint = 60;
        twd.grabHorizontal = true;
        this.constraintSource.getTextWidget().setLayoutData((Object)twd);
        this.constraintSource.addTextListener((ITextListener)constraintListener);
        this.constraintSource.getTextWidget().addFocusListener(this.focusListener);
        dm.bindAttribute("modelParameterContraint", this.constraintSource, constraintPart);
        this.dirtyPartListeners.add((Object)newDefinitionsListener);
        this.dirtyPartListeners.add((Object)actionConstraintListener);
        this.dirtyPartListeners.add((Object)modelValuesListener);
        this.dirtyPartListeners.add((Object)constraintListener);
    }

    @Override
    public void close() throws IOException {
        int openTabState = this.getModel().getOpenTabsValue();
        this.getModelEditor().updateOpenTabsState(openTabState & 0xFFFFFFFD);
        DataBindingManager dm = this.getDataBindingManager();
        dm.unbindSectionAndAttribute("modelParameterActionConstraint");
        dm.unbindSectionAndAttribute("modelParameterContraint");
        dm.unbindSectionAndAttribute("modelParameterDefinitions");
        dm.unbindSectionAndAttribute("modelParameterModelValues");
        dm.unbindSectionAndAttribute("modelParameterNewDefinitions");
    }
}

