/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results;

import java.util.Comparator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.tool.tlc.output.data.ActionInformationItem;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.util.AbstractTableLabelProvider;
import tlc2.output.MP;

class CoverageLabelProvider
extends AbstractTableLabelProvider {
    static final String COVERAGE_COMPARATOR = "COVERAGE_COMPARATOR";
    static final int COL_MODULE = 0;
    static final int COL_ACTION = 1;
    static final int COL_LOCATION = 2;
    static final int COL_STATES = 3;
    static final int COL_DISTSTATES = 4;
    static final String TOOLTIP = "Click on a row to go to action.";
    private static final boolean RUNNING_WINDOWS = Platform.getOS().equals("win32");
    private static final String[] COLUMN_TITLES = new String[]{"Module", "Action", "Location", "States Found", "Distinct States"};
    private static final String[] COLUMN_TOOLTIPS = new String[]{"Click on a row to go to action.", "Click on a row to go to action.", "Click on a row to go to action.", "\u03a3 of this column equals (total) States Found on the State Space progress table to the left.", "\u03a3 of this column equals (total) Distinct States on the State Space progress table to the left."};
    private static final int[] COLUMN_WIDTHS;
    private static final Comparator<ActionInformationItem>[] COLUMN_COMP;
    private static final double[] COLUMN_WIDTH_PERCENTAGES;
    private static final int MIN_WIDTH;

    static {
        double scale = 1.0;
        int i = 0;
        COLUMN_WIDTHS = new int[COLUMN_TITLES.length];
        CoverageLabelProvider.COLUMN_WIDTHS[i++] = 30;
        CoverageLabelProvider.COLUMN_WIDTHS[i++] = 30;
        CoverageLabelProvider.COLUMN_WIDTHS[i++] = 50;
        CoverageLabelProvider.COLUMN_WIDTHS[i++] = 30;
        CoverageLabelProvider.COLUMN_WIDTHS[i++] = 30;
        int sum = 0;
        i = 0;
        while (i < COLUMN_WIDTHS.length) {
            sum += COLUMN_WIDTHS[i];
            ++i;
        }
        MIN_WIDTH = sum;
        COLUMN_WIDTH_PERCENTAGES = new double[COLUMN_WIDTHS.length];
        i = 0;
        while (i < COLUMN_WIDTHS.length) {
            CoverageLabelProvider.COLUMN_WIDTH_PERCENTAGES[i] = (double)COLUMN_WIDTHS[i] / (double)MIN_WIDTH;
            ++i;
        }
        i = 0;
        COLUMN_COMP = new Comparator[COLUMN_TITLES.length];
        CoverageLabelProvider.COLUMN_COMP[i++] = new Comparator<ActionInformationItem>(){

            @Override
            public int compare(ActionInformationItem o1, ActionInformationItem o2) {
                return o1.getModule().compareTo(o2.getModule());
            }
        };
        CoverageLabelProvider.COLUMN_COMP[i++] = new Comparator<ActionInformationItem>(){

            @Override
            public int compare(ActionInformationItem o1, ActionInformationItem o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        CoverageLabelProvider.COLUMN_COMP[i++] = new Comparator<ActionInformationItem>(){

            @Override
            public int compare(ActionInformationItem o1, ActionInformationItem o2) {
                return o1.getModuleLocation().compareTo(o2.getModuleLocation());
            }
        };
        CoverageLabelProvider.COLUMN_COMP[i++] = new Comparator<ActionInformationItem>(){

            @Override
            public int compare(ActionInformationItem o1, ActionInformationItem o2) {
                return Long.compare(o1.getCount(), o2.getCount());
            }
        };
        CoverageLabelProvider.COLUMN_COMP[i++] = new Comparator<ActionInformationItem>(){

            @Override
            public int compare(ActionInformationItem o1, ActionInformationItem o2) {
                return Long.compare(o1.getUnseen(), o2.getUnseen());
            }
        };
    }

    CoverageLabelProvider() {
        super(MIN_WIDTH, COLUMN_TITLES, COLUMN_WIDTH_PERCENTAGES);
    }

    void createTableColumns(Table stateTable, TableColumnLayout layout) {
        int i = 0;
        while (i < COLUMN_TITLES.length) {
            TableColumn column = new TableColumn(stateTable, 0);
            column.setWidth(COLUMN_WIDTHS[i]);
            column.setText(COLUMN_TITLES[i]);
            column.setToolTipText(COLUMN_TOOLTIPS[i]);
            column.setData(COVERAGE_COMPARATOR, COLUMN_COMP[i]);
            int weight = (int)(100.0 * COLUMN_WIDTH_PERCENTAGES[i]);
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight, COLUMN_WIDTHS[i], true));
            ++i;
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ActionInformationItem) {
            ActionInformationItem item = (ActionInformationItem)element;
            switch (columnIndex) {
                case 0: {
                    return item.getModule();
                }
                case 1: {
                    return item.getName();
                }
                case 2: {
                    if (item.hasDefinition()) {
                        return item.getDefinition().linesAndColumns();
                    }
                    return item.getLocation();
                }
                case 3: {
                    return MP.format((long)item.getCount());
                }
                case 4: {
                    return MP.format((long)item.getUnseen());
                }
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        ActionInformationItem aii;
        if (TLAEditorActivator.getDefault().isCurrentThemeDark() && element instanceof ActionInformationItem && !RUNNING_WINDOWS && (aii = (ActionInformationItem)element).getCount() == 0L && aii.getUnseen() == 0L) {
            return Display.getCurrent().getSystemColor(2);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        ActionInformationItem aii;
        if (element instanceof ActionInformationItem && (aii = (ActionInformationItem)element).getCount() == 0L && aii.getUnseen() == 0L) {
            return TLCUIActivator.getColor(7);
        }
        return null;
    }
}

