/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.util;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.output.data.ActionInformationItem;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCError;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCState;
import org.lamport.tla.toolbox.tool.tlc.ui.util.IModuleLocatable;
import org.lamport.tla.toolbox.tool.tlc.ui.util.TLCUIHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.st.Location;

public class RecordToSourceCoupler
implements MouseListener,
KeyListener {
    public static final int OBSERVE_DEFAULT = 0;
    public static final int OBSERVE_ARROW_KEY = 2;
    public static final int OBSERVE_SINGLE_CLICK = 4;
    private final Viewer viewer;
    private final Set<Class<? extends ITextEditor>> blacklist;
    private final IWorkbenchPart partToRefocus;
    private final AtomicBoolean observeArrowKeyEvents;
    private final AtomicBoolean observeSingleClickEvents;
    private final FocusRetentionPolicy focusRetentionPolicy;

    public RecordToSourceCoupler(Viewer viewer) {
        this(viewer, new HashSet<Class<? extends ITextEditor>>());
    }

    public RecordToSourceCoupler(Viewer variableViewer, Set<Class<? extends ITextEditor>> editorBlacklist) {
        this(variableViewer, editorBlacklist, null, null);
    }

    public RecordToSourceCoupler(Viewer variableViewer, Set<Class<? extends ITextEditor>> editorBlacklist, IWorkbenchPart workbenchPart, FocusRetentionPolicy focusPolicy) {
        this.viewer = variableViewer;
        this.blacklist = editorBlacklist;
        this.partToRefocus = workbenchPart;
        this.observeArrowKeyEvents = new AtomicBoolean(false);
        this.observeSingleClickEvents = new AtomicBoolean(false);
        this.focusRetentionPolicy = focusPolicy;
    }

    public void setNonDefaultObservables(int observablesMask) {
        this.observeArrowKeyEvents.set((observablesMask & 2) == 2);
        this.observeSingleClickEvents.set((observablesMask & 4) == 4);
    }

    public void mouseDoubleClick(MouseEvent event) {
        this.performSourceCoupling(this.viewer.getSelection(), (event.stateMask & SWT.MOD1) != 0, false);
    }

    public void mouseDown(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
        if (this.observeSingleClickEvents.get()) {
            this.performSourceCoupling(this.viewer.getSelection(), (event.stateMask & SWT.MOD1) != 0, false);
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        int code = event.keyCode;
        if (code == 13) {
            this.performSourceCoupling(this.viewer.getSelection(), (event.stateMask & SWT.MOD1) != 0, false);
        } else if (code == 16777263 && (event.stateMask & 0x10000) != 0 && this.viewer instanceof TreeViewer) {
            ((TreeViewer)this.viewer).collapseAll();
        } else if (this.observeArrowKeyEvents.get() && (code == 0x1000001 || code == 0x1000002) && this.viewer instanceof TreeViewer) {
            this.performSourceCoupling(this.viewer.getSelection(), false, true);
        }
    }

    private void performSourceCoupling(ISelection selection, boolean jumpToPCal, boolean dueToArrowKeys) {
        if (selection != null && !selection.isEmpty() && selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof LoaderTLCState) {
                final LoaderTLCState loader = (LoaderTLCState)firstElement;
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        loader.loadMore();
                    }
                });
            } else if (firstElement instanceof IModuleLocatable) {
                Model model;
                ActionInformationItem aii;
                IModuleLocatable moduleLocatable = (IModuleLocatable)firstElement;
                Location location = moduleLocatable.getModuleLocation();
                if (moduleLocatable instanceof ActionInformationItem && (aii = (ActionInformationItem)moduleLocatable).hasDefinition()) {
                    location = aii.getDefinition();
                }
                if (location != null && !TLCUIHelper.jumpToSavedLocation(location, model = ((TLCSpec)ToolboxHandle.getCurrentSpec().getAdapter(TLCSpec.class)).getModel(moduleLocatable.getModelName()), this.blacklist)) {
                    Object iwp = dueToArrowKeys || FocusRetentionPolicy.ALWAYS.equals((Object)this.focusRetentionPolicy) ? this.partToRefocus : null;
                    UIHelper.jumpToLocation((Location)location, (boolean)jumpToPCal, (IWorkbenchPart)iwp);
                    if (iwp != null) {
                        this.viewer.getControl().getDisplay().asyncExec(() -> this.viewer.getControl().forceFocus());
                    }
                }
            } else if (!Platform.getWS().equals("win32") && this.viewer instanceof TreeViewer) {
                TreeViewer treeViewer = (TreeViewer)this.viewer;
                if (treeViewer.getExpandedState(firstElement)) {
                    treeViewer.collapseToLevel(firstElement, 1);
                } else {
                    treeViewer.expandToLevel(firstElement, 1);
                }
            }
        }
    }

    public static enum FocusRetentionPolicy {
        ALWAYS,
        ARROW_KEY_TRAVERSAL;

    }

    public static class LoaderTLCState
    extends TLCState {
        private final TLCError error;
        private final int numberOfStatesToShow;
        private final TreeViewer viewer;

        public LoaderTLCState(TreeViewer viewer, int numberOfStatesToShow, TLCError error) {
            super(-1, "Load more...");
            this.viewer = viewer;
            this.numberOfStatesToShow = numberOfStatesToShow;
            this.error = error;
            this.setLabel(String.format("Load %s additional states...", numberOfStatesToShow));
        }

        public void loadMore() {
            this.error.reduceTraceRestrictionBy(this.numberOfStatesToShow);
            this.viewer.getTree().setItemCount(this.error.getTraceSize() + (this.error.isTraceRestricted() ? 1 : 0));
            this.viewer.setSelection(new ISelection(){

                public boolean isEmpty() {
                    return true;
                }
            });
            this.viewer.setInput((Object)this.error);
        }
    }
}

