/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.wizard;

import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LabeledListComposite {
    Text[] fields;
    String[] values;
    Composite self;

    public LabeledListComposite(Composite parent, String label, String[] values) {
        this.values = values;
        this.fields = new Text[values.length];
        this.initContent(parent, label);
    }

    public boolean hasParameters() {
        return this.values.length > 0;
    }

    private void initContent(Composite parent, String label) {
        this.self = new Composite(parent, 0);
        this.self.setLayout((Layout)new RowLayout(256));
        Label l = new Label(this.self, 0);
        l.setText(label);
        if (this.hasParameters()) {
            l = new Label(this.self, 0);
            l.setText("(");
        }
        int i = 0;
        while (i < this.fields.length) {
            this.fields[i] = new Text(this.self, 2052);
            this.fields[i].setText(this.values[i]);
            RowData rd = new RowData();
            rd.width = 50;
            rd.height = 12;
            this.fields[i].setLayoutData((Object)rd);
            if (i != this.fields.length - 1) {
                l = new Label(this.self, 0);
                l.setText(", ");
            }
            ++i;
        }
        if (this.hasParameters()) {
            l = new Label(this.self, 0);
            l.setText(")");
        }
        l = new Label(this.self, 0);
        l.setText(" <- ");
    }

    public String[] getValues() {
        String[] result = new String[this.fields.length];
        int i = 0;
        while (i < this.fields.length) {
            result[i] = this.fields[i].getText();
            ++i;
        }
        return result;
    }

    public void setLayoutData(Object layoutData) {
        this.self.setLayoutData(layoutData);
    }
}

