/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.job.TLCJob;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.internal.BroadcastStreamListener;
import org.lamport.tla.toolbox.util.ResourceHelper;
import tlc2.TLC;
import tlc2.output.EC;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.fp.NoopFPSet;
import tlc2.tool.fp.OffHeapDiskFPSet;
import util.TLCRuntime;

public class TLCProcessJob
extends TLCJob {
    public static final int HEAP_SIZE_DEFAULT = 25;
    protected IProcess process = null;
    private BroadcastStreamListener listener = null;
    private long tlcStartTime;
    private long tlcEndTime;

    public TLCProcessJob(String specName, String modelName, ILaunch launch, int workers) {
        super(specName, modelName, launch, workers);
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Running TLC model checker", -1);
            monitor.worked(30);
            monitor.subTask("Preparing the TLC Launch");
            String runtimeClasspath = ToolboxHandle.getTLAToolsClasspath().toOSString();
            String libClasspath = runtimeClasspath + File.separator + "lib" + File.separator + "*";
            String libMailClasspath = runtimeClasspath + File.separator + "lib" + File.separator + "javax.mail" + File.separator + "*";
            String libJsonClasspath = runtimeClasspath + File.separator + "lib" + File.separator + "gson" + File.separator + "*";
            String devClasspath = runtimeClasspath + File.separator + "class";
            Spec spec = Activator.getSpecManager().getSpecByName(this.specName);
            String libraryPathClassPath = spec.getTLALibraryPathAsClassPath();
            String[] classPath = new String[]{runtimeClasspath, libClasspath, libMailClasspath, devClasspath, libJsonClasspath, libraryPathClassPath};
            CharSequence[] arguments = this.constructProgramArguments();
            ArrayList<Object> vmArgs = new ArrayList<Object>();
            int maxHeapSize = this.launch.getLaunchConfiguration().getAttribute("maxHeapSize", 25);
            if (maxHeapSize < 1 || maxHeapSize > 99) {
                TLCActivator.logInfo(String.format("Defaulting fraction of physical memory to %s because %s is out of range (0,100). Value can be adjusted on the model editor's \"Advanced TLC option\" tab.", 25, maxHeapSize));
                maxHeapSize = 25;
            }
            TLCRuntime instance = TLCRuntime.getInstance();
            long absolutePhysicalSystemMemory = instance.getAbsolutePhysicalSystemMemory((double)maxHeapSize / 100.0);
            String clazz = this.getOptimalFPsetImpl();
            if (!this.hasSpec(this.launch.getLaunchConfiguration())) {
                clazz = NoopFPSet.class.getName();
            }
            if (clazz == null || clazz.equals(OffHeapDiskFPSet.class.getName())) {
                if (OffHeapDiskFPSet.isSupported()) {
                    long offheapMemory = (long)((double)absolutePhysicalSystemMemory * 0.6666);
                    vmArgs.add(FPSetFactory.getVMArguments((String)OffHeapDiskFPSet.class.getName(), (long)offheapMemory));
                    vmArgs.add(FPSetFactory.getVMArguments((String)FPSetFactory.getImplementationDefault(), (long)(absolutePhysicalSystemMemory - offheapMemory)));
                    vmArgs.add("-D" + FPSetFactory.IMPL_PROPERTY + "=" + OffHeapDiskFPSet.class.getName());
                } else {
                    vmArgs.add(FPSetFactory.getVMArguments((String)FPSetFactory.getImplementationDefault(), (long)absolutePhysicalSystemMemory));
                    vmArgs.add("-D" + FPSetFactory.IMPL_PROPERTY + "=" + FPSetFactory.getImplementationDefault());
                }
            } else {
                vmArgs.add(FPSetFactory.getVMArguments((String)clazz, (long)absolutePhysicalSystemMemory));
                vmArgs.add("-D" + FPSetFactory.IMPL_PROPERTY + "=" + clazz);
            }
            vmArgs.add("-XX:+UseParallelGC");
            vmArgs.addAll(this.getAdditionalVMArgs());
            VMRunnerConfiguration tlcConfig = new VMRunnerConfiguration(this.getMainClass().getName(), classPath);
            tlcConfig.setProgramArguments((String[])arguments);
            tlcConfig.setVMArguments(vmArgs.toArray(new String[vmArgs.size()]));
            tlcConfig.setWorkingDirectory(ResourceHelper.getParentDirName((IResource)this.rootModule));
            IVMInstall vmInstall = this.getVMInstall();
            IVMRunner runner = vmInstall.getVMRunner("run");
            this.launch.setAttribute("org.eclipse.debug.core.capture_output", "true");
            monitor.worked(30);
            monitor.subTask("Launching TLC");
            try {
                runner.run(tlcConfig, this.launch, (IProgressMonitor)new NullProgressMonitor());
                this.tlcStartTime = System.currentTimeMillis();
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.lamport.tla.toolbox.tool.tlc", String.format("Error launching TLC with command-line (CWD: %s): %s%sbin%sjava -cp %s %s %s %s", tlcConfig.getWorkingDirectory(), vmInstall.getInstallLocation(), File.separator, File.separator, String.join((CharSequence)File.pathSeparator, tlcConfig.getClassPath()), String.join((CharSequence)" ", tlcConfig.getVMArguments()), String.join((CharSequence)" ", tlcConfig.getClassToLaunch()), String.join((CharSequence)" ", arguments)), (Throwable)e);
                if (this.listener != null) {
                    this.listener.streamClosed();
                    if (this.process != null && this.process.getStreamsProxy() != null) {
                        if (this.process.getStreamsProxy().getOutputStreamMonitor() != null) {
                            this.process.getStreamsProxy().getOutputStreamMonitor().removeListener((IStreamListener)this.listener);
                        }
                        if (this.process.getStreamsProxy().getErrorStreamMonitor() != null) {
                            this.process.getStreamsProxy().getErrorStreamMonitor().removeListener((IStreamListener)this.listener);
                        }
                    }
                }
                monitor.done();
                return status;
            }
            this.process = TLCProcessJob.findProcessForLaunch(this.launch);
            monitor.worked(30);
            monitor.subTask("Connecting to running instance");
            if (this.process != null) {
                String cmd = this.process.getAttribute(IProcess.ATTR_CMDLINE);
                String cwd = this.process.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY");
                TLCActivator.logInfo(String.format("TLC COMMAND-LINE (CWD: %s): %s", cwd, cmd));
                monitor.worked(30);
                monitor.subTask("Model checking...");
                Model model = (Model)this.launch.getLaunchConfiguration().getAdapter(Model.class);
                int kind = 1;
                if (this.launch.getLaunchMode().equals("exploreTrace")) {
                    kind = 3;
                }
                this.listener = new BroadcastStreamListener(model, kind);
                IStreamsProxy streamsProxy = this.process.getStreamsProxy();
                streamsProxy.getOutputStreamMonitor().addListener((IStreamListener)this.listener);
                streamsProxy.getErrorStreamMonitor().addListener((IStreamListener)this.listener);
                BufferedReader consoleReader = TLCProcessJob.getConsoleReader();
                while (this.checkAndSleep()) {
                    if (monitor.isCanceled()) {
                        try {
                            this.process.terminate();
                        }
                        catch (DebugException e) {
                            switch (e.getStatus().getCode()) {
                                default: 
                            }
                            Status status = new Status(4, "org.lamport.tla.toolbox.tool.tlc", e.getStatus().getCode(), "Error terminating the running TLC instance. This is a bug. Make sure to exit the toolbox.", (Throwable)e);
                            if (this.listener != null) {
                                this.listener.streamClosed();
                                if (this.process != null && this.process.getStreamsProxy() != null) {
                                    if (this.process.getStreamsProxy().getOutputStreamMonitor() != null) {
                                        this.process.getStreamsProxy().getOutputStreamMonitor().removeListener((IStreamListener)this.listener);
                                    }
                                    if (this.process.getStreamsProxy().getErrorStreamMonitor() != null) {
                                        this.process.getStreamsProxy().getErrorStreamMonitor().removeListener((IStreamListener)this.listener);
                                    }
                                }
                            }
                            monitor.done();
                            return status;
                        }
                        int i = 0;
                        while (!this.process.isTerminated() || i++ >= 10) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                Status status = new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error waiting for process termination.", (Throwable)e);
                                if (this.listener != null) {
                                    this.listener.streamClosed();
                                    if (this.process != null && this.process.getStreamsProxy() != null) {
                                        if (this.process.getStreamsProxy().getOutputStreamMonitor() != null) {
                                            this.process.getStreamsProxy().getOutputStreamMonitor().removeListener((IStreamListener)this.listener);
                                        }
                                        if (this.process.getStreamsProxy().getErrorStreamMonitor() != null) {
                                            this.process.getStreamsProxy().getErrorStreamMonitor().removeListener((IStreamListener)this.listener);
                                        }
                                    }
                                }
                                monitor.done();
                                return status;
                            }
                        }
                        if (!this.process.isTerminated()) {
                            TLCActivator.logInfo("TLC process failed to terminate within expected time window. Expect Toolbox to show an incorrect model state.");
                        }
                        this.tlcEndTime = System.currentTimeMillis();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        if (consoleReader == null || !consoleReader.ready()) continue;
                        streamsProxy.write(consoleReader.readLine() + "\n");
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error reading from Toolbox console or writing to stdin of TLC process", (Throwable)e));
                    }
                }
                monitor.worked(30);
                monitor.subTask("Model checking finished.");
                this.doFinish();
                this.tlcEndTime = System.currentTimeMillis();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            Status status = new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error launching TLC, the launched process cound not be found");
            return status;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error reading model parameters", (Throwable)e);
            return status;
        }
        finally {
            if (this.listener != null) {
                this.listener.streamClosed();
                if (this.process != null && this.process.getStreamsProxy() != null) {
                    if (this.process.getStreamsProxy().getOutputStreamMonitor() != null) {
                        this.process.getStreamsProxy().getOutputStreamMonitor().removeListener((IStreamListener)this.listener);
                    }
                    if (this.process.getStreamsProxy().getErrorStreamMonitor() != null) {
                        this.process.getStreamsProxy().getErrorStreamMonitor().removeListener((IStreamListener)this.listener);
                    }
                }
            }
            monitor.done();
        }
    }

    private static BufferedReader getConsoleReader() {
        IConsole iConsole;
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        List tlcConsole = Arrays.asList(consoleManager.getConsoles()).stream().filter(c -> "TLC-Console".equals(c.getName())).collect(Collectors.toList());
        if (!tlcConsole.isEmpty() && (iConsole = (IConsole)tlcConsole.get(0)) instanceof IOConsole) {
            IOConsoleInputStream inputStream = ((IOConsole)iConsole).getInputStream();
            return new BufferedReader(new InputStreamReader((InputStream)inputStream));
        }
        return null;
    }

    protected String getOptimalFPsetImpl() throws CoreException {
        return this.launch.getLaunchConfiguration().getAttribute("fpSetImpl", null);
    }

    protected List<String> getAdditionalVMArgs() throws CoreException {
        ILaunchConfiguration launchConfig;
        String vmArgs;
        ArrayList<String> result = new ArrayList<String>(0);
        Spec spec = Activator.getSpecManager().getSpecByName(this.specName);
        String tlaLibraryPathAsVMArg = spec.getTLALibraryPathAsVMArg();
        if (!"".equals(tlaLibraryPathAsVMArg)) {
            result.add(tlaLibraryPathAsVMArg);
        }
        if ((vmArgs = (launchConfig = this.launch.getLaunchConfiguration()).getAttribute("distributedTLCVMArgs", null)) != null) {
            result.addAll(this.sanitizeString(vmArgs));
        }
        return result;
    }

    private List<String> sanitizeString(String vmArgs) {
        String[] strings = vmArgs.split(" ");
        ArrayList<String> results = new ArrayList<String>(strings.length);
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (!"".equals(string) && !" ".equals(string)) {
                results.add(string.trim());
            }
            ++i;
        }
        return results;
    }

    protected Class getMainClass() {
        return TLC.class;
    }

    @Override
    protected boolean checkCondition() {
        return !this.process.isTerminated();
    }

    private static IProcess findProcessForLaunch(ILaunch launch) {
        IProcess[] processes = DebugPlugin.getDefault().getLaunchManager().getProcesses();
        int i = 0;
        while (i < processes.length) {
            if (processes[i].getLaunch().equals(launch)) {
                return processes[i];
            }
            ++i;
        }
        return null;
    }

    public long getTlcStartTime() {
        return this.tlcStartTime;
    }

    public long getTlcEndTime() {
        return this.tlcEndTime;
    }

    public int getExitValue() {
        if (this.process != null) {
            try {
                return this.process.getExitValue();
            }
            catch (DebugException shouldNotHappen) {
                shouldNotHappen.printStackTrace();
            }
        }
        return 255;
    }

    public boolean hasCrashed() {
        return EC.ExitStatus.exitStatusToCrash((int)this.getExitValue());
    }
}

