/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.lamport.tla.toolbox.tool.tlc.model.Model;

public class TLCModelFactory
implements IAdapterFactory,
ILaunchConfigurationListener {
    private final Map<IFile, Model> launch2model = new HashMap<IFile, Model>();

    public TLCModelFactory() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (IResource.class.equals(adapterType) && adaptableObject instanceof Model) {
            Model model = (Model)adaptableObject;
            if (model.getFolder().exists()) {
                return (T)model.getFolder();
            }
            return (T)model.getFile();
        }
        if (!Model.class.equals(adapterType)) {
            return null;
        }
        if (adaptableObject instanceof ILaunchConfiguration) {
            ILaunchConfiguration launchConfiguration = (ILaunchConfiguration)adaptableObject;
            IFile key = launchConfiguration.getFile();
            Assert.isNotNull((Object)key);
            if (!this.launch2model.containsKey(key)) {
                this.launch2model.put(key, new Model(launchConfiguration));
            }
            return (T)this.launch2model.get(key);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{ILaunchConfiguration.class, IResource.class};
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        IFile key = configuration.getFile();
        Assert.isNotNull((Object)key);
        this.launch2model.remove(key);
    }

    public static Model getByName(String fullQualifiedModelName) {
        Assert.isNotNull((Object)fullQualifiedModelName);
        Assert.isLegal((boolean)fullQualifiedModelName.contains("___"), (String)"Not a full-qualified model name.");
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.lamport.tla.toolbox.tool.tlc.modelCheck");
        try {
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
            int i = 0;
            while (i < launchConfigurations.length) {
                ILaunchConfiguration launchConfiguration = launchConfigurations[i];
                if (fullQualifiedModelName.equals(launchConfiguration.getName())) {
                    return (Model)launchConfiguration.getAdapter(Model.class);
                }
                ++i;
            }
        }
        catch (CoreException shouldNeverHappen) {
            shouldNeverHappen.printStackTrace();
        }
        return null;
    }

    public static Model getBy(IFile aFile) {
        Assert.isNotNull((Object)aFile);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.lamport.tla.toolbox.tool.tlc.modelCheck");
        try {
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
            int i = 0;
            while (i < launchConfigurations.length) {
                ILaunchConfiguration launchConfiguration = launchConfigurations[i];
                if (aFile.equals((Object)launchConfiguration.getFile())) {
                    return (Model)launchConfiguration.getAdapter(Model.class);
                }
                ++i;
            }
        }
        catch (CoreException shouldNeverHappen) {
            shouldNeverHappen.printStackTrace();
        }
        return null;
    }
}

