/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.lamport.tla.toolbox.util.AdapterFactory;
import pcal.Region;
import pcal.TLAtoPCalMapping;
import tla2sany.st.Location;

public class TLAtoPCalMarker
implements IMarker {
    private final IMarker delegate;
    private final TLAtoPCalMapping mapping;

    public TLAtoPCalMarker(IMarker delegate, TLAtoPCalMapping mapping) {
        Assert.isLegal((boolean)(delegate.getResource() instanceof IFile));
        this.delegate = delegate;
        Assert.isNotNull((Object)mapping);
        this.mapping = mapping;
    }

    public Region getRegion() {
        Region region;
        try {
            Location location = (Location)this.delegate.getAttribute("toolbox.region");
            region = location.toRegion();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        int offset = AdapterFactory.GetLineOfPCalAlgorithm((IFile)this.delegate.getResource());
        return this.mapping.mapTLAtoPCalRegion(region, offset);
    }

    public Object getAdapter(Class adapter) {
        return this.delegate.getAdapter(adapter);
    }

    public void delete() throws CoreException {
        this.delegate.delete();
    }

    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public Object getAttribute(String attributeName) throws CoreException {
        return this.delegate.getAttribute(attributeName);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        return this.delegate.getAttribute(attributeName, defaultValue);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        return this.delegate.getAttribute(attributeName, defaultValue);
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        return this.delegate.getAttribute(attributeName, defaultValue);
    }

    public Map<String, Object> getAttributes() throws CoreException {
        return this.delegate.getAttributes();
    }

    public Object[] getAttributes(String[] attributeNames) throws CoreException {
        return this.delegate.getAttributes(attributeNames);
    }

    public long getCreationTime() throws CoreException {
        return this.delegate.getCreationTime();
    }

    public long getId() {
        return this.delegate.getId();
    }

    public IResource getResource() {
        return this.delegate.getResource();
    }

    public String getType() throws CoreException {
        return this.delegate.getType();
    }

    public boolean isSubtypeOf(String superType) throws CoreException {
        return this.delegate.isSubtypeOf(superType);
    }

    public void setAttribute(String attributeName, int value) throws CoreException {
        this.delegate.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, Object value) throws CoreException {
        this.delegate.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, boolean value) throws CoreException {
        this.delegate.setAttribute(attributeName, value);
    }

    public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
        this.delegate.setAttributes(attributeNames, values);
    }

    public void setAttributes(Map attributes) throws CoreException {
        this.delegate.setAttributes(attributes);
    }
}

