/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IPath;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.parser.IParseResultListener;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.tool.SpecEvent;
import org.lamport.tla.toolbox.tool.SpecLifecycleParticipant;
import org.lamport.tla.toolbox.util.ResourceHelper;
import tla2sany.semantic.ModuleNode;

public class ParseResultBroadcaster {
    private static ParseResultBroadcaster instance;
    private final List<IParseResultListener> listeners = new CopyOnWriteArrayList<IParseResultListener>();
    private Map<IPath, ParseResult> parseResults = new HashMap<IPath, ParseResult>();

    private ParseResultBroadcaster() {
        Activator.getSpecManager().addSpecLifecycleParticipant(new SpecLifecycleParticipant(){

            @Override
            public boolean eventOccured(SpecEvent event) {
                if (event.getType() == 16) {
                    ParseResultBroadcaster.this.clear();
                }
                return true;
            }
        });
    }

    public static synchronized ParseResultBroadcaster getParseResultBroadcaster() {
        if (instance == null) {
            instance = new ParseResultBroadcaster();
        }
        return instance;
    }

    public void broadcastParseResult(ParseResult parseResult) {
        for (IParseResultListener listener : this.listeners) {
            listener.newParseResult(parseResult);
        }
        ModuleNode[] moduleNodes = parseResult.getSpecObj().getExternalModuleTable().getModuleNodes();
        IPath dirPath = parseResult.getParsedResource().getLocation().removeLastSegments(1);
        int i = 0;
        while (i < moduleNodes.length) {
            this.parseResults.put(dirPath.append(ResourceHelper.getModuleFileName(moduleNodes[i].getName().toString())), parseResult);
            ++i;
        }
    }

    public void addParseResultListener(IParseResultListener parseResultListener) {
        if (!this.listeners.contains(parseResultListener)) {
            this.listeners.add(parseResultListener);
        }
    }

    public void removeParseResultListener(IParseResultListener parseResultListener) {
        this.listeners.remove(parseResultListener);
    }

    public ParseResult getParseResult(IPath modulePath) {
        return this.parseResults.get(modulePath);
    }

    public void clear() {
        this.listeners.clear();
        this.parseResults.clear();
    }
}

