/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.contribution;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.SpecEvent;
import org.lamport.tla.toolbox.tool.SpecLifecycleParticipant;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.ToolboxJob;
import org.lamport.tla.toolbox.util.UIHelper;

public class ParseStatusContributionItem
extends WorkbenchWindowControlContribution {
    private Composite composite;
    private Label statusLabel;

    public ParseStatusContributionItem() {
        super("specParseStatusState");
        Activator.getSpecManager().addSpecLifecycleParticipant(new SpecLifecycleParticipant(){

            @Override
            public boolean eventOccured(SpecEvent event) {
                ParseStatusContributionItem.this.updateStatus();
                return true;
            }
        });
    }

    protected Control createControl(Composite parent) {
        if (this.composite != null && !this.composite.isDisposed()) {
            return this.composite;
        }
        this.composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.composite.setLayout((Layout)layout);
        Label description = new Label(this.composite, 0);
        description.setText("Spec Status : ");
        description.setSize(70, 20);
        this.statusLabel = new Label(this.composite, 0x1000800);
        this.statusLabel.setToolTipText("Specification Parse Status");
        this.statusLabel.setSize(100, 20);
        this.updateStatus();
        return this.composite;
    }

    public void updateStatus() {
        if (this.statusLabel == null || this.statusLabel.isDisposed()) {
            return;
        }
        ToolboxJob j = new ToolboxJob("Calculating specification size..."){

            protected IStatus run(IProgressMonitor monitor) {
                final Spec spec = Activator.getSpecManager().getSpecLoaded();
                UIHelper.runUIAsync(new Runnable(){

                    @Override
                    public void run() {
                        if (spec == null && !(this).ParseStatusContributionItem.this.composite.isDisposed()) {
                            (this).ParseStatusContributionItem.this.composite.setVisible(false);
                        } else if (!(this).ParseStatusContributionItem.this.statusLabel.isDisposed() && !(this).ParseStatusContributionItem.this.composite.isDisposed()) {
                            (this).ParseStatusContributionItem.this.statusLabel.setText(AdapterFactory.getStatusAsString(spec));
                            (this).ParseStatusContributionItem.this.statusLabel.setBackground((this).ParseStatusContributionItem.this.statusLabel.getDisplay().getSystemColor(AdapterFactory.getStatusAsSWTBGColor(spec)));
                            (this).ParseStatusContributionItem.this.statusLabel.setForeground((this).ParseStatusContributionItem.this.statusLabel.getDisplay().getSystemColor(AdapterFactory.getStatusAsSWTFGColor(spec)));
                            (this).ParseStatusContributionItem.this.statusLabel.redraw();
                            (this).ParseStatusContributionItem.this.composite.setVisible(true);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        j.schedule();
    }

    public void update() {
        this.updateStatus();
    }

    protected int computeWidth(Control control) {
        return 170;
    }
}

