/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Module;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.manager.WorkspaceSpecManager;
import org.lamport.tla.toolbox.util.ToolboxJob;

public class DeleteModuleHandler
extends AbstractHandler {
    private boolean m_enabled = false;

    public void setEnabled(Object evaluationContext) {
        Module m = this.getModuleFromContext((IEvaluationContext)evaluationContext);
        if (m != null) {
            String moduleName;
            WorkspaceSpecManager specManager = Activator.getSpecManager();
            Spec loadedSpec = specManager.getSpecLoaded();
            String specName = loadedSpec.getName();
            this.m_enabled = !specName.equals(moduleName = m.getModuleName());
            return;
        }
        this.m_enabled = false;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Module m = this.getModuleFromContext((IEvaluationContext)event.getApplicationContext());
        ToolboxJob j = new ToolboxJob("Removing module..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    m.getResource().delete(8, monitor);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    return Status.CANCEL_STATUS;
                }
            }
        };
        IWorkbenchWindow iww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = iww.getActivePage();
        IEditorReference[] refs = page.getEditorReferences();
        String tabName = m.getModuleName() + ".tla";
        boolean removeModule = true;
        IEditorReference[] iEditorReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor;
            IEditorReference ier = iEditorReferenceArray[n2];
            if (tabName.equals(ier.getName()) && (editor = ier.getEditor(false)) != null) {
                removeModule = page.closeEditor(editor, true);
            }
            ++n2;
        }
        if (removeModule) {
            j.schedule();
        }
        return null;
    }

    private Module getModuleFromContext(IEvaluationContext context) {
        Object o;
        List list;
        Object defaultVariable = context.getDefaultVariable();
        if (defaultVariable instanceof List && (list = (List)defaultVariable).size() == 1 && (o = list.get(0)) instanceof Module) {
            return (Module)o;
        }
        return null;
    }
}

