/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.manager.WorkspaceSpecManager;
import org.lamport.tla.toolbox.util.ToolboxJob;
import org.lamport.tla.toolbox.util.UIHelper;

public class RenameSpecHandler
extends AbstractHandler
implements IHandler {
    private boolean reopenEditorAfterRename;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        IWorkbenchPage activePage = UIHelper.getActivePage();
        if (activePage != null && (selection = activePage.getSelection("toolbox.view.ToolboxExplorer")) != null && selection instanceof IStructuredSelection) {
            final Spec spec = (Spec)((IStructuredSelection)selection).getFirstElement();
            String specName = spec.getName() + "_Copy";
            final InputDialog dialog = new InputDialog(UIHelper.getShell(), "New specification name", "Please input the new name of the specification", specName, (IInputValidator)new SpecNameValidator());
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                final WorkspaceSpecManager specManager = Activator.getSpecManager();
                this.reopenEditorAfterRename = false;
                if (specManager.isSpecLoaded(spec)) {
                    UIHelper.runCommand("toolbox.command.spec.close", new HashMap<String, String>());
                    this.reopenEditorAfterRename = true;
                }
                ToolboxJob j = new ToolboxJob("Renaming spec..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        specManager.renameSpec(spec, dialog.getValue(), monitor);
                        UIHelper.runUIAsync(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).RenameSpecHandler.this.reopenEditorAfterRename) {
                                    HashMap<String, String> parameters = new HashMap<String, String>();
                                    parameters.put("toolbox.command.spec.open.param", dialog.getValue());
                                    UIHelper.runCommand("toolbox.command.spec.open", parameters);
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                j.schedule();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        if (UIHelper.getActivePage() == null) {
            return false;
        }
        return super.isEnabled();
    }

    class SpecNameValidator
    implements IInputValidator {
        SpecNameValidator() {
        }

        public String isValid(String name) {
            if (name == null || name.length() == 0 || name.trim().length() == 0) {
                return "The specification name must not be empty";
            }
            Spec[] specs = Activator.getSpecManager().getRecentlyOpened();
            int i = 0;
            while (i < specs.length) {
                if (name.equals(specs[i].getName())) {
                    return "The specification with this name already exists";
                }
                if (name.equalsIgnoreCase(specs[i].getName())) {
                    return "A specification exists with the same name but a different case. This is not allowed.";
                }
                ++i;
            }
            return null;
        }
    }
}

