/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.lamport.tla.toolbox.util.UIHelper;

public class SwitchPerspectiveHandler
extends AbstractHandler
implements IHandler,
IElementUpdater {
    public static final String COMMAND_ID = "toolbox.command.switchperspective";
    public static final String PARAM_PERSPECTIVE_ID = "toolbox.switchperspective.id";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final String perspectiveId = event.getParameter(PARAM_PERSPECTIVE_ID);
        if (perspectiveId == null) {
            return null;
        }
        if (UIHelper.getActivePerspectiveId().equals(perspectiveId)) {
            return null;
        }
        final ICommandService service = (ICommandService)HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getService(ICommandService.class);
        UIHelper.runUIAsync(new Runnable(){

            @Override
            public void run() {
                UIHelper.switchPerspective(perspectiveId);
                service.refreshElements(event.getCommand().getId(), null);
            }
        });
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String parameter = (String)parameters.get(PARAM_PERSPECTIVE_ID);
        if (parameter != null) {
            if (UIHelper.getActivePerspectiveId().equals(parameter)) {
                element.setChecked(true);
            } else {
                element.setChecked(false);
            }
        }
    }
}

