/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.preference;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.util.UIHelper;

public class EditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String EDITOR_RIGHT_MARGIN = "editorRightMargin";
    public static final int EDITOR_RIGHT_MARGIN_DEFAULT = 77;
    public static final String EDITOR_ADD_MODIFICATION_HISTORY = "editorAddModificationHistory";
    public static final boolean EDITOR_ADD_MODIFICATION_HISTORY_DEFAULT = true;
    public static final String CLEAR_DECLARATION_USE_MARKERS_ON_PARSE = "removeDeclarationUseMarkersOnParse";
    public static final boolean CLEAR_DECLARATION_USE_MARKERS_ON_PARSE_DEFAULT = true;
    public static final String RENUMBER_KEY = "renumber_proof_option";
    public static final String ALL_NAMES = "renumber_proof_all";
    public static final String FIRST_DIGIT = "renumber_proof_first_digit";
    public static final String SOME_DIGIT = "renumber_proof_some_digit";
    public static final String ALL_DIGITS = "renumber_proof_all_digits";
    public static final String SAVE_MODULE = "renumber_proof_save";

    public EditorPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.setDescription("Module Editor preferences");
    }

    public EditorPreferencePage(int style) {
        super(style);
    }

    public EditorPreferencePage(String title, int style) {
        super(title, style);
    }

    public EditorPreferencePage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    protected Control createContents(Composite parent) {
        Control pageControl = super.createContents(parent);
        UIHelper.setHelp(pageControl, "EditorPreferencePage");
        return pageControl;
    }

    protected void createFieldEditors() {
        IntegerFieldEditor rightMarginEditor = new IntegerFieldEditor(EDITOR_RIGHT_MARGIN, "&Module editor right margin", this.getFieldEditorParent());
        this.addField((FieldEditor)rightMarginEditor);
        rightMarginEditor.setValidRange(20, 200);
        this.addField((FieldEditor)new BooleanFieldEditor(CLEAR_DECLARATION_USE_MARKERS_ON_PARSE, "&Clear declaration use markers when parsing", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(EDITOR_ADD_MODIFICATION_HISTORY, "&Add a modification history comment to new specs", this.getFieldEditorParent()));
        Label lbl = new Label(this.getFieldEditorParent(), 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        lbl = new Label(this.getFieldEditorParent(), 0);
        lbl.setText("Renumber Proof Command preferences");
        lbl.setLayoutData((Object)gd);
        this.addField((FieldEditor)new RadioGroupFieldEditor(RENUMBER_KEY, "Which step names to renumber", 1, (String[][])new String[][]{{"All step names", ALL_NAMES}, {"Names containing  a digit", SOME_DIGIT}, {"Names beginning with a digit", FIRST_DIGIT}, {"Names that are all digits", ALL_DIGITS}}, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(SAVE_MODULE, "&Save module", this.getFieldEditorParent()));
        lbl = new Label(this.getFieldEditorParent(), 0);
        lbl.setLayoutData((Object)gd);
        lbl = new Label(this.getFieldEditorParent(), 0);
        lbl.setText("Folding by default preferences");
        lbl.setLayoutData((Object)gd);
        this.addField((FieldEditor)new BooleanFieldEditor("foldingBlockComments", "Fold &block comments by default", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("foldingPCalAlg", "Fold &PlusCal algorithm blocks by default", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("foldingPCalTranslated", "Fold &translated &PlusCal algorithm TLA+ code by default", this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }
}

