/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util.e4;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.ui.PlatformUI;

public class E4HandlerWrapper
implements IExecutableExtensionFactory,
IExecutableExtension {
    private String clazz;

    public Object create() throws CoreException {
        try {
            return new E4Handler(Class.forName(this.clazz));
        }
        catch (ClassNotFoundException e) {
            throw new CoreException((IStatus)new Status(1, "org.lamport.tla.toolbox", e.getMessage(), (Throwable)e));
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String defaultHandler = config.getAttribute("defaultHandler");
        if (defaultHandler.contains(":")) {
            this.clazz = defaultHandler.split(":")[1];
        }
    }

    public static class E4Handler<C>
    extends AbstractHandler {
        private final C component;

        public E4Handler(Class<C> clazz) {
            IEclipseContext context = E4Handler.getActiveContext();
            this.component = ContextInjectionFactory.make(clazz, (IEclipseContext)context);
        }

        private static IEclipseContext getActiveContext() {
            IEclipseContext parentContext = E4Handler.getParentContext();
            return parentContext.getActiveLeaf();
        }

        private static IEclipseContext getParentContext() {
            return (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            E4Handler.getActiveContext().set(ExecutionEvent.class, (Object)event);
            try {
                Object object = ContextInjectionFactory.invoke(this.component, Execute.class, (IEclipseContext)E4Handler.getActiveContext());
                return object;
            }
            finally {
                E4Handler.getActiveContext().remove(ExecutionEvent.class);
            }
        }
    }
}

