/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec.nature;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.nature.ParserHelper;
import org.lamport.tla.toolbox.spec.nature.TLAParsingBuilderConstants;
import org.lamport.tla.toolbox.util.ChangedModulesGatheringDeltaVisitor;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.TLAMarkerHelper;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;

public class TLAParsingBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "toolbox.builder.TLAParserBuilder";

    protected void clean(IProgressMonitor monitor) throws CoreException {
        Activator.getDefault().logDebug("Clean has been invoked");
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        TLAMarkerHelper.removeProblemMarkers((IResource)spec.getProject(), monitor);
        this.forgetLastBuiltState();
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!Activator.isSpecManagerInstantiated()) {
            ResourcesPlugin.getWorkspace().build(kind, null);
            return null;
        }
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        if (spec == null || this.getProject() != spec.getProject()) {
            return null;
        }
        if (6 == kind || PreferenceStoreHelper.getInstancePreferenceStore().getBoolean("autoParseSpec")) {
            monitor.beginTask("Invoking the SANY to re-parse the spec", -1);
            ParserHelper.rebuildSpec((IProgressMonitor)new SubProgressMonitor(monitor, -1));
            monitor.done();
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                monitor.beginTask("Invoking the SANY to re-parse the spec", -1);
                ParserHelper.rebuildSpec((IProgressMonitor)new SubProgressMonitor(monitor, -1));
                monitor.done();
            } else {
                ChangedModulesGatheringDeltaVisitor moduleFinder = new ChangedModulesGatheringDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)moduleFinder);
                IFile rootFile = null;
                if (spec != null) {
                    rootFile = spec.getRootFile();
                }
                boolean buildSpecOnly = PreferenceStoreHelper.getInstancePreferenceStore().getBoolean("autoParseSpec");
                int i = 0;
                while (i < moduleFinder.getModules().size()) {
                    IResource changedModule = (IResource)moduleFinder.getModules().get(i);
                    this.build(changedModule.getProjectRelativePath().toString(), (IResource)rootFile, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                    List modulesToRebuild = Activator.getModuleDependencyStorage().getListOfModulesToReparse(changedModule.getProjectRelativePath().toString());
                    int j = 0;
                    while (j < modulesToRebuild.size()) {
                        String moduleToBuild = (String)modulesToRebuild.get(j);
                        if (buildSpecOnly && rootFile != null && rootFile.getName().equals(moduleToBuild)) {
                            this.build(moduleToBuild, (IResource)rootFile, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                            buildSpecOnly = false;
                        } else {
                            Activator.getDefault().logDebug("There is a root file, but the setting AUTO_BUILD_SPEC is off.");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private void build(String moduleFileName, IResource rootFile, IProgressMonitor monitor) {
        if (rootFile != null && rootFile.getName().equals(moduleFileName)) {
            monitor.beginTask("Invoking the SANY to re-parse the spec", -1);
            ParserHelper.rebuildSpec((IProgressMonitor)new SubProgressMonitor(monitor, -1));
            monitor.done();
        } else {
            IProject project = this.getProject();
            IFile moduleFile = project.getFile(moduleFileName);
            if (moduleFile == null || !moduleFile.exists()) {
                throw new IllegalStateException("Resource not found during build: " + moduleFileName);
            }
            if (!moduleFile.isDerived()) {
                monitor.beginTask("Invoking SANY to re-parse a module " + moduleFileName, -1);
                ParserHelper.rebuildModule((IResource)moduleFile, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                monitor.done();
            } else {
                Activator.getDefault().logDebug("Skipping resource: " + moduleFileName);
            }
        }
    }

    public static class OutOfBuildSpecModulesGatheringDeltaVisitor
    implements IResourceDeltaVisitor {
        Vector<IResource> modules = new Vector();
        Hashtable<String, String> dependancyTable = null;
        Spec spec = null;

        public OutOfBuildSpecModulesGatheringDeltaVisitor() {
            if (Activator.isSpecManagerInstantiated()) {
                this.spec = Activator.getSpecManager().getSpecLoaded();
                if (this.spec != null) {
                    String specRootFileName = this.spec.getRootFile().getName();
                    List dependancyList = Activator.getModuleDependencyStorage().getListOfExtendedModules(specRootFileName);
                    this.dependancyTable = new Hashtable(dependancyList.size());
                    this.dependancyTable.put(specRootFileName, specRootFileName);
                    for (String moduleName : dependancyList) {
                        this.dependancyTable.put(moduleName, moduleName);
                    }
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.exists() && 1 == resource.getType() && ResourceHelper.isModule(resource)) {
                if (this.spec == null) {
                    this.modules.add(resource);
                } else if (this.spec.getRootFile().getParent().equals((Object)resource.getParent())) {
                    if (resource.getPersistentProperty(TLAParsingBuilderConstants.LAST_BUILT) == null) {
                        if (this.spec.getStatus() < 0 && this.spec.getStatus() > -100) {
                            this.modules.add(resource);
                        }
                    } else if (Long.parseLong(resource.getPersistentProperty(TLAParsingBuilderConstants.LAST_BUILT)) < resource.getLocalTimeStamp() && (this.dependancyTable.containsKey(resource.getName()) || this.spec.getStatus() < 0 && this.spec.getStatus() > -99)) {
                        this.modules.add(resource);
                    }
                }
            }
            return true;
        }

        public List<IResource> getModules() {
            return this.modules;
        }
    }
}

