/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.osgi.framework.Bundle;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SemanticNode;
import tlc2.module.BuiltInModuleHelper;
import util.FilenameToStream;
import util.ToolIO;

public class RCPNameToFileIStream
implements FilenameToStream {
    private final Vector<String> libraryPathEntries = new Vector();
    private final Path tmpDir = FilenameToStream.getTempDirectory();

    public RCPNameToFileIStream(String[] libraryPathEntries) {
        if (libraryPathEntries != null) {
            int i = 0;
            while (i < libraryPathEntries.length) {
                if (new File(libraryPathEntries[i]).exists()) {
                    this.libraryPathEntries.addElement(libraryPathEntries[i]);
                }
                ++i;
            }
        }
        this.initInternalLibraryPath();
    }

    private void initInternalLibraryPath() {
        try {
            Bundle bundle = Platform.getBundle((String)"org.lamport.tlatools");
            Enumeration installedInternalModules = bundle.findEntries(BuiltInModuleHelper.STANDARD_MODULES_PATH, "StandardModules", true);
            if (installedInternalModules == null) {
                installedInternalModules = bundle.findEntries(File.separator + "src" + File.separator + BuiltInModuleHelper.STANDARD_MODULES_PATH, "StandardModules", true);
            }
            while (installedInternalModules.hasMoreElements()) {
                URL library = (URL)installedInternalModules.nextElement();
                if (library == null) continue;
                String path = FileLocator.resolve((URL)library).getPath();
                this.libraryPathEntries.add(path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File resolve(String name, boolean isModule) {
        if (isModule && name.endsWith(".tla")) {
            name = name.substring(0, name.length() - 4);
        }
        Object sourceFileName = isModule ? name + ".tla" : name;
        File sourceFile = this.locate((String)sourceFileName);
        return sourceFile;
    }

    private final File locate(String name) {
        String prefix = "";
        File sourceFile = null;
        int idx = 0;
        while (true) {
            if (idx == 0 && ToolIO.getUserDir() != null) {
                sourceFile = new FilenameToStream.TLAFile(ToolIO.getUserDir(), name, (FilenameToStream)this);
            } else if (FilenameToStream.isArchive((String)prefix)) {
                sourceFile = this.getFromArchive(prefix, name);
                if (sourceFile != null) {
                    return sourceFile;
                }
            } else {
                sourceFile = new FilenameToStream.TLAFile(prefix + name, true, (FilenameToStream)this);
            }
            if (sourceFile != null && sourceFile.exists() || idx >= this.libraryPathEntries.size()) break;
            prefix = this.libraryPathEntries.elementAt(idx++);
        }
        return sourceFile;
    }

    private File getFromArchive(String prefix, String name) {
        FilenameToStream.TLAFile outputFile = new FilenameToStream.TLAFile(this.tmpDir.resolve(name), true, (FilenameToStream)this);
        outputFile.deleteOnExit();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileSystem fileSystem = FileSystems.newFileSystem(new File(prefix).toPath(), null);){
                Path fileToExtract = fileSystem.getPath(name, new String[0]);
                Files.copy(fileToExtract, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return outputFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isStandardModule(String moduleName) {
        ModuleNode moduleNode = ResourceHelper.getModuleNode(moduleName);
        if (moduleNode == null) {
            return false;
        }
        return !ResourceHelper.isFromUserModule((SemanticNode)moduleNode);
    }

    public boolean isLibraryModule(String moduleName) {
        return this.isStandardModule(moduleName);
    }

    public String getFullPath() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.libraryPathEntries.size()) {
            buf.append(this.libraryPathEntries.elementAt(i));
            if (i < this.libraryPathEntries.size() - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    public Set<String> getAllModules() {
        HashSet<String> s = new HashSet<String>();
        for (String path : this.libraryPathEntries) {
            if (FilenameToStream.isArchive((String)path)) {
                s.addAll(this.listTLAFilesInZip(path));
                continue;
            }
            s.addAll(Arrays.stream(new File(path).listFiles((d, name) -> name.endsWith(".tla"))).map(f -> f.getName()).collect(Collectors.toSet()));
        }
        return s;
    }

    private Set<String> listTLAFilesInZip(String path) {
        HashSet<String> s = new HashSet<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(path);){
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".tla")) continue;
                    s.add(entryName);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }
}

