/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.awt.Frame;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.ui.property.GenericSelectionProvider;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.ResourceHelper;
import pcal.Region;
import pcal.TLAtoPCalMapping;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.Location;

public class UIHelper {
    private static final boolean PLATFORM_IS_LINUX = Platform.getOS().equals("linux");
    private static final AtomicBoolean SCALE_DETERMINATION_ATTEMPTED = new AtomicBoolean(false);
    private static double DISPLAY_SCALE = 1.0;

    public static void closeWindow(String perspectiveId) {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        if ("org.lamport.tla.toolbox.ui.perspective.initial".equals(perspectiveId)) {
            workbench.getIntroManager().closeIntro(workbench.getIntroManager().getIntro());
        }
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage page = windows[i].getActivePage();
            if (page != null && page.getPerspective() != null && perspectiveId.equals(page.getPerspective().getId())) {
                windows[i].close();
            }
            ++i;
        }
    }

    public static IWorkbenchWindow openPerspectiveInWindowRight(String perspectiveId, IAdaptable input, int width) {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        Rectangle bounds = workbench.getActiveWorkbenchWindow().getShell().getBounds();
        IWorkbenchWindow window = UIHelper.openPerspectiveInNewWindow(perspectiveId, input);
        window.getShell().setBounds(bounds.x + bounds.width, bounds.y, width, bounds.height);
        return window;
    }

    public static IWorkbenchWindow openPerspectiveInNewWindow(String perspectiveId, IAdaptable input) {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        IWorkbenchWindow window = null;
        try {
            window = workbench.openWorkbenchWindow(perspectiveId, input);
            if ("org.lamport.tla.toolbox.ui.perspective.initial".equals(perspectiveId) && workbench.getIntroManager().hasIntro()) {
                workbench.getIntroManager().showIntro(window, true);
            }
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
        return window;
    }

    public static IViewPart openView(String viewId) {
        IViewPart view = null;
        try {
            IWorkbenchPage activePage = UIHelper.getActivePage();
            if (activePage != null) {
                view = activePage.showView(viewId);
            }
        }
        catch (PartInitException e) {
            Activator.getDefault().logError("Error opening a view " + viewId, e);
        }
        return view;
    }

    public static IViewPart openViewNoFocus(String viewId) {
        return UIHelper.openViewNoFocus(viewId, null);
    }

    public static IViewPart openViewNoFocus(String viewId, String secondaryId) {
        IViewPart view = null;
        try {
            IWorkbenchPage activePage = UIHelper.getActivePage();
            if (activePage != null) {
                view = activePage.showView(viewId, secondaryId, 2);
            }
        }
        catch (PartInitException e) {
            Activator.getDefault().logError("Error opening a view " + viewId, e);
        }
        return view;
    }

    public static IViewPart findView(String viewId) {
        IViewPart view = null;
        IWorkbenchPage activePage = UIHelper.getActivePage();
        if (activePage != null) {
            view = activePage.findView(viewId);
        }
        return view;
    }

    public static boolean isViewShown(String id) {
        return UIHelper.getActivePage().findView(id) == null;
    }

    public static void hideView(String id) {
        IViewPart findView = UIHelper.getActivePage().findView(id);
        if (findView != null) {
            UIHelper.getActivePage().hideView(findView);
        }
    }

    public static void revertPerspecive(String perspectiveId) {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        IPerspectiveDescriptor descriptor = workbench.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        workbench.getPerspectiveRegistry().revertPerspective(descriptor);
    }

    public static void addPerspectiveListener(IPerspectiveListener listener) {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        window.addPerspectiveListener(listener);
    }

    public static IWorkbenchPage switchPerspective(String perspectiveId) {
        Assert.isNotNull((Object)perspectiveId, (String)"PerspectiveId is null");
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = UIHelper.getActiveWindow();
        Assert.isNotNull((Object)workbench, (String)"Workbench is null");
        Assert.isNotNull((Object)window, (String)"Window is null");
        try {
            IWorkbenchPage page = workbench.showPerspective(perspectiveId, window);
            if ("org.lamport.tla.toolbox.ui.perspective.initial".equals(perspectiveId) && workbench.getIntroManager().hasIntro()) {
                page.resetPerspective();
                UIHelper.openView("toolbox.view.ToolboxWelcomeView");
            }
            return page;
        }
        catch (WorkbenchException e) {
            Activator.getDefault().logError("Error switching a perspective to " + perspectiveId, e);
            return null;
        }
    }

    public static String getActivePerspectiveId() {
        return UIHelper.getActivePage().getPerspective().getId();
    }

    public static IEditorPart findEditor(String editorId) throws CoreException {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.ui", "editors");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ice = iConfigurationElementArray[n2];
            if (editorId.equals(ice.getAttribute("id"))) {
                return (IEditorPart)ice.createExecutableExtension("class");
            }
            ++n2;
        }
        return null;
    }

    public static IEditorPart openEditor(String editorId, IFile file) {
        return UIHelper.openEditor(editorId, (IEditorInput)new FileEditorInput(file));
    }

    public static IEditorPart openEditor(String editorId, IEditorInput input) {
        IWorkbenchPage activePage = UIHelper.getActivePage();
        if (activePage != null) {
            try {
                IEditorPart openEditor = activePage.openEditor(input, editorId);
                UIHelper.getActiveWindow().setActivePage(null);
                UIHelper.getActiveWindow().setActivePage(activePage);
                return openEditor;
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IEditorPart openEditorUnchecked(String editorId, IFile file) throws PartInitException {
        return UIHelper.openEditorUnchecked(editorId, (IEditorInput)new FileEditorInput(file), true);
    }

    public static IEditorPart openEditorUnchecked(String editorId, IFile file, boolean activate) throws PartInitException {
        return UIHelper.openEditorUnchecked(editorId, (IEditorInput)new FileEditorInput(file), activate);
    }

    public static IEditorPart openEditorUnchecked(String editorId, File file, String name) throws PartInitException {
        return UIHelper.openEditorUnchecked(editorId, file, name, true);
    }

    public static IEditorPart openEditorUnchecked(String editorId, File file, String name, boolean activate) throws PartInitException {
        IFileSystem localFileSystem = EFS.getLocalFileSystem();
        IFileStore fromLocalFile = localFileSystem.fromLocalFile(file);
        return UIHelper.openEditorUnchecked(editorId, (IEditorInput)new NamedFileStoreEditorInput(fromLocalFile, name), activate);
    }

    public static IEditorPart openEditorUnchecked(String editorId, IEditorInput input) throws PartInitException {
        return UIHelper.openEditorUnchecked(editorId, input, true);
    }

    public static IEditorPart openEditorUnchecked(String editorId, IEditorInput input, boolean activate) throws PartInitException {
        IWorkbenchPage activePage = UIHelper.getActivePage();
        if (activePage != null) {
            IEditorPart openEditor = activePage.openEditor(input, editorId, activate);
            UIHelper.getActiveWindow().setActivePage(null);
            UIHelper.getActiveWindow().setActivePage(activePage);
            return openEditor;
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = UIHelper.getActiveWindow();
        if (window == null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                IWorkbenchWindow[] workbenchWindows = workbench.getWorkbenchWindows();
                int i = 0;
                while (i < workbenchWindows.length) {
                    if (workbenchWindows[i] != null) {
                        return workbenchWindows[i].getActivePage();
                    }
                    ++i;
                }
                return null;
            }
            return null;
        }
        return window.getActivePage();
    }

    public static String[] getOpenedResources() {
        IEditorReference[] references = UIHelper.getActivePage().getEditorReferences();
        String[] openedResources = new String[references.length];
        int i = 0;
        while (i < references.length) {
            openedResources[i] = references[i].getContentDescription();
            ++i;
        }
        return openedResources;
    }

    public static Object runCommand(String commandId, Map<String, String> parameters) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (handlerService == null || commandService == null) {
            Activator.getDefault().logInfo("No IHandlerService|ICommandService available while trying to execute a command");
            return null;
        }
        try {
            Command command = commandService.getCommand(commandId);
            ParameterizedCommand pCommand = ParameterizedCommand.generateCommand((Command)command, parameters);
            return handlerService.executeCommand(pCommand, null);
        }
        catch (NotDefinedException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        catch (NotEnabledException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        catch (NotHandledException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            MessageDialog.openError((Shell)UIHelper.getShell(), (String)"Failed to execute.", (String)e.getMessage());
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return null;
    }

    public static List<IEditorReference> checkOpenResources(String title, String message) {
        boolean saveFiles;
        LinkedList<IEditorReference> dirtyEditors = new LinkedList<IEditorReference>();
        IEditorReference[] references = UIHelper.getActivePage().getEditorReferences();
        if (references != null) {
            int i = 0;
            while (i < references.length) {
                if (references[i].isDirty()) {
                    dirtyEditors.add(references[i]);
                }
                ++i;
            }
        }
        if (dirtyEditors.size() > 0 && (saveFiles = MessageDialog.openQuestion((Shell)UIHelper.getShell(), (String)title, (String)message))) {
            return dirtyEditors;
        }
        return new LinkedList<IEditorReference>();
    }

    public static boolean promptUserForDirtyModules() {
        final LinkedList<IEditorReference> dirtyEditors = new LinkedList<IEditorReference>();
        IEditorReference[] references = UIHelper.getActivePage().getEditorReferences();
        if (references != null) {
            int i = 0;
            while (i < references.length) {
                try {
                    if (references[i].isDirty() && references[i].getEditorInput().getName().endsWith(".tla")) {
                        dirtyEditors.add(references[i]);
                    }
                }
                catch (PartInitException e) {
                    Activator.getDefault().logError("Error getting unsaved resources.", e);
                }
                ++i;
            }
        }
        if (dirtyEditors.size() > 0) {
            boolean saveFiles = MessageDialog.openConfirm((Shell)UIHelper.getShell(), (String)"Modified resources", (String)"Some resources are modified.\nDo you want to save the modified resources?");
            if (saveFiles) {
                UIHelper.runUISync(new Runnable(){

                    @Override
                    public void run() {
                        for (IEditorReference reference : dirtyEditors) {
                            IEditorPart editor = reference.getEditor(false);
                            if (editor == null) continue;
                            editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                });
            }
            return saveFiles;
        }
        return true;
    }

    public static FileDialog getFileDialog(Shell shell) {
        FileDialog openFileDialog = null;
        if (Platform.getOS().equals("macosx")) {
            openFileDialog = new FileDialog(shell, 8192);
            openFileDialog.setOverwrite(false);
        } else {
            openFileDialog = Platform.getOS().equals("linux") ? new FileDialog(shell, 12288) : new FileDialog(shell, 4096);
        }
        return openFileDialog;
    }

    public static Shell getShell() {
        return UIHelper.getActiveWindow().getShell();
    }

    public static Display getCurrentDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            return Display.getDefault();
        }
        return display;
    }

    public static void runUISync(Runnable task) {
        Display display = UIHelper.getCurrentDisplay();
        display.syncExec(task);
    }

    public static void runUIAsync(Runnable task) {
        Display display = UIHelper.getCurrentDisplay();
        display.asyncExec(task);
    }

    public static boolean isPerspectiveShown(String perspectiveId) {
        if (perspectiveId == null || perspectiveId.equals("")) {
            return false;
        }
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < workbenchWindows.length) {
            IPerspectiveDescriptor[] openPerspectives = workbenchWindows[i].getActivePage().getOpenPerspectives();
            int j = 0;
            while (j < openPerspectives.length) {
                if (perspectiveId.equals(openPerspectives[j].getId())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static void setHelp(Control control, String localContext) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.lamport.tla.toolbox." + localContext);
    }

    public static ImageDescriptor imageDescriptor(String imageFilePath) {
        return Activator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox", (String)imageFilePath);
    }

    public static IShellProvider getShellProvider() {
        return new IShellProvider(){

            public Shell getShell() {
                return UIHelper.getShell();
            }
        };
    }

    public static ISelectionProvider getActiveEditorFileSelectionProvider() {
        return new GenericSelectionProvider(){

            @Override
            public ISelection getSelection() {
                IEditorInput input = UIHelper.getActiveEditor().getEditorInput();
                if (input instanceof FileEditorInput) {
                    IFile resource = ((FileEditorInput)input).getFile();
                    return new StructuredSelection((Object)resource);
                }
                return null;
            }

            @Override
            public void setSelection(ISelection selection) {
                throw new UnsupportedOperationException("This selection provider is read-only");
            }
        };
    }

    public static Control getWidget(Object control) {
        if (control instanceof Viewer) {
            return ((Viewer)control).getControl();
        }
        if (control instanceof Text) {
            return (Text)control;
        }
        if (control instanceof Button) {
            return (Control)control;
        }
        if (control instanceof Spinner) {
            return (Control)control;
        }
        if (control instanceof Combo) {
            return (Control)control;
        }
        if (control instanceof Control) {
            return null;
        }
        return null;
    }

    public static void showDynamicHelp() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                UIHelper.getActiveWindow().getWorkbench().getHelpSystem().displayDynamicHelp();
                IViewPart helpView = UIHelper.findView("org.eclipse.help.ui.HelpView");
                if (helpView != null && UIHelper.getActiveWindow() != null && UIHelper.getActiveWindow().getActivePage() != null) {
                    UIHelper.getActiveWindow().getActivePage().activate((IWorkbenchPart)helpView);
                }
            }
        });
    }

    public static void jumpToLocation(Location location) {
        UIHelper.jumpToLocation(location, false, null);
    }

    /*
     * Loose catch block
     */
    public static void jumpToLocation(Location location, boolean jumpToPCal, IWorkbenchPart workbenchPart) {
        block23: {
            IResource moduleResource;
            if (location != null && (moduleResource = ResourceHelper.getResourceByModuleName(location.source())) != null && moduleResource.exists()) {
                FileDocumentProvider fileDocumentProvider;
                FileEditorInput fileEditorInput;
                IDocument document;
                block24: {
                    IWorkbenchPage activePage;
                    block25: {
                        IWorkbenchPage activePage2;
                        document = null;
                        fileEditorInput = new FileEditorInput((IFile)moduleResource);
                        fileDocumentProvider = new FileDocumentProvider();
                        fileDocumentProvider.connect((Object)fileEditorInput);
                        document = fileDocumentProvider.getDocument((Object)fileEditorInput);
                        if (document == null) break block23;
                        if (!jumpToPCal) break block24;
                        TLAtoPCalMapping mapping = ToolboxHandle.getCurrentSpec().getTpMapping(location.source() + ".tla");
                        if (mapping == null) break block25;
                        Region pCalRegion = AdapterFactory.jumptToPCal(mapping, location, document);
                        if (pCalRegion != null) {
                            location = pCalRegion.toLocation();
                            break block24;
                        }
                        UIHelper.setStatusLineMessage("No valid TLA to PCal mapping found for current selection");
                        fileDocumentProvider.disconnect((Object)fileEditorInput);
                        if (workbenchPart != null && (activePage2 = UIHelper.getActivePage()) != null) {
                            activePage2.activate(workbenchPart);
                        }
                        return;
                    }
                    UIHelper.setStatusLineMessage("No valid TLA to PCal mapping found for current selection");
                    fileDocumentProvider.disconnect((Object)fileEditorInput);
                    if (workbenchPart != null && (activePage = UIHelper.getActivePage()) != null) {
                        activePage.activate(workbenchPart);
                    }
                    return;
                }
                try {
                    try {
                        IEditorPart editor;
                        IRegion region = AdapterFactory.locationToRegion(document, location);
                        int offset = region.getOffset();
                        int length = region.getLength();
                        if (jumpToPCal) {
                            --length;
                        }
                        if ((editor = UIHelper.openEditor("org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer", (IEditorInput)new FileEditorInput((IFile)moduleResource))) != null) {
                            ITextEditor textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
                            if (textEditor == null && editor instanceof MultiPageEditorPart) {
                                IEditorPart[] editors = ((MultiPageEditorPart)editor).findEditors(editor.getEditorInput());
                                int i = 0;
                                while (i < editors.length) {
                                    if (editors[i] instanceof ITextEditor) {
                                        textEditor = (ITextEditor)editors[i];
                                    }
                                    ++i;
                                }
                            }
                            if (textEditor != null) {
                                if (editor instanceof MultiPageEditorPart) {
                                    ((MultiPageEditorPart)editor).setActiveEditor((IEditorPart)textEditor);
                                }
                                textEditor.selectAndReveal(offset, length);
                            }
                        }
                        break block23;
                        {
                            catch (BadLocationException e) {
                                Activator.getDefault().logError("Error accessing the specified module location", e);
                            }
                        }
                    }
                    catch (CoreException e1) {
                        IWorkbenchPage activePage;
                        Activator.getDefault().logDebug("Error going to a module location. This is a bug.");
                        fileDocumentProvider.disconnect((Object)fileEditorInput);
                        if (workbenchPart != null && (activePage = UIHelper.getActivePage()) != null) {
                            activePage.activate(workbenchPart);
                        }
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IWorkbenchPage activePage;
                    fileDocumentProvider.disconnect((Object)fileEditorInput);
                    if (workbenchPart != null && (activePage = UIHelper.getActivePage()) != null) {
                        activePage.activate(workbenchPart);
                    }
                }
            }
        }
    }

    public static void jumpToDefOrDecl(SymbolNode node) {
        Location location = node instanceof OpDefNode ? ((SyntaxTreeNode)((OpDefNode)node).getSource().getTreeNode()).getHeirs()[0].getLocation() : (node instanceof ThmOrAssumpDefNode ? ((SyntaxTreeNode)((ThmOrAssumpDefNode)node).getSource().getTreeNode()).getHeirs()[1].getLocation() : node.getLocation());
        UIHelper.jumpToLocation(location);
    }

    public static TheoremNode getThmNodeStepWithCaret(TheoremNode theoremNode, int caretOffset, IDocument document) {
        try {
            Location proofLoc;
            int nodeBeginLine = theoremNode.getLocation().beginLine();
            int nodeEndLine = theoremNode.getTheorem().getLocation().endLine();
            int caretLine = document.getLineOfOffset(caretOffset) + 1;
            if (nodeBeginLine <= caretLine && nodeEndLine >= caretLine) {
                return theoremNode;
            }
            ProofNode proof = theoremNode.getProof();
            if (proof != null && caretLine >= (proofLoc = proof.getLocation()).beginLine() && caretLine <= proofLoc.endLine() && proof instanceof NonLeafProofNode) {
                NonLeafProofNode nonLeafProof = (NonLeafProofNode)proof;
                LevelNode[] steps = nonLeafProof.getSteps();
                int i = 0;
                while (i < steps.length) {
                    TheoremNode node;
                    if (steps[i] instanceof TheoremNode && (node = UIHelper.getThmNodeStepWithCaret((TheoremNode)steps[i], caretOffset, document)) != null) {
                        return node;
                    }
                    ++i;
                }
            }
        }
        catch (BadLocationException e) {
            Activator.getDefault().logError("Error finding step containing caret.", e);
        }
        return null;
    }

    public static void jumpToSelection(String fileName, ITextSelection its) {
        IEditorPart editor;
        IResource moduleResource = ResourceHelper.getResourceByModuleName(fileName.substring(0, fileName.indexOf(46)));
        if (moduleResource != null && moduleResource.exists() && (editor = UIHelper.openEditor("org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer", (IEditorInput)new FileEditorInput((IFile)moduleResource))) != null) {
            UIHelper.jumpToSelection(editor, its);
        }
    }

    public static void jumpToSelection(IEditorPart editor, ITextSelection its) {
        ITextEditor textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
        if (editor instanceof MultiPageEditorPart) {
            IEditorPart[] editors = ((MultiPageEditorPart)editor).findEditors(editor.getEditorInput());
            int i = 0;
            while (i < editors.length) {
                if (editors[i] instanceof ITextEditor) {
                    textEditor = (ITextEditor)editors[i];
                }
                ++i;
            }
        }
        if (textEditor != null) {
            if (editor instanceof MultiPageEditorPart) {
                ((MultiPageEditorPart)editor).setActiveEditor((IEditorPart)textEditor);
            }
            textEditor.selectAndReveal(its.getOffset(), its.getLength());
        }
    }

    public static Image getSWTImage(final int imageID) {
        Shell shell = UIHelper.getShell();
        final Display display = shell == null || shell.isDisposed() ? Display.getCurrent() : shell.getDisplay();
        final Image[] image = new Image[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                image[0] = display.getSystemImage(imageID);
            }
        });
        return image[0];
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = UIHelper.getActivePage();
        if (activePage != null) {
            return activePage.getActiveEditor();
        }
        return null;
    }

    public static void setStatusLineMessage(String msg) {
        IStatusLineManager statusLineManager = null;
        ISelectionProvider selectionService = null;
        IWorkbenchPart workbenchPart = UIHelper.getActiveWindow().getActivePage().getActivePart();
        if (workbenchPart instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchPart;
            statusLineManager = viewPart.getViewSite().getActionBars().getStatusLineManager();
            selectionService = viewPart.getViewSite().getSelectionProvider();
        } else if (UIHelper.getActiveEditor() != null) {
            IEditorSite editorSite = UIHelper.getActiveEditor().getEditorSite();
            statusLineManager = editorSite.getActionBars().getStatusLineManager();
            selectionService = editorSite.getSelectionProvider();
        }
        if (statusLineManager != null && selectionService != null) {
            statusLineManager.setMessage(msg);
            selectionService.addSelectionChangedListener((ISelectionChangedListener)new StatusLineMessageEraser(statusLineManager, selectionService));
        }
    }

    public static boolean isInSameStack(IWorkbenchPart part, String otherId) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)otherId);
        IEclipseContext ctx = (IEclipseContext)part.getSite().getService(IEclipseContext.class);
        if (ctx == null) {
            return false;
        }
        MPart e4ModelPart = (MPart)ctx.get(MPart.class);
        MElementContainer stack = e4ModelPart.getParent();
        if (stack == null) {
            return false;
        }
        List children = stack.getChildren();
        for (MUIElement muiElement : children) {
            String elementId = muiElement.getElementId();
            if (elementId == null || !elementId.equals(otherId)) continue;
            return true;
        }
        return false;
    }

    public static void appropriatelyScaleTableWrapData(TableWrapData tableWrapData) {
        if (Platform.getOS().equals("linux")) {
            double scale = UIHelper.getDisplayScaleFactor();
            tableWrapData.indent = (int)((double)tableWrapData.indent * scale);
            if (tableWrapData.maxWidth != -1) {
                tableWrapData.maxWidth = (int)((double)tableWrapData.maxWidth * scale);
            }
            if (tableWrapData.maxHeight != -1) {
                tableWrapData.maxHeight = (int)((double)tableWrapData.maxHeight * scale);
            }
            if (tableWrapData.heightHint != -1) {
                tableWrapData.heightHint = (int)((double)tableWrapData.heightHint * scale);
            }
        }
    }

    public static void appropriatelyScaleGridData(GridData gridData) {
        if (Platform.getOS().equals("linux")) {
            double scale = UIHelper.getDisplayScaleFactor();
            gridData.horizontalIndent = (int)((double)gridData.horizontalIndent * scale);
            gridData.verticalIndent = (int)((double)gridData.verticalIndent * scale);
            if (gridData.widthHint != -1) {
                gridData.widthHint = (int)((double)gridData.widthHint * scale);
            }
            if (gridData.heightHint != -1) {
                gridData.heightHint = (int)((double)gridData.heightHint * scale);
            }
            gridData.minimumWidth = (int)((double)gridData.minimumWidth * scale);
            gridData.minimumHeight = (int)((double)gridData.minimumHeight * scale);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getDisplayScaleFactor() {
        if (SCALE_DETERMINATION_ATTEMPTED.getAndSet(true)) return DISPLAY_SCALE;
        if (PLATFORM_IS_LINUX) {
            Shell s = null;
            Composite c = null;
            try {
                try {
                    Display d = PlatformUI.getWorkbench().getDisplay();
                    s = new Shell(d);
                    c = new Composite((Composite)s, 0x1000000);
                    Frame f = SWT_AWT.new_Frame((Composite)c);
                    DISPLAY_SCALE = f.getGraphicsConfiguration().getDefaultTransform().getScaleX();
                    return DISPLAY_SCALE;
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.lamport.tla.toolbox", "Exception fetching Linux display scale.", (Throwable)e));
                    DISPLAY_SCALE = 1.0;
                    if (c != null) {
                        c.dispose();
                    }
                    if (s == null) return DISPLAY_SCALE;
                    s.dispose();
                }
                return DISPLAY_SCALE;
            }
            finally {
                if (c != null) {
                    c.dispose();
                }
                if (s != null) {
                    s.dispose();
                }
            }
        } else {
            DISPLAY_SCALE = (double)DPIUtil.getDeviceZoom() / 100.0;
        }
        return DISPLAY_SCALE;
    }

    private static class NamedFileStoreEditorInput
    extends FileStoreEditorInput {
        private final String name;

        public NamedFileStoreEditorInput(IFileStore fileStore, String name) {
            super(fileStore);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class StatusLineMessageEraser
    implements ISelectionChangedListener {
        private final IStatusLineManager statusLineManager;
        private final ISelectionProvider selectionService;

        private StatusLineMessageEraser(IStatusLineManager statusLineManager, ISelectionProvider ss) {
            this.statusLineManager = statusLineManager;
            this.selectionService = ss;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.statusLineManager.setMessage(null);
            this.selectionService.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }
}

