/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.ByteArrayOutputStream;
import java.util.List;
import tlc2.output.AbstractSpecWriter;
import tlc2.output.SpecWriterUtilities;

class REPLSpecWriter
extends AbstractSpecWriter {
    private static final String EXPRESSION_OPEN = "\"EXPR_TLATE_BEGIN\"";
    private static final String EXPRESSION_CLOSE = "\"EXPR_TLATE_END\"";
    private static final String ASSUME_PREFIX = "ASSUME PrintT(\"EXPR_TLATE_BEGIN\") /\\ PrintT(\n";
    private static final String ASSUME_SUFFIX = "\n) /\\ PrintT(\"EXPR_TLATE_END\")\n";

    REPLSpecWriter(String specName, List<String> expressions) {
        super(true);
        this.tlaBuffer.append((CharSequence)SpecWriterUtilities.getExtendingModuleContent(specName, "Naturals", "Reals", "Sequences", "Bags", "FiniteSets", "TLC"));
        this.tlaBuffer.append(ASSUME_PREFIX);
        this.tlaBuffer.append(String.join((CharSequence)"\n", expressions));
        this.tlaBuffer.append(ASSUME_SUFFIX);
    }

    static class REPLLogConsumerStream
    extends ByteArrayOutputStream {
        private boolean inResponse = false;
        private boolean haveCollected = false;
        private StringBuilder currentLine = new StringBuilder();
        private String collectedContent;

        REPLLogConsumerStream() {
        }

        String getCollectedContent() {
            return this.collectedContent;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            int i = off;
            while (i < off + len) {
                this.write(b[i]);
                ++i;
            }
        }

        @Override
        public void write(int b) {
            if (this.haveCollected) {
                return;
            }
            if (b == 10) {
                if (this.inResponse) {
                    if (REPLSpecWriter.EXPRESSION_CLOSE.equals(this.currentLine.toString())) {
                        this.haveCollected = true;
                        String allCollectedContent = this.toString();
                        int length = allCollectedContent.length();
                        this.collectedContent = allCollectedContent.substring(0, length - (REPLSpecWriter.EXPRESSION_CLOSE.length() + 1));
                    } else {
                        super.write(b);
                    }
                } else if (REPLSpecWriter.EXPRESSION_OPEN.equals(this.currentLine.toString())) {
                    this.inResponse = true;
                }
                this.currentLine = new StringBuilder();
            } else {
                if (this.inResponse) {
                    super.write(b);
                }
                this.currentLine.append((char)b);
            }
        }
    }
}

