/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import util.FileUtil;

public class LongVec
implements Serializable {
    private static final long serialVersionUID = 2406899362740899071L;
    protected long[] elementData;
    protected int elementCount;

    public LongVec() {
        this(10);
    }

    public LongVec(int initialCapacity) {
        this.elementCount = 0;
        this.elementData = new long[initialCapacity];
    }

    private LongVec(LongVec other) {
        this.elementCount = other.elementCount;
        this.elementData = Arrays.copyOfRange(other.elementData, 0, other.elementCount);
    }

    public final void addElement(long x) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        this.elementData[this.elementCount++] = x;
    }

    public final long elementAt(int index) {
        this.rangeCheck(index);
        return this.elementData[index];
    }

    public final long lastElement() {
        return this.elementData[this.elementCount - 1];
    }

    public final void removeElement(int index) {
        this.rangeCheck(index);
        this.elementData[index] = this.elementData[this.elementCount - 1];
        --this.elementCount;
    }

    private void rangeCheck(int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final int size() {
        return this.elementCount;
    }

    private final void ensureCapacity(int minCapacity) {
        if (this.elementData.length < minCapacity) {
            int newCapacity = this.elementData.length + this.elementData.length;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            long[] oldBuffer = this.elementData;
            this.elementData = new long[newCapacity];
            System.arraycopy(oldBuffer, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void reset() {
        this.elementCount = 0;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.elementCount = ois.readInt();
        this.elementData = new long[this.elementCount];
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = ois.readLong();
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.elementCount);
        int i = 0;
        while (i < this.elementCount) {
            oos.writeLong(this.elementData[i]);
            ++i;
        }
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        if (this.elementCount != 0) {
            sb.append(this.elementData[0]);
        }
        int i = 1;
        while (i < this.elementCount) {
            sb.append(", ");
            sb.append(this.elementData[i]);
            ++i;
        }
        sb.append(">");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        LongVec vec = new LongVec(1000);
        vec.addElement(1L);
        vec.addElement(3L);
        vec.addElement(5L);
        System.err.println(vec.size());
        ObjectOutputStream oos = FileUtil.newOBFOS("XXX");
        oos.writeObject(vec);
        ObjectInputStream ois = FileUtil.newOBFIS("XXX");
        LongVec vec1 = (LongVec)ois.readObject();
        System.err.println(vec1.size());
        System.err.println(vec1.elementAt(0));
        System.err.println(vec1.elementAt(1));
        System.err.println(vec1.elementAt(2));
    }

    private LongVec reverse0() {
        int left = 0;
        int right = this.elementData.length - 1;
        while (left < right) {
            long temp = this.elementData[left];
            this.elementData[left] = this.elementData[right];
            this.elementData[right] = temp;
            ++left;
            --right;
        }
        return this;
    }

    public LongVec reverse() {
        return new LongVec(this).reverse0();
    }

    public LongVec pack() {
        LongVec filtered = new LongVec(this.size());
        int i = 0;
        while (i < this.elementCount) {
            long x = this.elementData[i];
            if (filtered.elementCount == 0 || filtered.lastElement() != x) {
                filtered.addElement(x);
            }
            ++i;
        }
        this.elementCount = filtered.elementCount;
        this.elementData = filtered.elementData;
        return this;
    }

    public LongVec removeLastIf(long x) {
        if (this.elementCount > 0 && this.lastElement() == x) {
            --this.elementCount;
        }
        return this;
    }
}

