/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.FingerprintException;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.coverage.CostModel;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.ValueInputStream;
import tlc2.value.Values;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.FunctionValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TLCVariable;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.UniqueString;

public class RecordValue
extends Value
implements FunctionValue {
    private static final UniqueString BLI = UniqueString.of("beginLine");
    private static final UniqueString BCOL = UniqueString.of("beginColumn");
    private static final UniqueString ELI = UniqueString.of("endLine");
    private static final UniqueString ECOL = UniqueString.of("endColumn");
    private static final UniqueString MOD = UniqueString.of("module");
    private static final UniqueString NAME = UniqueString.of("name");
    private static final UniqueString LOC = UniqueString.of("location");
    private static final UniqueString CTXT = UniqueString.of("context");
    private static final UniqueString PARAMS = UniqueString.of("parameters");
    private static final UniqueString ACTION = UniqueString.of("_action");
    public final UniqueString[] names;
    public final Value[] values;
    private boolean isNorm;
    public static final RecordValue EmptyRcd = new RecordValue(new UniqueString[0], new Value[0], true);

    public RecordValue(UniqueString[] names, Value[] values, boolean isNorm) {
        this.names = names;
        this.values = values;
        this.isNorm = isNorm;
    }

    public RecordValue(UniqueString[] names, Value[] values, boolean isNorm, CostModel cm) {
        this(names, values, isNorm);
        this.cm = cm;
    }

    public RecordValue(UniqueString name, Value v, boolean isNorm) {
        this(new UniqueString[]{name}, new Value[]{v}, isNorm);
    }

    public RecordValue(UniqueString name, Value v) {
        this(new UniqueString[]{name}, new Value[]{v}, false);
    }

    public RecordValue(Map<UniqueString, ? extends Value> m) {
        ArrayList<Map.Entry<UniqueString, ? extends Value>> entries = new ArrayList<Map.Entry<UniqueString, ? extends Value>>(m.entrySet());
        this.names = new UniqueString[entries.size()];
        this.values = new Value[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            this.names[i] = (UniqueString)((Map.Entry)entries.get(i)).getKey();
            this.values[i] = (Value)((Map.Entry)entries.get(i)).getValue();
            ++i;
        }
    }

    public RecordValue(RecordValue existing, UniqueString name, Value v) {
        this((UniqueString[])Stream.concat(Arrays.stream(existing.names), Stream.of(name)).toArray(UniqueString[]::new), (Value[])Stream.concat(Arrays.stream(existing.values), Stream.of(v)).toArray(Value[]::new), false);
    }

    public RecordValue(Location location) {
        this.names = new UniqueString[5];
        this.values = new Value[this.names.length];
        this.names[0] = BLI;
        this.values[0] = IntValue.gen(location.beginLine());
        this.names[1] = BCOL;
        this.values[1] = IntValue.gen(location.beginColumn());
        this.names[2] = ELI;
        this.values[2] = IntValue.gen(location.endLine());
        this.names[3] = ECOL;
        this.values[3] = IntValue.gen(location.endColumn());
        this.names[4] = MOD;
        this.values[4] = new StringValue(location.sourceAsUniqueString());
        this.isNorm = false;
    }

    public RecordValue(OpDefNode odn) {
        this.names = new UniqueString[2];
        this.values = new Value[this.names.length];
        this.names[0] = NAME;
        this.values[0] = new StringValue(odn.getName());
        this.names[1] = LOC;
        this.values[1] = new RecordValue(odn.getLocation());
        this.isNorm = false;
    }

    public RecordValue(OpDeclNode odn) {
        this.names = new UniqueString[2];
        this.values = new Value[this.names.length];
        this.names[0] = NAME;
        this.values[0] = new StringValue(odn.getName());
        this.names[1] = LOC;
        this.values[1] = new RecordValue(odn.getLocation());
        this.isNorm = false;
    }

    public RecordValue(OpDeclNode odn, UniqueString u, Value v) {
        this.names = new UniqueString[3];
        this.values = new Value[this.names.length];
        this.names[0] = NAME;
        this.values[0] = new StringValue(odn.getName());
        this.names[1] = LOC;
        this.values[1] = new RecordValue(odn.getLocation());
        this.names[2] = u;
        this.values[2] = v;
        this.isNorm = false;
    }

    public RecordValue(Action action) {
        Map<UniqueString, Value> parameters = action.getParameters();
        if (parameters.isEmpty()) {
            this.names = new UniqueString[2];
            this.values = new Value[this.names.length];
        } else {
            this.names = new UniqueString[4];
            this.values = new Value[this.names.length];
            this.names[2] = CTXT;
            this.values[2] = new RecordValue(parameters);
            this.names[3] = PARAMS;
            this.values[3] = new TupleValue((Value[])action.getParameters().keySet().stream().map(StringValue::new).toArray(Value[]::new));
        }
        this.names[0] = NAME;
        this.values[0] = new StringValue(action.getName());
        this.names[1] = LOC;
        this.values[1] = new RecordValue(action.getDefinition());
        this.isNorm = false;
    }

    public RecordValue(Action action, UniqueString u, Value v) {
        Map<UniqueString, Value> parameters = action.getParameters();
        this.names = new UniqueString[parameters.isEmpty() ? 3 : 5];
        this.values = new Value[this.names.length];
        this.names[0] = NAME;
        this.values[0] = new StringValue(action.getName());
        this.names[1] = LOC;
        this.values[1] = new RecordValue(action.getDefinition());
        this.names[2] = u;
        this.values[2] = v;
        if (!parameters.isEmpty()) {
            this.names[3] = CTXT;
            this.values[3] = new RecordValue(parameters);
            this.names[4] = PARAMS;
            this.values[4] = new TupleValue((Value[])action.getParameters().keySet().stream().map(StringValue::new).toArray(Value[]::new));
        }
        this.isNorm = false;
    }

    public RecordValue(TLCStateInfo info) {
        this(info.state);
    }

    public RecordValue(TLCState state) {
        OpDeclNode[] vars = state.getVars();
        this.names = new UniqueString[vars.length];
        this.values = new Value[vars.length];
        int i = 0;
        while (i < vars.length) {
            this.names[i] = vars[i].getName();
            this.values[i] = (Value)state.lookup(this.names[i]);
            ++i;
        }
        this.isNorm = false;
    }

    public RecordValue(TLCState state, Action action) {
        OpDeclNode[] vars = state.getVars();
        this.names = new UniqueString[vars.length + 1];
        this.values = new Value[vars.length + 1];
        this.names[0] = ACTION;
        this.values[0] = new RecordValue(action);
        int i = 0;
        while (i < vars.length) {
            this.names[i + 1] = vars[i].getName();
            this.values[i + 1] = (Value)state.lookup(this.names[i + 1]);
            ++i;
        }
        this.isNorm = false;
    }

    public RecordValue(TLCState state, Value defVal) {
        this(state);
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i] == null) {
                this.values[i] = defVal;
            }
            ++i;
        }
    }

    public RecordValue(TLCState state, TLCState successor, Value defVal) {
        assert (state.getVars().length == successor.getVars().length);
        OpDeclNode[] vars = state.getVars();
        this.names = new UniqueString[vars.length * 2];
        this.values = new Value[vars.length * 2];
        int i = 0;
        while (i < vars.length) {
            int j = i * 2;
            UniqueString var = vars[i].getName();
            this.names[j] = UniqueString.of(String.valueOf(var) + " ");
            this.names[j + 1] = UniqueString.of(String.valueOf(var) + "'");
            this.values[j] = (Value)state.lookup(var);
            if (this.values[j] == null) {
                this.values[j] = defVal;
            }
            this.values[j + 1] = (Value)successor.lookup(var);
            if (this.values[j + 1] == null) {
                this.values[j + 1] = defVal;
            }
            ++i;
        }
        this.isNorm = false;
    }

    @Override
    public final byte getKind() {
        return 4;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            RecordValue rcd;
            RecordValue recordValue = rcd = obj instanceof Value ? (RecordValue)((Value)obj).toRcd() : null;
            if (rcd == null) {
                if (obj instanceof ModelValue) {
                    return ((ModelValue)obj).modelValueCompareTo(this);
                }
                Assert.fail("Attempted to compare record:\n" + Values.ppr(this.toString()) + "\nwith non-record\n" + Values.ppr(obj.toString()), this.getSource());
            }
            this.normalize();
            rcd.normalize();
            int len = this.names.length;
            int cmp = len - rcd.names.length;
            if (cmp == 0) {
                int i = 0;
                while (i < len) {
                    cmp = this.names[i].compareTo(rcd.names[i]);
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++i;
                }
                i = 0;
                while (i < len) {
                    cmp = this.values[i].compareTo(rcd.values[i]);
                    if (cmp != 0) {
                        return cmp;
                    }
                    ++i;
                }
            }
            return cmp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean equals(Object obj) {
        try {
            RecordValue rcd;
            RecordValue recordValue = rcd = obj instanceof Value ? (RecordValue)((Value)obj).toRcd() : null;
            if (rcd == null) {
                if (obj instanceof ModelValue) {
                    return ((ModelValue)obj).modelValueEquals(this);
                }
                Assert.fail("Attempted to check equality of record:\n" + Values.ppr(this.toString()) + "\nwith non-record\n" + Values.ppr(obj.toString()), this.getSource());
            }
            this.normalize();
            rcd.normalize();
            int len = this.names.length;
            if (len != rcd.names.length) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (!this.names[i].equals(rcd.names[i])) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < len) {
                if (!this.values[i].equals(rcd.values[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if element:\n" + Values.ppr(elem.toString()) + "\nis in the record:\n" + Values.ppr(this.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                int rlen = this.names.length;
                Value[] newValues = new Value[rlen];
                Value arcVal = ex.path[ex.idx];
                if (arcVal instanceof StringValue) {
                    UniqueString arc = ((StringValue)arcVal).val;
                    int i = 0;
                    while (i < rlen) {
                        if (this.names[i].equals(arc)) {
                            ++ex.idx;
                            newValues[i] = this.values[i].takeExcept(ex);
                        } else {
                            newValues[i] = this.values[i];
                        }
                        ++i;
                    }
                    UniqueString[] newNames = this.names;
                    if (!this.isNorm) {
                        newNames = new UniqueString[rlen];
                        int i2 = 0;
                        while (i2 < rlen) {
                            newNames[i2] = this.names[i2];
                            ++i2;
                        }
                    }
                    return new RecordValue(newNames, newValues, this.isNorm);
                }
                MP.printWarning(2142, new String[]{Values.ppr(arcVal.toString())});
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Value res = this;
            int i = 0;
            while (i < exs.length) {
                res = ((Value)res).takeExcept(exs[i]);
                ++i;
            }
            return res;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value toRcd() {
        return this;
    }

    @Override
    public final Value toTuple() {
        return this.size() == 0 ? TupleValue.EmptyTuple : super.toTuple();
    }

    @Override
    public final Value toFcnRcd() {
        this.normalize();
        Value[] dom = new Value[this.names.length];
        int i = 0;
        while (i < this.names.length) {
            dom[i] = new StringValue(this.names[i], this.cm);
            ++i;
        }
        if (coverage) {
            this.cm.incSecondary(dom.length);
        }
        return new FcnRcdValue(dom, this.values, this.isNormalized(), this.cm);
    }

    @Override
    public final int size() {
        try {
            return this.names.length;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value apply(Value arg, int control) {
        try {
            if (!(arg instanceof StringValue)) {
                Assert.fail("Attempted to access record by a non-string argument: " + Values.ppr(arg.toString()), this.getSource());
            }
            UniqueString name = ((StringValue)arg).getVal();
            int rlen = this.names.length;
            int i = 0;
            while (i < rlen) {
                if (name.equals(this.names[i])) {
                    return this.values[i];
                }
                ++i;
            }
            Assert.fail("Attempted to access nonexistent field '" + String.valueOf(name) + "' of record\n" + Values.ppr(this.toString()), this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value apply(Value[] args, int control) {
        try {
            if (args.length != 1) {
                Assert.fail("Attempted to apply record to more than one arguments.", this.getSource());
            }
            return this.apply(args[0], control);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value select(Value arg) {
        try {
            if (!(arg instanceof StringValue)) {
                Assert.fail("Attempted to access record by a non-string argument: " + Values.ppr(arg.toString()), this.getSource());
            }
            UniqueString name = ((StringValue)arg).getVal();
            int rlen = this.names.length;
            int i = 0;
            while (i < rlen) {
                if (name.equals(this.names[i])) {
                    return this.values[i];
                }
                ++i;
            }
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            Value[] dElems = new Value[this.names.length];
            int i = 0;
            while (i < this.names.length) {
                dElems[i] = new StringValue(this.names[i]);
                ++i;
            }
            return new SetEnumValue(dElems, this.isNormalized());
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        return this.isNorm;
    }

    @Override
    public final Value normalize() {
        try {
            if (!this.isNorm) {
                int len = this.names.length;
                int i = 1;
                while (i < len) {
                    int cmp = this.names[0].compareTo(this.names[i]);
                    if (cmp == 0) {
                        Assert.fail("Field name " + String.valueOf(this.names[i]) + " occurs multiple times in record.", this.getSource());
                    } else if (cmp > 0) {
                        UniqueString ts = this.names[0];
                        this.names[0] = this.names[i];
                        this.names[i] = ts;
                        Value tv = this.values[0];
                        this.values[0] = this.values[i];
                        this.values[i] = tv;
                    }
                    ++i;
                }
                i = 2;
                while (i < len) {
                    int cmp;
                    int j = i;
                    UniqueString st = this.names[i];
                    Value val = this.values[i];
                    while ((cmp = st.compareTo(this.names[j - 1])) < 0) {
                        this.names[j] = this.names[j - 1];
                        this.values[j] = this.values[j - 1];
                        --j;
                    }
                    if (cmp == 0) {
                        Assert.fail("Field name " + String.valueOf(this.names[i]) + " occurs multiple times in record.", this.getSource());
                    }
                    this.names[j] = st;
                    this.values[j] = val;
                    ++i;
                }
                this.isNorm = true;
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            int i = 0;
            while (i < this.values.length) {
                this.values[i].deepNormalize();
                ++i;
            }
            this.normalize();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            int i = 0;
            while (i < this.values.length) {
                defined = defined && this.values[i].isDefined();
                ++i;
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        try {
            Value[] vals = new Value[this.values.length];
            int i = 0;
            while (i < this.values.length) {
                vals[i] = (Value)this.values[i].deepCopy();
                ++i;
            }
            return new RecordValue(Arrays.copyOf(this.names, this.names.length), vals, this.isNorm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        int index = vos.put(this);
        if (index == -1) {
            vos.writeByte((byte)4);
            int len = this.names.length;
            vos.writeInt(this.isNormalized() ? len : -len);
            int i = 0;
            while (i < len) {
                int index1 = vos.put(this.names[i]);
                if (index1 == -1) {
                    vos.writeByte((byte)3);
                    this.names[i].write(vos.getOutputStream());
                } else {
                    vos.writeByte((byte)26);
                    vos.writeNat(index1);
                }
                this.values[i].write(vos);
                ++i;
            }
        } else {
            vos.writeByte((byte)26);
            vos.writeNat(index);
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.normalize();
            int rlen = this.names.length;
            fp = FP64.Extend(fp, (byte)9);
            fp = FP64.Extend(fp, rlen);
            int i = 0;
            while (i < rlen) {
                String str = this.names[i].toString();
                fp = FP64.Extend(fp, (byte)3);
                fp = FP64.Extend(fp, str.length());
                fp = FP64.Extend(fp, str);
                fp = this.values[i].fingerPrint(fp);
                ++i;
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.normalize();
            int rlen = this.names.length;
            Value[] vals = new Value[rlen];
            boolean changed = false;
            int i = 0;
            while (i < rlen) {
                vals[i] = (Value)this.values[i].permute(perm);
                changed = changed || vals[i] != this.values[i];
                ++i;
            }
            if (changed) {
                return new RecordValue(this.names, vals, true);
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            int len = this.names.length;
            sb.append("[");
            if (len > 0) {
                sb.append(String.valueOf(this.names[0]) + " |-> ");
                sb = this.values[0].toString(sb, offset, swallow);
            }
            int i = 1;
            while (i < len) {
                sb.append(", ");
                sb.append(String.valueOf(this.names[i]) + " |-> ");
                sb = this.values[i].toString(sb, offset, swallow);
                ++i;
            }
            return sb.append("]");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public static IValue createFrom(IValueInputStream vos) throws EOFException, IOException {
        int index = vos.getIndex();
        boolean isNorm = true;
        int len = vos.readInt();
        if (len < 0) {
            len = -len;
            isNorm = false;
        }
        UniqueString[] names = new UniqueString[len];
        Value[] vals = new Value[len];
        int i = 0;
        while (i < len) {
            int index1;
            byte kind1 = vos.readByte();
            if (kind1 == 26) {
                index1 = vos.readNat();
                names[i] = vos.getValue(index1);
            } else {
                index1 = vos.getIndex();
                names[i] = UniqueString.read(vos.getInputStream());
                vos.assign(names[i], index1);
            }
            vals[i] = (Value)vos.read();
            ++i;
        }
        RecordValue res = new RecordValue(names, vals, isNorm);
        vos.assign(res, index);
        return res;
    }

    public static IValue createFromExternal(ValueInputStream vos) throws EOFException, IOException {
        int index = vos.getIndex();
        int len = vos.readInt();
        if (len < 0) {
            len = -len;
        }
        UniqueString[] names = new UniqueString[len];
        Value[] vals = new Value[len];
        int i = 0;
        while (i < len) {
            int index1;
            byte kind1 = vos.readByte();
            if (kind1 == 26) {
                index1 = vos.readNat();
                names[i] = vos.getValue(index1);
            } else {
                index1 = vos.getIndex();
                names[i] = UniqueString.readExternal(vos.getInputStream());
                vos.assign(names[i], index1);
            }
            vals[i] = (Value)vos.readExternal();
            ++i;
        }
        RecordValue res = new RecordValue(names, vals, false);
        vos.assign(res, index);
        return res;
    }

    @Override
    public TLCState toState() {
        TLCState state = TLCState.Empty.createEmpty();
        OpDeclNode[] vars = state.getVars();
        int i = 0;
        while (i < vars.length) {
            UniqueString name = vars[i].getName();
            int rlen = this.names.length;
            int j = 0;
            while (j < rlen) {
                if (name.equals(this.names[j])) {
                    state.bind(name, (IValue)this.values[j]);
                }
                ++j;
            }
            ++i;
        }
        return new PrintTLCState(this, state);
    }

    @Override
    public List<TLCVariable> getTLCVariables(TLCVariable prototype, Random rnd) {
        ArrayList<TLCVariable> nestedVars = new ArrayList<TLCVariable>(this.values.length);
        int i = 0;
        while (i < this.names.length) {
            UniqueString uniqueString = this.names[i];
            Value v = this.values[i];
            TLCVariable nested = prototype.newInstance(uniqueString.toString(), v, rnd);
            nested.setValue(v.toString());
            nested.setType(v.getTypeString());
            nestedVars.add(nested);
            ++i;
        }
        return nestedVars;
    }

    public static final class PrintTLCState
    extends TLCState {
        private static final UniqueString _FORMAT = UniqueString.of("_format");
        private final RecordValue rcd;
        private final TLCState state;

        public PrintTLCState(RecordValue recordValue, TLCState state) {
            this.rcd = recordValue;
            this.state = state;
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            int vlen = this.rcd.names.length;
            int idx = Arrays.asList(this.rcd.names).indexOf(_FORMAT);
            String format = idx > -1 ? ((StringValue)this.rcd.values[idx]).val.toString() : (vlen == 1 ? "%s = %s\n" : "/\\ %s = %s\n");
            int i = 0;
            while (i < vlen) {
                if (i != idx) {
                    String key = this.rcd.names[i].toString();
                    String value = Values.ppr(this.rcd.values[i]);
                    result.append(String.format(format, key, value));
                }
                ++i;
            }
            return result.toString();
        }

        public int hashCode() {
            return this.state.hashCode();
        }

        public boolean equals(Object obj) {
            return this.state.equals(obj);
        }

        @Override
        public long fingerPrint() {
            return this.state.fingerPrint();
        }

        @Override
        public boolean allAssigned() {
            return this.state.allAssigned();
        }

        @Override
        public String toString(TLCState lastState) {
            return this.state.toString(this.rcd.names, lastState);
        }

        @Override
        public String toString(UniqueString[] vars, TLCState lastState) {
            return this.state.toString(vars, lastState);
        }

        @Override
        public TLCState bind(UniqueString name, IValue value) {
            return this.state.bind(name, value);
        }

        @Override
        public TLCState bind(SymbolNode id, IValue value) {
            return this.state.bind(id, value);
        }

        @Override
        public TLCState unbind(UniqueString name) {
            return this.state.unbind(name);
        }

        @Override
        public IValue lookup(UniqueString var) {
            if (this.state.containsKey(var)) {
                return this.state.lookup(var);
            }
            return this.rcd.select(new StringValue(var));
        }

        @Override
        public boolean containsKey(UniqueString var) {
            if (this.state.containsKey(var)) {
                return true;
            }
            int i = 0;
            while (i < this.rcd.names.length) {
                if (this.rcd.names[i] == var) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public TLCState copy() {
            return this.state.copy();
        }

        @Override
        public TLCState deepCopy() {
            return this.state.deepCopy();
        }

        @Override
        public StateVec addToVec(StateVec states) {
            return this.state.addToVec(states);
        }

        @Override
        public void deepNormalize() {
            this.state.deepNormalize();
        }

        @Override
        public Set<OpDeclNode> getUnassigned() {
            return this.state.getUnassigned();
        }

        @Override
        public TLCState createEmpty() {
            return this.state.createEmpty();
        }

        public Value getRecord() {
            return this.rcd;
        }
    }
}

